/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#include "TabWidget.h"

TabWidget::TabWidget(QWidget *parent = 0)
    :QTabWidget(parent)
{
    tabBar()->setTabsClosable(true);
    connect(this, SIGNAL(currentChanged(int)), this, SLOT(currentChanged(int)));
    connect(tabBar(), SIGNAL(tabCloseRequested(int)), this, SLOT(deleteTab(int)));
}

void TabWidget::addAccount(QString user, QString pass)
{
    StatusTableView *tableView = new StatusTableView(this, user, pass, false);
    int index = addTab(tableView, QIcon(QString(":/Icons/Networks/twitter")), user);
    tabBar()->setTabButton(index, QTabBar::RightSide, NULL);
    tabBar()->setTabData(index, QString("account"));
    setCurrentIndex(count() - 1);

    connect(tableView, SIGNAL(setOnline()), this, SIGNAL(setOnline()));
    connect(tableView, SIGNAL(reply(tweet_t)), this, SLOT(doReply(tweet_t)));
    connect(tableView, SIGNAL(hideEditor()), this, SIGNAL(hideEditor()));
    connect(tableView, SIGNAL(working(bool)), this, SIGNAL(working(bool)));
    connect(tableView, SIGNAL(updateStatusBar(QString)), this, SIGNAL(updateStatusBar(QString)));
    connect(tableView, SIGNAL(selectedChanged()), this, SIGNAL(selectedChanged()));
    connect(tableView, SIGNAL(directMsg(unsigned long long int)), this, SLOT(directMsg(unsigned long long int)));

    tableViews.append(tableView);
}

void TabWidget::addSearch(QString search)
{
    StatusTableView *tableView = new StatusTableView(this, m_lastAccount, "", true);
    int index = addTab(tableView, QIcon(QString(":/Icons/Networks/twitter")), tr("Search: %1").arg(search));
    tabBar()->setTabData(index, QString("search"));
    setCurrentIndex(count() - 1);

    connect(tableView, SIGNAL(setOnline()), this, SIGNAL(setOnline()));
    connect(tableView, SIGNAL(reply(tweet_t)), this, SLOT(doReply(tweet_t)));
    connect(tableView, SIGNAL(hideEditor()), this, SIGNAL(hideEditor()));
    connect(tableView, SIGNAL(working(bool)), this, SIGNAL(working(bool)));
    connect(tableView, SIGNAL(updateStatusBar(QString)), this, SIGNAL(updateStatusBar(QString)));
    connect(tableView, SIGNAL(selectedChanged()), this, SIGNAL(selectedChanged()));
    connect(tableView, SIGNAL(directMsg(unsigned long long int)), this, SLOT(directMsg(unsigned long long int)));

    tableView->search(search);
    tableViews.append(tableView);
}

void TabWidget::removeAccount(QString user)
{
    Q_UNUSED(user);
}

void TabWidget::currentChanged(int index)
{
    if(tableViews.count() == 0)
        return;

    if(index > tableViews.count() - 1)
        return;

    disconnect(this, SIGNAL(setOnline()));
    disconnect(this, SIGNAL(reply(tweet_t)));
    disconnect(this, SIGNAL(hideEditor()));
    disconnect(this, SIGNAL(working(bool)));
    disconnect(this, SIGNAL(updateStatusBar(QString)));
    disconnect(this, SIGNAL(selectedChanged()));

    StatusTableView *tableView = tableViewAt(index);

    connect(tableView, SIGNAL(setOnline()), this, SIGNAL(setOnline()));
    connect(tableView, SIGNAL(reply(tweet_t)), this, SIGNAL(reply(tweet_t)));
    connect(tableView, SIGNAL(hideEditor()), this, SIGNAL(hideEditor()));
    connect(tableView, SIGNAL(working(bool)), this, SIGNAL(working(bool)));
    connect(tableView, SIGNAL(updateStatusBar(QString)), this, SIGNAL(updateStatusBar(QString)));
    connect(tableView, SIGNAL(selectedChanged()), this, SIGNAL(selectedChanged()));
    connect(tableView, SIGNAL(directMsg(unsigned long long int)), this, SLOT(directMsg(unsigned long long int)));
    if(tabBar()->tabData(index).toString() == tr("account"))
        m_lastAccount = tabText(index);
    emit tabChanged(index);
}

StatusTableView* TabWidget::tableViewAt(int index)
{
    return tableViews.at(index);
}

StatusTableView* TabWidget::currentTableView()
{
    return tableViewAt(currentIndex());
}

bool TabWidget::isOnline()
{
    return currentTableView()->online();
}

QString TabWidget::statusBarText()
{
    return currentTableView()->statusBarText();
}

void TabWidget::reload()
{
    currentTableView()->reload();
}

unsigned long long int TabWidget::replyId()
{
    return currentTableView()->replyId();
}

QString TabWidget::selectedUser()
{
    return currentTableView()->selectedUser();
}

void TabWidget::requestInfo()
{
    currentTableView()->loadUserInfo();
}

void TabWidget::signalReply()
{
    currentTableView()->signalReply();
}

void TabWidget::submitStatus(QString account, QString text, unsigned long long id)
{
    foreach(StatusTableView *view, tableViews)
    {
        if(view->accountName() == account || account == QString("ALL"))
        {
            view->submitTweet(text, id);
        }
    }
}

void TabWidget::submitDirectMsg(QString account, QString text, unsigned long long int id)
{
    foreach(StatusTableView *view, tableViews)
    {
        if(view->accountName() == account || account == QString("ALL"))
        {
            view->submitDM(text, id);
        }
    }
}

void TabWidget::doReply(tweet_t twInfo)
{
    QString account = currentTableView()->accountName();
    emit reply(account, twInfo);
}

void TabWidget::directMsg(unsigned long long int tid)
{
    QString account = currentTableView()->accountName();
    emit requestDM(account, tid);
}

bool TabWidget::hasAccounts()
{
    if(tableViews.count() == 0)
        return false;
    else
        return true;
}

void TabWidget::deleteTab(int index)
{
    /* don't delete an account */
    if(tabBar()->tabData(index).toString() == QString("account"))
        return;

    tableViews.removeAt(index);
    removeTab(index);
}
