/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#include "SqlArchive.h"

void SqlArchive::InitializeSqlDatabase(QString uname)
{
    if(1){
        QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE", "InitializeStatusUpdateTable");
        db.setDatabaseName(QDesktopServices::storageLocation(QDesktopServices::DataLocation) + QString("/cardinal_%1.db").arg(uname));
        db.open();
        QSqlQuery query(db);
        /* quick check to see if the cookies table actually EXISTS */
        query.exec(QString("SELECT name FROM sqlite_master WHERE type = 'table' AND name = 'status_updates';"));
        if(!query.first())
        {
            qDebug("cardinal-init: We do not have a Status Update table in SQL. Creating it.");
            /* okay, well, we don't have the cookie table, so let's create it */
            query.exec(QString("CREATE TABLE \"status_updates\" (id BIGINT NOT NULL, userid BIGINT, username VARCHAR, status VARCHAR, timestamp BIGINT, type INTEGER, favorite INTEGER DEFAULT (0), in_reply_to BIGINT, PictureURL VARCHAR);"));
        }
        query.finish();
        query.clear();
        db.close();
    }


    QSqlDatabase::removeDatabase("InitializeStatusUpdateTable");
}

void SqlArchive::InsertStatusUpdate(tweet_t statusUpdate, int type, QString uname)
{
    if(1) {
        QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE", "InsertStatusUpdate");
        db.setDatabaseName(QDesktopServices::storageLocation(QDesktopServices::DataLocation) + QString("/cardinal_%1.db").arg(uname));
        db.open();

        QSqlQuery query(db);
        query.prepare("SELECT `id` FROM `status_updates` WHERE `id` = :id;");
        query.bindValue(":id", statusUpdate.id);
        query.exec();
        if(!query.first())
        {
            query.clear();
            query.prepare("INSERT INTO `status_updates` (`id`, `userid`, `username`, `status`, `timestamp`, `type`, `favorite`, `in_reply_to`, `PictureURL`) VALUES (:id, :uid, :uname, :status, :ts, :type, :favorite, :reply, :url);");
            query.bindValue(":id", statusUpdate.id);
            query.bindValue(":uid", statusUpdate.uid);
            query.bindValue(":uname", statusUpdate.screenName);
            query.bindValue(":status", statusUpdate.tweet);
            query.bindValue(":ts", static_cast<qlonglong>(statusUpdate.time));
            query.bindValue(":type", type);
            query.bindValue(":url", statusUpdate.picUri);
            query.bindValue(":reply", statusUpdate.reply);
            query.bindValue(":favorite", (statusUpdate.favorite == true ? 1 : 0));
            query.exec();
        }
        query.finish();
        query.clear();
        db.close();
    }
    QSqlDatabase::removeDatabase("InsertStatusUpdate");
}

QList<tweet_t> SqlArchive::RetrieveStatusUpdates(QString uname)
{
    QList<tweet_t> updates;
    if(1)
    {
        QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE", "RetrieveStatusUpdates");
        db.setDatabaseName(QDesktopServices::storageLocation(QDesktopServices::DataLocation) + QString("/cardinal_%1.db").arg(uname));
        db.open();

        QSqlQuery query(db);
        query.prepare("SELECT * FROM `status_updates` ORDER BY `timestamp` ASC;");
        query.exec();
        while(query.next())
        {
            tweet_t update;
            update.id = query.value(0).toULongLong();
            update.uid = query.value(1).toULongLong();
            update.screenName = query.value(2).toString();
            update.tweet = query.value(3).toString();
            update.time = query.value(4).toUInt();
            update.favorite = (query.value(6).toInt() == 0 ? false : true);
            update.reply = query.value(7).toULongLong();
            update.picUri = query.value(8).toString();
            if(query.value(5).toInt() == 3)
                update.categories.append(QApplication::tr("Direct Messages"));

            updates.append(update);
        }
        query.finish();
        query.clear();
        db.close();
    }
    QSqlDatabase::removeDatabase("RetrieveStatusUpdates");
    return updates;
}

void SqlArchive::DeleteUpdate(unsigned long long id, QString uname)
{
    if(1)
    {
        QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE", "DeleteUpdate");
        db.setDatabaseName(QDesktopServices::storageLocation(QDesktopServices::DataLocation) + QString("/cardinal_%1.db").arg(uname));
        db.open();

        QSqlQuery query(db);
        query.prepare("DELETE FROM `status_updates` WHERE `id` = :id;");
        query.bindValue("id", id);
        query.exec();
        query.finish();
        query.clear();
        db.close();
    }
    QSqlDatabase::removeDatabase("DeleteUpdate");
}

void SqlArchive::MarkFavorite(unsigned long long id, bool favorite, QString uname)
{
    if(1)
    {
        QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE", "MarkFavorite");
        db.setDatabaseName(QDesktopServices::storageLocation(QDesktopServices::DataLocation) + QString("/cardinal_%1.db").arg(uname));
        db.open();

        QSqlQuery query(db);
        query.prepare("UPDATE `status_updates` SET `favorite` = :favorite WHERE `id` = :id;");
        if(favorite == true)
            query.bindValue("favorite", 1);
        else
            query.bindValue("favorite", 0);

        query.bindValue("id", id);
        query.exec();
        query.finish();
        query.clear();
        db.close();
    }
    QSqlDatabase::removeDatabase("MarkFavorite");
}
