/************************************

cardinal - a proper cross platthis twitter client
Copyright (C) 2009  Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#include "ProfilePictureManager.h"

ProfilePictureManager::ProfilePictureManager(QObject *parent, bool useId)
    :QObject(parent),
    m_useId(useId)
{
    m_cache = new QNetworkDiskCache(this);
    m_cache->setCacheDirectory(QDesktopServices::storageLocation(QDesktopServices::CacheLocation) + "/cardinal");
    m_http = new QNetworkAccessManager(this);
    m_http->setCache(m_cache);
    connect(m_http, SIGNAL(finished(QNetworkReply *)), this, SLOT(finished(QNetworkReply *)));
}

void ProfilePictureManager::retrievePicture(unsigned long long int id, QString picUri)
{
    if(m_useId == false)
        return;

    if(id == 0)
        return;

    if(m_waiting.contains(id))
        return;

    m_waiting.insert(id, picUri);
    QNetworkRequest request;
    request.setAttribute(QNetworkRequest::CacheLoadControlAttribute, QNetworkRequest::PreferCache);
    request.setUrl(QUrl(picUri));
    m_http->get(request);
}

void ProfilePictureManager::retrievePictureByName(QString name, QString picUri)
{
    if(m_useId == true)
        return;

    if(m_waitingAlt.contains(name))
        return;

    m_waitingAlt.insert(name, picUri);
    QNetworkRequest request;
    request.setAttribute(QNetworkRequest::CacheLoadControlAttribute, QNetworkRequest::PreferCache);
    request.setUrl(QUrl(picUri));
    m_http->get(request);
}

void ProfilePictureManager::finished(QNetworkReply *reply)
{
    if(m_useId == true)
    {
        if(m_waiting.key(reply->request().url().toString()) != 0)
        {
            emit pictureRecieved(m_waiting.key(reply->request().url().toString()), reply->readAll());
            m_waiting.remove(m_waiting.key(reply->request().url().toString()));
            return;
        }
    }
    else
    {
        if(m_waitingAlt.key(reply->request().url().toString()) != QString(""))
        {
            emit pictureRecievedAlt(m_waitingAlt.key(reply->request().url().toString()), reply->readAll());
            m_waitingAlt.remove(m_waitingAlt.key(reply->request().url().toString()));
            return;
        }
    }
}
