#include "Core.h"
#include "Decipher.h"
#include <QtXml/QDomDocument>
#include <QtGui/QMessageBox>
#include <QtCore/QUrl>
#include <QtCore/QFile>
#include <QtNetwork/QNetworkProxy>

//=====================================================================
QString Core::TWITTER_HOST = "api.twitter.com";
QString Core::VERIFY_CREDENTIALS_URL = "/account/verify_credentials.xml";
QString Core::PUBLIC_TIMELINE_URL = "/statuses/public_timeline.xml";
QString Core::GET_SINGLE_STATUS_URL = "/statuses/show/[req-id].xml";
QString Core::FEATURED_USERS_URL = "/statuses/featured.xml";
QString Core::LOGOUT_URL = "/account/end_session";
QString Core::IS_TWITTER_UP_URL = "/help/test.xml";
QString Core::USERS_TIMELINE_URL = "/statuses/user_timeline.xml";
QString Core::GET_FAVORITES_URL = "/favorites[/opt-user].xml";
QString Core::FRIENDS_TIMELINE_URL = "/statuses/friends_timeline.xml";
QString Core::POST_NEW_STATUS_URL = "/statuses/update.xml";
QString Core::GET_MENTIONS_URL = "/statuses/mentions.xml";
QString Core::REMOVE_STATUS_URL = "/statuses/destroy/[req-id].xml";
QString Core::GET_FRIENDS_URL = "/statuses/friends.xml";
QString Core::GET_FOLLOWERS_URL = "/statuses/followers.xml";
QString Core::GET_USER_DETAILS_URL = "/1/users/show.xml";
QString Core::GET_SENT_DIRECT_MESSAGES_URL = "/direct_messages/sent.xml";
QString Core::GET_RECEIVED_DIRECT_MESSAGES_URL = "/direct_messages.xml";
QString Core::SEND_NEW_DIRECT_MESSAGE_URL = "/1/direct_messages/new.xml";
QString Core::REMOVE_DIRECT_MESSAGE_URL = "/direct_messages/destroy/[req-id].xml";
QString Core::CREATE_FRIENDSHIP_URL = "/friendships/create/[req-user].xml";
QString Core::REMOVE_FRIENDSHIP_URL = "/friendships/destroy/[req-user].xml";
QString Core::FRIENDSHIP_EXIST_URL = "https://api.twitter.com/friendships/exists.xml";
QString Core::UPDATE_DELIVERY_DEVICE_URL = "/account/update_delivery_device.xml";
QString Core::REMAINING_API_REQUESTS_URL = "/account/rate_limit_status.xml";
QString Core::ADD_FAVORITE_URL = "/favorites/create/[req-id].xml";
QString Core::REMOVE_FAVORITE_URL = "/favorites/destroy/[req-id].xml";
QString Core::PROFILE_COLORS_URL = "/account/update_profile_colors.xml";
QString Core::PROFILE_IMAGE_URL = "/account/update_profile_image.xml";
QString Core::PROFILE_BACKGROUND_IMAGE_URL = "/account/update_profile_background_image.xml";
QString Core::PROFILE_URL = "/account/update_profile.xml";
QString Core::ENABLE_NOTIFICATIONS_URL = "/notifications/follow/[req-id].xml";
QString Core::DISABLE_NOTIFICATIONS_URL = "/notifications/leave/[req-id].xml";
QString Core::BLOCK_USER_URL = "/blocks/create/[req-id].xml";
QString Core::UNBLOCK_USER_URL = "/blocks/destroy/[req-id].xml";
QString Core::FRIENDS_IDS_URL = "/friends/ids[/req-id].xml";
QString Core::FOLLOWERS_IDS_URL = "/followers/ids[/req-id].xml";
QString Core::SEARCH_URL = "/search.atom";
QString Core::RETWEET_URL = "/statuses/retweet/[req-id].xml";
QString Core::RETRIEVE_RETWEETS_URL = "/1/statuses/[req-id]/retweeted_by.xml";

QString Core::USER_AGENT = "Cardinal/0.4";

QByteArray Core::key = "BfDYI8oSawBIM17C1DtU6Q";
QByteArray Core::sec = "RAYr0BZ2zjGX1KIiV7qONBwxMyywYFRYJYHb3ZFYA";


//=====================================================================
Core::Core()
{
    m_oauth = new CommieLib(key, sec, this);
	m_http = new QNetworkAccessManager(this);
	MakeConnections();
}
//=====================================================================
Core::~Core()
{
    if(m_http)
        delete m_http;
}

void Core::setToken(token_t token)
{
    m_token = token;
}
//=====================================================================
void Core::SetProxy(SERVER::PROXY_TYPE type, const QString hostName, \
                    quint16 port, const QString user, const QString password)
{
    QNetworkProxy::ProxyType proxy_type = QNetworkProxy::NoProxy;
    switch(type)
    {
        case SERVER::NO_PROXY:
            proxy_type = QNetworkProxy::NoProxy;
        break;
        case SERVER::SOCKS5_PROXY:
            proxy_type = QNetworkProxy::Socks5Proxy;
        break;
        case SERVER::HTTP_PROXY:
            proxy_type = QNetworkProxy::HttpProxy;
        break;
    }

    QNetworkProxy m_proxy = QNetworkProxy(proxy_type, hostName, port, user, password);
    m_http->setProxy(m_proxy);
}
//=====================================================================
void Core::Abort()
{
    /* need a better way to abort */
    //m_http->deleteResource(m_http->requ);
}
//=====================================================================
void Core::MakeConnections()   
{
    connect(m_http, SIGNAL(finished(QNetworkReply*)), this, SLOT(ReqFinished(QNetworkReply*)));
}
//=====================================================================
void Core::Done ( bool /*error*/ )
{
    emit QueryDone();
}
//=====================================================================
void Core::DataReadProgress ( int /*done*/, int /*total*/ )
{
    //emit OnMessageReceived(QString::number(done).toStdString()+" / "+QString::number(total).toStdString());
}
//=====================================================================
int Core::MakeGetRequest(QString req, ParameterMap params, bool useOAuth)
{
    QNetworkRequest request;
    QUrl url;
    url.setScheme("http");
    url.setHost("api.twitter.com");
	/* if(reqId == Returnables::SEARCH_STRING)
		url.setHost("search.twitter.com"); */
    url.setPath(req);
   
    if(useOAuth == true)
    {
        if(!m_token.token.isEmpty() || !m_token.secret.isEmpty())
            request.setRawHeader("Authorization", m_oauth->obtainAuthorizationHeader(url, 0x004, m_token, params));
    }

    if(!params.isEmpty())
    {
        foreach(QByteArray value, params.values())
        {
            url.addQueryItem(params.key(value), value);
        }
    }
    request.setUrl(url);
	m_http->get(request);

    qDebug() << "cardinal - making GET request to " << qPrintable(request.url().toString());
    return 1;
}
//=====================================================================
int Core::MakePostRequest(QString path, QByteArray req, bool isMultipart, bool useOAuth)
{
    Q_UNUSED(isMultipart);
    QNetworkRequest request;
    QUrl url;
    url.setScheme("http");
    url.setHost("api.twitter.com");
    url.setPath(path);
    request.setUrl(url);

    QStringList parts = QString(req).split("&");
    ParameterMap params;
    if(!req.isEmpty())
    {
        foreach(QString item, parts)
        {
            params.insert(item.split("=")[0].toUtf8(),
                QByteArray::fromPercentEncoding(item.split("=")[1].toUtf8()));
        }
    }
    if(useOAuth == true)
    {
        if(!m_token.token.isEmpty() || !m_token.secret.isEmpty())
            request.setRawHeader("Authorization", m_oauth->obtainAuthorizationHeader(url, 0x002, m_token, params));
    }

    m_http->post(request, req);
    qDebug() << "cardinal - making POST request to " << qPrintable(request.url().toString());

    return 1;
}

//=====================================================================

void Core::ReqFinished(QNetworkReply *reply)
{
    QByteArray response = reply->readAll();
    QString responseString(response);
    if(responseString.contains("<error"))
    {
        qDebug() << responseString;
    }

    QByteArray u = reply->url().toString().toUtf8();

    if(!response.isNull())
    {
        /* we need some <error> handler here */
        QString path = reply->request().url().path();
        QStringList urlParts = reply->url().path().split("/");
        urlParts.removeLast();
        QString basePath = urlParts.join("/");

        if(path == Core::PUBLIC_TIMELINE_URL)
        {
            Returnables::PublicTimeline *pTimeline;
            pTimeline = Decipher::Instance()->PublicTimeline(response);
            emit OnResponseReceived(pTimeline);
        }
        else if(path == Core::SEARCH_URL)
        {
            Returnables::SearchResult *sResult;
            sResult = Decipher::Instance()->SearchResult(response);
            emit OnResponseReceived(sResult);
        }
        else if(path == Core::FRIENDS_TIMELINE_URL)
        {
            Returnables::FriendsTimeline *fTimeline;
            fTimeline = Decipher::Instance()->FriendsTimeline(response);
            emit OnResponseReceived(fTimeline);
        }
        else if(path == Core::GET_SINGLE_STATUS_URL)
        {
            Returnables::SingleStatus *singleStatus;
            singleStatus = Decipher::Instance()->SingleStatus(response);
            emit OnResponseReceived(singleStatus);
        }
        else if(path == Core::FEATURED_USERS_URL)
        {
            Returnables::FeaturedUsers *featuredUsers;
            featuredUsers = Decipher::Instance()->FeaturedUsers(response);
            emit OnResponseReceived(featuredUsers);
        }
        else if(path == Core::VERIFY_CREDENTIALS_URL)
        {
            Returnables::VerifyCredentials *verifyCredentials;
            verifyCredentials = Decipher::Instance()->VerifyCredentials(response);
            if(verifyCredentials != NULL)
                emit OnResponseReceived(verifyCredentials);
            else
                emit badLogin();
        }
        else if(path == Core::IS_TWITTER_UP_URL)
        {
            Returnables::TwitterUp *twitterUp;
            twitterUp = Decipher::Instance()->TwitterUp(response);
            emit OnResponseReceived(twitterUp);
        }
        else if(path == Core::USERS_TIMELINE_URL)
        {
            Returnables::UserTimeline *userTimeline;
            userTimeline = Decipher::Instance()->UserTimeline(response);
            emit OnResponseReceived(userTimeline);
        }
        else if(path == Core::GET_FAVORITES_URL)
        {
            Returnables::Favorites *favorites;
            favorites = Decipher::Instance()->Favorites(response);
            emit OnResponseReceived(favorites);
        }
        else if(path == Core::POST_NEW_STATUS_URL)
        {
            Returnables::NewStatus *newStatus;
            newStatus = Decipher::Instance()->NewStatus(response);
            emit OnResponseReceived(newStatus);
        }
        else if(path == Core::GET_MENTIONS_URL)
        {
            Returnables::RecentMentions *mentions;
            mentions = Decipher::Instance()->RecentMentions(response);
            emit OnResponseReceived(mentions);
        }
        else if(path == Core::REMOVE_STATUS_URL)
        {
            Returnables::RemoveStatus *removedStatus;
            removedStatus = Decipher::Instance()->RemoveStatus(response);
            emit OnResponseReceived(removedStatus);
        }
        else if(path == Core::GET_FRIENDS_URL)
        {
            Returnables::Friends *friends;
            friends = Decipher::Instance()->Friends(response);
            emit OnResponseReceived(friends);
        }
        else if(path == Core::GET_FOLLOWERS_URL)
        {
            Returnables::Followers *followers;
            followers = Decipher::Instance()->Followers(response);
            emit OnResponseReceived(followers);
        }
        else if(path == Core::GET_USER_DETAILS_URL)
        {
            Returnables::UserDetails *userDetails;
            userDetails = Decipher::Instance()->UserDetails(response);
            emit OnResponseReceived(userDetails);
        }
        else if(path == Core::GET_SENT_DIRECT_MESSAGES_URL)
        {
            Returnables::SentDirectMessages *sentDirectMessages;
            sentDirectMessages = Decipher::Instance()->SentDirectMessages(response);
            emit OnResponseReceived(sentDirectMessages);
        }
        else if(path == Core::GET_RECEIVED_DIRECT_MESSAGES_URL)
        {
            Returnables::ReceivedDirectMessages *receivedDirectMessages;
            receivedDirectMessages = Decipher::Instance()->ReceivedDirectMessages(response);
            emit OnResponseReceived(receivedDirectMessages);
        }
        else if(path == Core::SEND_NEW_DIRECT_MESSAGE_URL)
        {
            Returnables::SendDirectMessage *sendDirectMessage;
            sendDirectMessage = Decipher::Instance()->SendDirectMessage(response);
            emit OnResponseReceived(sendDirectMessage);
        }
        else if(path == Core::CREATE_FRIENDSHIP_URL)
        {
            Returnables::AddFriendship *addFriendship;
            addFriendship = Decipher::Instance()->AddFriendShip(response);
            emit OnResponseReceived(addFriendship);
        }
        else if(path == Core::REMOVE_FRIENDSHIP_URL)
        {
            Returnables::RemoveFriendship *removeFriendship;
            removeFriendship = Decipher::Instance()->RemoveFriendship(response);
            emit OnResponseReceived(removeFriendship);
        }
        else if(path == Core::FRIENDSHIP_EXIST_URL)
        {
            Returnables::FriendshipExist *friendshipExists;
            friendshipExists = Decipher::Instance()->FriendshipExist(response);
            emit OnResponseReceived(friendshipExists);
        }
        else if(path == Core::UPDATE_DELIVERY_DEVICE_URL)
        {
            Returnables::DeliveryDevice *deliveryDevice;
            deliveryDevice = Decipher::Instance()->DeliveryDevice(response);
            emit OnResponseReceived(deliveryDevice);
        }
        else if(path == Core::REMAINING_API_REQUESTS_URL)
        {
            Returnables::ApiRequests *apiRequests;
            apiRequests = Decipher::Instance()->ApiRequests(response);
            emit OnResponseReceived(apiRequests);
        }
        else if(path.startsWith("/favorites/create/"))
        {
            Returnables::AddFavorite *addFavorite;
            addFavorite = Decipher::Instance()->AddFavorite(response);
            emit OnResponseReceived(addFavorite);
        }
        else if(path.startsWith("/favorites/destroy/"))
        {
            Returnables::RemoveFavorite *removeFavorite;
            removeFavorite = Decipher::Instance()->RemoveFavorite(response);
            emit OnResponseReceived(removeFavorite);
        }
        else if(path == Core::PROFILE_COLORS_URL)
        {
            Returnables::ProfileColors *profileColors;
            profileColors = Decipher::Instance()->ProfileColors(response);
            emit OnResponseReceived(profileColors);
        }
        else if(path == Core::PROFILE_IMAGE_URL)
        {
            Returnables::ProfileImage *profileImage;
            profileImage = Decipher::Instance()->ProfileImage(response);
            emit OnResponseReceived(profileImage);
        }
        else if(path == Core::PROFILE_BACKGROUND_IMAGE_URL)
        {
            Returnables::ProfileBackgroundImage *profileBackgroundImage;
            profileBackgroundImage = Decipher::Instance()->ProfileBackgroundImage(response);
            emit OnResponseReceived(profileBackgroundImage);
        }
        else if(path == Core::PROFILE_URL)
        {
            Returnables::Profile *profile;
            profile = Decipher::Instance()->Profile(response);
            emit OnResponseReceived(profile);
        }
        else if(path == Core::ENABLE_NOTIFICATIONS_URL)
        {
            Returnables::EnableNotifications *enableNotifications;
            enableNotifications = Decipher::Instance()->EnableNotifications(response);
            emit OnResponseReceived(enableNotifications);
        }
        else if(path == Core::DISABLE_NOTIFICATIONS_URL)
        {
            Returnables::DisableNotifications *disableNotifications;
            disableNotifications = Decipher::Instance()->DisableNotifications(response);
            emit OnResponseReceived(disableNotifications);
        }
        else if(path == Core::BLOCK_USER_URL)
        {
            Returnables::BlockUser *blockUser;
            blockUser = Decipher::Instance()->BlockUser(response);
            emit OnResponseReceived(blockUser);
        }
        else if(path == Core::UNBLOCK_USER_URL)
        {
            Returnables::UnBlockUser *unBlockUser;
            unBlockUser = Decipher::Instance()->UnBlockUser(response);
            emit OnResponseReceived(unBlockUser);
        }
        else if(path == Core::FRIENDS_IDS_URL)
        {
            Returnables::FriendsIDs *friendsIDs;
            friendsIDs = Decipher::Instance()->FriendsIDs(response);
            emit OnResponseReceived(friendsIDs);
        }
        else if(path == Core::FOLLOWERS_IDS_URL)
        {
            Returnables::FollowersIDs *followersIDs;
            followersIDs = Decipher::Instance()->FollowersIDs(response);
            emit OnResponseReceived(followersIDs);
        }
        else if(path.startsWith("/statuses/retweet/"))
        {
            Returnables::RetweetedStatus *retweet;
            retweet = Decipher::Instance()->RetweetedStatus(response);
            emit OnResponseReceived(retweet);
        }
        else if(path.startsWith("/statuses/destroy"))
        {
            Returnables::RemoveStatus *removeStatus;
            removeStatus = Decipher::Instance()->RemoveStatus(response);
            emit OnResponseReceived(removeStatus);
        }
        else if(path.endsWith("retweeted_by.xml"))
        {
            Returnables::RetweetsForStatus *retweets;
            retweets = Decipher::Instance()->RetweetsForStatus(response);
            emit OnResponseReceived(retweets);
        }
        else
        {
            qDebug() << "cardinal - an unknown message was returned. " << response;
			emit OnMessageReceived(response);
		}
	}
}
//=====================================================================
/*void Core::responseHeaderReceived(const QHttpResponseHeader &resp)
{
	switch(resp.statusCode())
	{
		case SERVER::OK:
            emit OnStatusReceived(SERVER::OK);
			break;
		case SERVER::NOT_MODIFIED:
            emit OnStatusReceived(SERVER::NOT_MODIFIED);
			break;
		case SERVER::BAD_REQUEST:
            emit OnStatusReceived(SERVER::BAD_REQUEST);
			break;
		case SERVER::NOT_AUTHORIZED:
            emit OnStatusReceived(SERVER::NOT_AUTHORIZED);
			break;
		case SERVER::FORBIDDEN:
            emit OnStatusReceived(SERVER::FORBIDDEN);
			break;
		case SERVER::NOT_FOUND:
            emit OnStatusReceived(SERVER::NOT_FOUND);
			break;
		case SERVER::INTERNAL_SERVER_ERROR:
            emit OnStatusReceived(SERVER::INTERNAL_SERVER_ERROR);
			break;
		case SERVER::BAD_GATEWAY:
            emit OnStatusReceived(SERVER::BAD_GATEWAY);
			break;
		case SERVER::SERVICE_UNAVAILABLE:
            emit OnStatusReceived(SERVER::SERVICE_UNAVAILABLE);
			break;
		default:
            emit OnStatusReceived(SERVER::UNKNOWN);
			break;
	}
}*/
//=====================================================================
void Core::GetPublicTimeline()
{
    MakeGetRequest(PUBLIC_TIMELINE_URL);

}
//=====================================================================
void Core::GetSingleStatus(QString id)
{
    QString req;
    req = GET_SINGLE_STATUS_URL;
    req.replace("[req-id]",id);
    MakeGetRequest(req);

}
//=====================================================================
void Core::GetFeaturedUsers()
{
    MakeGetRequest(FEATURED_USERS_URL);

}
//=====================================================================
void Core::Logout()
{
    MakePostRequest(LOGOUT_URL,"");

}
//=====================================================================
void Core::IsTwitterUp()
{
    MakeGetRequest(IS_TWITTER_UP_URL);

}
//=====================================================================
void Core::GetUsersTimeline(unsigned long long int id = 0)
{
    QString buildUrl = USERS_TIMELINE_URL;
    ParameterMap params;

    if(id != 0)
    {
        params.insert("user_id", QByteArray::number(id));
    }

    MakeGetRequest(buildUrl, params);
}
//=====================================================================
void Core::GetFavorites(QString user  /*=""*/, unsigned int page  /*=1*/)
{
    QString buildUrl = GET_FAVORITES_URL;
    
    if(!user.isEmpty())
        buildUrl.replace("[/opt-user]","/"+user);
    else
        buildUrl.replace("[/opt-user]","");
    
	buildUrl += "?page="+QString::number(page);

    MakeGetRequest(buildUrl);

}
//=====================================================================
void Core::GetFriendsTimeline(SERVER::Option1 *opt  /*=NULL*/)
{
    QString buildUrl = FRIENDS_TIMELINE_URL;
    ParameterMap params;
    
    if(opt)
    {       
        QString since_id    = QString::number(opt->since_id);
        QString max_id = QString::number(opt->max_id);
        QString count      = QString::number(opt->count);
        QString page       = QString::number(opt->page);
        
        if(!since_id.isEmpty())
            params.insert("since_id", since_id.toUtf8());
        if(!max_id.isEmpty())
            params.insert("max_id", max_id.toUtf8());
        if(!count.isEmpty())
            params.insert("count", count.toUtf8());
        if(!page.isEmpty())
            params.insert("page", page.toUtf8());

    }

    MakeGetRequest(buildUrl, params);

}
//=====================================================================
void Core::PostNewStatus(QString status, QString in_reply_to_status_id, QString source)
{
    QByteArray encodedUrl, req;
    encodedUrl = QUrl::toPercentEncoding(status);
    
    req = "status=";
    req += encodedUrl;

    if(!in_reply_to_status_id.isEmpty())
    {
        req += "&in_reply_to_status_id=";
        req += in_reply_to_status_id;
    }

    if(!source.isEmpty())
    {
    req += "&source=";
    req += source;
    }
    
    MakePostRequest(POST_NEW_STATUS_URL,req);

}
//=====================================================================
void Core::GetRecentMentions(SERVER::Option3 *opt  /*=NULL*/)
{
    QString buildUrl = GET_MENTIONS_URL;
    
    if(opt)
    {
        QString since_id    = QString::number(opt->since_id);
        QString max_id = QString::number(opt->max_id);
        QString page       = QString::number(opt->page);

        buildUrl += "?since_id="+since_id;
        buildUrl += "&max_id="+max_id;
        buildUrl += "&page="+page;
    }

    MakeGetRequest(buildUrl);

}
//=====================================================================
void Core::RemoveStatus(QString id)
{
    QString buildUrl = REMOVE_STATUS_URL;
    buildUrl = buildUrl.replace("[req-id]",id);
    
    MakePostRequest(buildUrl,"");

}
//=====================================================================
void Core::GetFriends(unsigned long long int id)
{
    QString buildUrl = GET_FRIENDS_URL;
    ParameterMap params;
    if(id != 0)
        params.insert("user_id", QByteArray::number(id));

    MakeGetRequest(buildUrl, params);

}
//=====================================================================
void Core::GetFollowers(unsigned long long int id)
{
    QString buildUrl = GET_FOLLOWERS_URL;
    ParameterMap params;
    if(id != 0)
        params.insert("user_id", QByteArray::number(id));

    MakeGetRequest(buildUrl, params);
}
//=====================================================================
void Core::GetUserDetails(unsigned long long int id)
{
    ParameterMap params;
    QString buildUrl = GET_USER_DETAILS_URL;
    params.insert("user_id", QByteArray::number(id));
    MakeGetRequest(buildUrl, params, true);
}
//=====================================================================
void Core::GetSentDirectMessages(SERVER::Option5 *opt  /*=NULL*/)
{
    QString buildUrl = GET_SENT_DIRECT_MESSAGES_URL;
    
    if(opt)
    {       
        QString since_id    = QString::number(opt->since_id);
        QString page       = QString::number(opt->page);
        
        buildUrl += "&since_id="+since_id;
        buildUrl += "&page="+page;
    }

    MakeGetRequest(buildUrl);

}
//=====================================================================
void Core::GetReceivedDirectMessages(SERVER::Option5 *opt  /*=NULL*/)
{
    QString buildUrl = GET_RECEIVED_DIRECT_MESSAGES_URL;
    
    if(opt)
    {       
        QString since_id    = QString::number(opt->since_id);
        QString page       = QString::number(opt->page);
        
        buildUrl += "&since_id="+since_id;
        buildUrl += "&page="+page;
    }

    MakeGetRequest(buildUrl);

}
//=====================================================================
void Core::SendDirectMessage(unsigned long long int id, QString text)
{
    QByteArray encodedText, req;
    encodedText = QUrl::toPercentEncoding(text);
    
    req = "user=";
    req += QByteArray::number(id);
    req += "&";
    req += "text=";
    req += encodedText;
    
    MakePostRequest(SEND_NEW_DIRECT_MESSAGE_URL,req);

}
//=================================================================================================================
void Core::RemoveDirectMessage(QString id)
{
    QString buildUrl = REMOVE_DIRECT_MESSAGE_URL;
    
    buildUrl = buildUrl.replace("[req-id]",id);

    MakePostRequest(buildUrl,"");

}
//=====================================================================
void Core::AddFriendship(QString user, bool follow)
{
    QByteArray req;
	QString buildUrl;

	buildUrl = CREATE_FRIENDSHIP_URL;
	buildUrl = buildUrl.replace("[req-user]",user);
  
        req = "follow=";
	req += follow ? "true" : "false";
      
    MakePostRequest(buildUrl,req);

}
//=====================================================================
void Core::RemoveFriendship(QString user)
{
    QString buildUrl = REMOVE_FRIENDSHIP_URL;
    
    buildUrl = buildUrl.replace("[req-user]",user);
    
    MakePostRequest(buildUrl,"");

}
//=====================================================================
void Core::FriendshipExist(QString user_a, QString user_b)
{
    QString buildUrl = FRIENDSHIP_EXIST_URL;
    
    buildUrl += "?user_a="+user_a;
    buildUrl += "&user_b="+user_b;
    
    MakeGetRequest(buildUrl);

}
//=====================================================================
void Core::VerifyCredentials()
{
    MakeGetRequest(VERIFY_CREDENTIALS_URL);

}
//=====================================================================
void Core::UpdateDeliveryDevice(SERVER::DEVICES device)
{
	QByteArray req;

	switch(device)
    {
        case SERVER::SMS:
            req = "device=sms";
            break;
        case SERVER::IM:
            req = "device=im";
           break;
        case SERVER::NONE:
            req = "device=none";
            break;
    }
    
    MakePostRequest(UPDATE_DELIVERY_DEVICE_URL,req);

}
//=====================================================================
void Core::RemainingApiRequests()
{
    MakeGetRequest(REMAINING_API_REQUESTS_URL);

}
//=====================================================================
void Core::AddFavorite(QString id)
{
    QString buildUrl = ADD_FAVORITE_URL;
    buildUrl = buildUrl.replace("[req-id]",id);
    MakePostRequest(buildUrl,"");

}
//=====================================================================
void Core::RemoveFavorite(QString id)
{
    QString buildUrl = REMOVE_FAVORITE_URL;
    
    buildUrl = buildUrl.replace("[req-id]",id);
    
    MakePostRequest(buildUrl,"");

}
//=====================================================================
void Core::UpdateProfileColors(QString background_color, QString text_color, QString link_color, QString sidebar_fill_color, QString sidebar_border_color)
{
    QByteArray req = "";

    if(!background_color.isEmpty())
    {
        req = "profile_background_color=";
        req += background_color.remove("#").toAscii();
        req += "&";
    }
    if(!text_color.isEmpty())
    {
        req += "profile_text_color=";
        req += text_color.remove("#").toAscii();
        req += "&";
    }
    if(!link_color.isEmpty())
    {
        req += "profile_link_color=";
        req += link_color.remove("#").toAscii();
        req += "&";
    }
    if(!sidebar_fill_color.isEmpty())
    {
        req += "profile_sidebar_fill_color=";
        req += sidebar_fill_color.remove("#").toAscii();
        req += "&";
    }
    if(!sidebar_border_color.isEmpty())
    {
        req += "profile_sidebar_border_color=";
        req += sidebar_border_color.remove("#").toAscii();
    }

    if(req.endsWith("&")){ req.chop(1); }

    MakePostRequest(PROFILE_COLORS_URL,req);

}
//=====================================================================
void Core::UpdateProfile(QString name, QString email, QString url, QString location, QString description)
{
    QByteArray req = "";

    if(!name.isEmpty())
    {
        req = "name=";
        req += QUrl::toPercentEncoding(name);
        req += "&";
    }
    if(!email.isEmpty())
    {
        req += "email=";
        req += QUrl::toPercentEncoding(email);
        req += "&";
    }
    if(!url.isEmpty())
    {
        req += "url=";
        req += QUrl::toPercentEncoding(url);
        req += "&";
    }
    if(!location.isEmpty())
    {
        req += "location=";
        req += QUrl::toPercentEncoding(location);
        req += "&";
    }
    if(!description.isEmpty())
    {
        req += "description=";
        req += QUrl::toPercentEncoding(description);
    }

    if(req.endsWith("&")){ req.chop(1); }

    MakePostRequest(PROFILE_URL,req);

}
//=====================================================================
void Core::EnableNotifications(QString id)
{
    QString buildUrl = ENABLE_NOTIFICATIONS_URL;

    buildUrl = buildUrl.replace("[req-id]",id);

    MakePostRequest(buildUrl,"");

}
//=====================================================================
void Core::DisableNotifications(QString id)
{
    QString buildUrl = DISABLE_NOTIFICATIONS_URL;

    buildUrl = buildUrl.replace("[req-id]",id);

    MakePostRequest(buildUrl,"");

}
//=====================================================================
void Core::BlockUser(QString id)
{
    QString buildUrl = BLOCK_USER_URL;

    buildUrl = buildUrl.replace("[req-id]",id);

    MakePostRequest(buildUrl,"");

}
//=====================================================================
void Core::UnBlockUser(QString id)
{
    QString buildUrl = UNBLOCK_USER_URL;

    buildUrl = buildUrl.replace("[req-id]",id);

    MakePostRequest(buildUrl,"");

}
//=====================================================================
void Core::GetFriendsIDs(QString id, QString user_id, QString screen_name)
{
    QString buildUrl = FRIENDS_IDS_URL;

    if(!id.isEmpty())
    {
        buildUrl.replace("[/req-id]", "/" + id);
    }
    else if(!user_id.isEmpty())
    {
        buildUrl.replace("[/req-id]","");
        buildUrl += "?user_id=" + user_id;
    }
    else if(!screen_name.isEmpty())
    {
        buildUrl.replace("[/req-id]","");
        buildUrl += "?screen_name="+screen_name;
    }
    else
    {
        buildUrl.replace("[/req-id]","");
    }

    MakeGetRequest(buildUrl);

}
//=====================================================================
void Core::GetFollowersIDs(QString id, QString user_id, QString screen_name)
{
    QString buildUrl = FOLLOWERS_IDS_URL;

    if(!id.isEmpty())
    {
        buildUrl.replace("[/req-id]", "/" + id);
    }
    else if(!user_id.isEmpty())
    {
        buildUrl.replace("[/req-id]","");
        buildUrl += "?user_id=" + user_id;
    }
    else if(!screen_name.isEmpty())
    {
        buildUrl.replace("[/req-id]","");
        buildUrl += "?screen_name="+screen_name;
    }
    else
    {
        buildUrl.replace("[/req-id]","");
    }

    MakeGetRequest(buildUrl);

}
//=====================================================================

void Core::SearchByString(QString search)
{
    QNetworkRequest request;
    QString tmpHost = "search.twitter.com";
    QUrl url("http://search.twitter.com/search.atom");
    url.addQueryItem("q", search);

    QByteArray u = url.toString().toUtf8();
    qDebug(u);
    request.setUrl(url);
    request.setRawHeader("User-Agent", "Cardinal/0.4");
    m_http->get(request);
    MakeGetRequest(url.toString());
}

void Core::Retweet(QString id)
{
    QString buildUrl = RETWEET_URL;
    buildUrl = buildUrl.replace("[req-id]", id);
    MakePostRequest(buildUrl,"");    
}

void Core::RetrieveRetweets(QString id)
{
    QString buildUrl = RETRIEVE_RETWEETS_URL;
    buildUrl = buildUrl.replace("[req-id]", id);
    ParameterMap params;
    params.insert("count", "99");
    MakeGetRequest(buildUrl, params);
}
