/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#ifndef INFOWND_H
#define INFOWND_H

#include "cardinal.h"
#include "UserView.h"
#include "ProfilePictureManager.h"

class InfoWnd : public QDialog
{
    Q_OBJECT
public:
    InfoWnd(user_t tw, QString uname, QWidget *parent = 0);
    ~InfoWnd();
protected slots:
    void followTriggered();
    void blockTriggered();
    void websiteTriggered();
    void twitterTriggered();
    void pictureRecieved(unsigned long long int id, QByteArray pictureData);
    void birdResponseReceived(Returnables::Response*);
    void sendDM();
    void submitDirectMsg(QString, QString, unsigned long long int);
protected:
    void closeEvent(QCloseEvent *);
signals:
    void blockUser(unsigned long long int uid, QString userName);
    void follow(unsigned long long int uid, QString userName);
    void unfollow(unsigned long long int uid, QString userName);
    void getUserInfo(unsigned long long int);
private:
    QGridLayout *gridLayout;
    QTabWidget *tabWidget;
    QWidget *about;
    QGridLayout *gridLayout_2;
    QLabel *labelPixmap;
    QLabel *labelName;
    QPushButton *btnClose;
    QPushButton *btnSendDM;
    QLabel *labelScreenName;
    QPushButton *btnFollow;
    QLabel *labelLocation;
    QSpacerItem *verticalSpacer;
    QPushButton *btnBlock;
    QLabel *labelBiography;
    QPushButton *btnWebsite;
    QSpacerItem *verticalSpacer_2;
    QPushButton *btnTwitter;
    QSpacerItem *verticalSpacer_3;
    QLabel *labelStats;
    QWidget *tabFollowers;
    QGridLayout *gridLayout_3;
    UserView *followers;
    QWidget *tabFollowing;
    QGridLayout *gridLayout_4;
    UserView *following;
    user_t m_user;
    ProfilePictureManager *m_profilePics;
    QTwitLib *m_bird;
    Editor *m_editor;
    QString m_uname;
};

#endif
