/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/


#ifndef USERVIEW_H
#define USERVIEW_H

#include "cardinal.h"
#include "ProfilePictureManager.h"

class UserView : public QWidget
{
    Q_OBJECT
public:
    UserView(QList<user_t> users, QWidget *parent = 0);
    ~UserView();
    void setInformativeText(QString text);
    void updateUserList(QList<user_t>);
signals:
    void getUserInfo(unsigned long long int id);
    void closed();
protected slots:
    void itemDoubleClicked(QListWidgetItem *item);
    void pictureRecieved(unsigned long long int id, QByteArray pictureData);
protected:
    void closeEvent(QCloseEvent *event);
private:
    QGridLayout *gridLayout;
    QLabel *m_infoLabel;
    QListWidget *m_userList;
    QList<user_t> m_users;
    ProfilePictureManager *m_profilePics;
};

#endif /* USERVIEW */
