/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#ifndef TWITTERREGISTRATION_H
#define TWITTERREGISTRATION_H

#include "cardinal.h"
#include "oauth.h"

class OAuthAuthenticationPage : public QWizardPage
{
    Q_OBJECT
public:
    OAuthAuthenticationPage(QWidget *parent);
protected:
    void initializePage();
    bool validatePage();
protected slots:
    void recievedRequestToken(token_t token);
    void recievedAccessToken(token_t token);
    void recievedError(int error);
private:
    CommieLib *oAuth;
    token_t m_token;
    QGridLayout *gridLayout_2;
    QSpacerItem *verticalSpacer_2;
    QLabel *label_4;
    QLabel *label_5;
    QLineEdit *m_userName;
    QLabel *label_6;
    QLineEdit *m_pin;
};

class FinishPage : public QWizardPage
{
    Q_OBJECT
public:
    FinishPage(QWidget *parent);
    void setError();
private:
    QGridLayout *gridLayout_3;
    QLabel *label_2;
    QSpacerItem *verticalSpacer_3;
};

class TwitterRegistrationWizard : public QWizard
{
    Q_OBJECT
public:
    TwitterRegistrationWizard(QWidget *parent);
    ~TwitterRegistrationWizard();
    void setError();
    QString account();
private:
    QWizardPage *welcome;
    OAuthAuthenticationPage *auth;
    FinishPage *finished;
    QGridLayout *gridLayout;
    QLabel *label;
    QSpacerItem *verticalSpacer;
};


#endif // TWITTERREGISTRATION_H
