/************************************

cardinal - a proper cross platform twitter client
Copyright (C) 2009-2010 Chris Fuenty <zimmy@zimmy.co.uk>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

************************************/

#ifndef TABWIDGET_H
#define TABWIDGET_H

#include <QTabWidget>
#include "cardinal.h"
#include "StatusTableView.h"

class TabWidget : public QTabWidget
{
    Q_OBJECT
public:
    TabWidget(QWidget *parent);
    void addAccount(QString user, QString pass);
    void addSearch(QString search);
    void removeAccount(QString user);
    QString statusBarText();
    bool isWorking();
    bool isOnline();
    bool hasAccounts();
    StatusTableView* tableViewAt(int index);
    StatusTableView* currentTableView();
    QString selectedUser();
    unsigned long long int replyId();
signals:
    void updateStatusBar(QString);
    void working(bool);
    void hideEditor();
    void addNotification(tweet_t);
    void reply(QString account, tweet_t);
    void requestDM(QString account, unsigned long long int tid);
    void setOnline();
    void tabChanged(int index);
    void selectedChanged();
protected slots:
    void currentChanged(int index);
    void requestInfo();
    void reload();
    void signalReply();
    void doReply(tweet_t);
    void directMsg(unsigned long long int);
    void deleteTab(int index);
    void submitStatus(QString account, QString text, unsigned long long int id = 0);
    void submitDirectMsg(QString account, QString text, unsigned long long int id);
protected:
    //void removeTab(int index);
private:
    QList<StatusTableView*> tableViews;
    QString m_lastAccount;
};

#endif // TABWIDGET_H
