/* 
 * Copyright (C) 2002-2004 Benoit Poulot-Cazajous
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _POSIX_C_SOURCE 199506L
#define _XOPEN_SOURCE 500
#define _GNU_SOURCE

#include <sys/types.h>
#include <sys/param.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/select.h>
#include <alloca.h>
#include <signal.h>
#include <limits.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <poll.h>
#include <dlfcn.h>

#include "cachecc1.h"

/*
 * Variables that depend on the environnement
 */
char *env_dir = 0;
char *env_log = 0;
char *env_opts = 0;
char *env_ifgcc3 = 0;
char *env_distcc = 0;
char *env_distccdir = 0;
char *env_ignorewarnings = 0;

/*
 * Options, set by CACHECC1_OPTS
 */
unsigned char opts[256];

extern char **environ;

static inline int match(char *p, char *q, int l)
{
    return (l == strlen(q)) && !strncmp(p, q, l);
}

/*
 * Read the environnement and set env_* variables
 */
char **read_env(char *envp[])
{
    int i, l;

    env_dir = 0;
    env_log = 0;
    env_opts = 0;
    env_ifgcc3 = 0;
    env_distcc = 0;
    env_distccdir = 0;
    env_ignorewarnings = 0;

    if (!envp) envp = environ;
    for (i = 0; envp[i]; i++) {
        char *p, *q;
        q = envp[i];
        if (q[0] != 'C') continue;
        if (strncmp(q, "CACHECC1_", 9)) continue;
        q += 9;
        for (l = 0; q[l] && q[l] != '='; ++l) continue;
        if (q[l] != '=') continue;
        p = &q[++l];
        if (match(q, "DIR=", l)) env_dir = p;
        if (match(q, "LOG=", l)) env_log = p;
        if (match(q, "OPTS=", l)) env_opts = p;
        if (match(q, "ifgcc3=", l)) env_ifgcc3 = p;
        if (match(q, "DISTCC=", l)) env_distcc = p;
        if (match(q, "DISTCCDIR=", l)) env_distccdir = p;
        if (match(q, "IGNOREWARNINGS=", l)) env_ignorewarnings = p;
    }
    for (i = 0; i < 256; ++i) opts[i] = 0;
    if (env_opts) {
        for (i = 0; env_opts[i]; ++i) {
            unsigned char c = env_opts[i];
            opts[c]++;
        }
    }
    return envp;
}

/*
 * Send bytes to a file
 */
int send(int f, void *p, int n)
{
    while (n > 0) {
        int m = write(f, p, n);
        if (m <= 0) break;
        p = (void*)((char*)p+m);
        n -= m;
    }
    return n;
}

/*
 * Copy a file.
 * Delete incomplete copies
 */
void copy(int f, int g, char *despair)
{
    unsigned char buf[65536];
    while (1) {
        int n = read(f, buf, sizeof(buf));
        if (n == 0) return;
        if (n < 0) break;
        n = send(g, buf, n);
        if (n != 0) break;
    }
    if (despair) {
        unlink(despair);
        fprintf(stderr, "Warning: failed to write %s\n", despair);
            /* aborting here would not be user friendly, so continue */
    }
}

#ifdef DEBUG
void debug_str(char *s)
{
    while (*s) {
        char c = *s++;
        write (2, &c, 1);
    }
}

void debug_intr(unsigned int x)
{
    if (x) {
        char c = '0' + (x % 10);
        debug_intr(x / 10);
        write(2, &c, 1);
    }
}

void debug_int(unsigned int x)
{
    debug_str("<");
    debug_intr(x);
    debug_str(">");
}
#endif

/* arch-tag: f412f17a-14fc-4413-a653-50f00b25e78b */
