# Custom Aqsis specific version of FindFLTK
SET(AQSIS_FLTK_FOUND 0)

SET(AQSIS_FLTK_INCLUDE_SEARCHPATH)
SET(AQSIS_FLTK_FLUID_SEARCHPATH)
SET(AQSIS_FLTK_PLATFORM_DEPENDENT_LIBS)

#  Platform dependent libraries required by FLTK
IF(WIN32)
  SET( AQSIS_FLTK_PLATFORM_DEPENDENT_LIBS ${AQSIS_FLTK_PLATFORM_DEPENDENT_LIBS} wsock32 comctl32 gdi32 ole32 uuid )
ENDIF(WIN32)

IF(WIN32)
	IF(AQSIS_WIN32LIBS)
		SET(AQSIS_FLTK_INCLUDE_SEARCHPATH ${AQSIS_FLTK_INCLUDE_SEARCHPATH} ${AQSIS_WIN32LIBS}/FLTK/include)
		SET(AQSIS_FLTK_FLUID_SEARCHPATH ${AQSIS_FLTK_FLUID_SEARCHPATH} ${AQSIS_WIN32LIBS}/FLTK/bin)
		IF(MSVC AND MSVC80)
			SET(AQSIS_FLTK_LIBRARIES_DIR ${AQSIS_WIN32LIBS}/FLTK/lib/vc8_sp1 CACHE PATH "Semi-colon separated list of paths to search for fltk libraries")
		ELSEIF(MSVC AND MSVC90)
			SET(AQSIS_FLTK_LIBRARIES_DIR ${AQSIS_WIN32LIBS}/FLTK/lib/vc9_sp1 CACHE PATH "Semi-colon separated list of paths to search for fltk libraries")
		ELSE(MSVC AND MSVC80)
			IF(MINGW)
				SET(AQSIS_FLTK_LIBRARIES_DIR ${AQSIS_WIN32LIBS}/FLTK/lib/mingw CACHE PATH "Semi-colon separated list of paths to search for fltk libraries")
			ENDIF(MINGW)
		ENDIF(MSVC AND MSVC80)
	ENDIF(AQSIS_WIN32LIBS)
ELSE(WIN32)
	SET(AQSIS_FLTK_LIBRARIES_DIR "" CACHE PATH "Semi-colon separated list of paths to search for fltk libraries")
ENDIF(WIN32)

FIND_PATH(AQSIS_FLTK_INCLUDE_DIR
			FL/Fl.H
			PATHS ${AQSIS_FLTK_INCLUDE_SEARCHPATH}
			DOC "Location of the FLTK headers"
			)

FIND_LIBRARY(AQSIS_FLTK_LIB
			fltk
			PATHS ${AQSIS_FLTK_LIBRARIES_DIR}
			DOC "Location of the FLTK base library"
			)
MARK_AS_ADVANCED(AQSIS_FLTK_LIB)

FIND_PROGRAM(FLTK_FLUID_EXECUTABLE
			fluid
			PATHS ${AQSIS_FLTK_FLUID_SEARCHPATH} ENV PATH
			DOC "Location of the FLTK fluid application"
			)

STRING(COMPARE EQUAL "${AQSIS_FLTK_INCLUDE_DIR}" "AQSIS_FLTK_INCLUDE-NOTFOUND" AQSIS_FLTK_INCLUDE_NOTFOUND)
STRING(COMPARE EQUAL "${AQSIS_FLTK_LIB}" "AQSIS_FLTK_LIB-NOTFOUND" AQSIS_FLTK_LIB_NOTFOUND)
STRING(COMPARE EQUAL "${FLTK_FLUID_EXECUTABLE}" "FLTK_FLUID_EXECUTABLE-NOTFOUND" AQSIS_FLTK_FLUID_NOTFOUND)

IF(NOT AQSIS_FLTK_LIB_NOTFOUND AND NOT AQSIS_FLTK_INCLUDE_NOTFOUND)
	SET(AQSIS_FLTK_FOUND 1)
	SET(AQSIS_FLTK_LIBRARIES ${AQSIS_FLTK_LIB} ${AQSIS_FLTK_PLATFORM_DEPENDENT_LIBS})
ENDIF(NOT AQSIS_FLTK_LIB_NOTFOUND AND NOT AQSIS_FLTK_INCLUDE_NOTFOUND)
IF(NOT AQSIS_FLTK_FLUID_NOTFOUND)
	SET(AQSIS_FLUID_FOUND 1)
ENDIF(NOT AQSIS_FLTK_FLUID_NOTFOUND)

