/*
 */
/*
WNN7 CLIENT LIBRARY--SOFTWARE LICENSE TERMS AND CONDITIONS


Wnn7 Client Library :
(C) Copyright OMRON Corporation.       1995,1998,2000,2001 all rights reserved.
(C) Copyright OMRON Software Co., Ltd. 1995,1998,2000,2001 all rights reserved.

Wnn Software :
(C) Copyright Kyoto University Research Institute for Mathematical Sciences
     1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright ASCTEC, Inc.  1987, 1988, 1989, 1990, 1991, 1992, 1993

Preamble

These Wnn7 Client Library--Software License Terms and Conditions
 (the "License Agreement") shall state the conditions under which you are
 permitted to copy, distribute or modify the software which can be used
 to create Wnn7 Client Library (the "Wnn7 Client Library").  The License
 Agreement can be freely copied and distributed verbatim, however, you
 shall NOT add, delete or change anything on the License Agreement.

OMRON Corporation and OMRON Software Co., Ltd. (collectively referred to
 as "OMRON") jointly developed the Wnn7 Software (development code name
 is FI-Wnn), based on the Wnn Software.  Starting from November, 1st, 1998,
 OMRON publishes the source code of the Wnn7 Client Library, and OMRON
 permits anyone to copy, distribute or change the Wnn7 Client Library under
 the License Agreement.

Wnn7 Client Library is based on the original version of Wnn developed by
 Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 OMRON Corporation and ASTEC Inc.

Article 1.  Definition.

"Source Code" means the embodiment of the computer code, readable and
 understandable by a programmer of ordinary skills.  It includes related
 source code level system documentation, comments and procedural code.

"Object File" means a file, in substantially binary form, which is directly
 executable by a computer after linking applicable files.

"Library" means a file, composed of several Object Files, which is directly
 executable by a computer after linking applicable files.

"Software" means a set of Source Code including information on its use.

"Wnn7 Client Library" the computer program, originally supplied by OMRON,
 which can be used to create Wnn7 Client Library.

"Executable Module" means a file, created after linking Object Files or
 Library, which is directly executable by a computer.

"User" means anyone who uses the Wnn7 Client Library under the License
 Agreement.

Article 2.  Copyright

2.1  OMRON Corporation and OMRON Software Co., Ltd. jointly own the Wnn7
 Client Library, including, without limitation, its copyright.

2.2  Following words followed by the above copyright notices appear
 in all supporting documentation of software based on Wnn7 Client Library:

  This software is based on the original version of Wnn7 Client Library
  developed by OMRON Corporation and OMRON Software Co., Ltd. and also based on
  the original version of Wnn developed by Kyoto University Research Institute
  for Mathematical Sciences (KURIMS), OMRON Corporation and ASTEC Inc.

Article 3.  Grant

3.1  A User is permitted to make and distribute verbatim copies of
 the Wnn7 Client Library, including verbatim of copies of the License
 Agreement, under the License Agreement.

3.2  A User is permitted to modify the Wnn7 Client Library to create
 Software ("Modified Software") under the License Agreement.  A User
 is also permitted to make or distribute copies of Modified Software,
 including verbatim copies of the License Agreement with the following
 information.  Upon modifying the Wnn7 Client Library, a User MUST insert
 comments--stating the name of the User, the reason for the modifications,
 the date of the modifications, additional terms and conditions on the
 part of the modifications if there is any, and potential risks of using
 the Modified Software if they are known--right after the end of the
 License Agreement (or the last comment, if comments are inserted already).

3.3  A User is permitted to create Library or Executable Modules by
 modifying the Wnn7 Client Library in whole or in part under the License
 Agreement.  A User is also permitted to make or distribute copies of
 Library or Executable Modules with verbatim copies of the License
 Agreement under the License Agreement.  Upon modifying the Wnn7 Client
 Library for creating Library or Executable Modules, except for porting
 a computer, a User MUST add a text file to a package of the Wnn7 Client
 Library, providing information on the name of the User, the reason for
 the modifications, the date of the modifications, additional terms and
 conditions on the part of the modifications if there is any, and potential
 risks associated with using the modified Wnn7 Client Library, Library or
 Executable Modules if they are known.

3.4  A User is permitted to incorporate the Wnn7 Client Library in whole
 or in part into another Software, although its license terms and
 conditions may be different from the License Agreement, if such
 incorporation or use associated with the incorporation does NOT violate
 the License Agreement.

Article 4. Warranty

THE WNN7 CLIENT LIBRARY IS PROVIDED BY OMRON ON AN "AS IS" BAISIS.
  OMRON EXPRESSLY DISLCIAMS ANY AND ALL WRRANTIES, EXPRESS OR IMPLIED,
 INCLUDING, WITHOUT LIMITATION, WARRANTIES OF MERCHANTABILITY AND FITNESS
 FOR A PARTICULAR PURPOSE, IN CONNECTION WITH THE WNN7 CLIENT LIBRARY
 OR THE USE OR OTHER DEALING IN THE WNN7 CLIENT LIBRARY.  IN NO EVENT
 SHALL OMRON BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, PUNITIVE
 OR CONSEQUENTIAL DAMAGES OF ANY KIND WHATSOEVER IN CONNECTION WITH THE
 WNN7 CLIENT LIBRARY OR THE USE OR OTHER DEALING IN THE WNN7 CLIENT
LIBRARY.

***************************************************************************
Wnn7 Client Library :
(C) Copyright OMRON Corporation.       1995,1998,2000,2001 all rights reserved.
(C) Copyright OMRON Software Co., Ltd. 1995,1998,2000,2001 all rights reserved.

Wnn Software :
(C) Copyright Kyoto University Research Institute for Mathematical Sciences
     1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright ASCTEC, Inc.  1987, 1988, 1989, 1990, 1991, 1992, 1993
***************************************************************************

Comments on Modifications:
*/
/***********************************************************************
			rk_main.c
						88. 6.10   
						93.10.19

	޻Ѵ¾ϥɤѴץࡣ
	ASCIIɻѤȤƤ롣
	ΥեϡѴΥᥤ롼
***********************************************************************/
/*	Version 3.0
 */
#include "rk_multi.h"
#include "rk_fundecl.h"


struct	matchpair /*	ߥޥåƤѿֹȡޥåʸ
			Ȥݻ*/
{
	int	hennum;
	letter	ltrmch;
};

letter	memory[SIZALL]; /* Ѵбɽ䡢ѿѰʤɤΰ */
struct	dat	dat_data[LINALL]; /* бɽΰԤȤΥǡؤΥݥ */
letter	*hensudefhyo[VARTOT]; /* ѿȤѰǡؤΥݥ */
struct	matchpair	henmatch[VARTOT]; /* ѿΥޥå򤿤Ƥ */

#ifdef KDSP
#  ifdef MVUX
letter	displine[DSPLIN]; /* ǥХå	 ɽΰʬ򵭲 */
#  endif
#endif

letter	*curdis;
int	codein_len;
letter	*codeout, *remainkbf;
letter	ungetc_buf = EOLTTR; /* romkan_ungetcʸ򤷤ƤХåե */
letter	unnext_buf = EOLTTR; /* romkan_unnext		   		  */

letter	(*keyin_method)(); /* ؿΥɥ쥹 */
int	(*bytcnt_method)(); /* ХȥȴؿΥɥ쥹 */
int	(*kbytcnt_method)(); /* ϲѥХȥȴؿΥɥ쥹 */
char	prv_modfnm[REALFN] = "\0"; /* ⡼ɽ̾ϤΥѥ̾ˤ¸ */
/* ꤬ø! */

#define DISOUT ((flags & RK_NONISE) ? rk_output : disout)
/* ե饰ͤromkan_init3()ꤵ졢RK_NONISEΥӥåȤͤ
    ɸ0äDISOUTɸͤdisoutrk_outputѤȡ
    ʽLTREOFˤڽФʤâϤɬ֤褦
    Ƥ˸¤ꡢEOLTTR֤ˡ*/


char	eofflg; /* romkan_next()LTREOF褿Ȥˡromkan_henkan()1
		   ˤ롣ͤ0ʤѴбɽ(error)̵뤷ơ
		   ܽХåե̤ꥳɤ⡢ŪѴ롣
		   LTREOF褿̤ˤϤФ褦˻ꤵƤ
		   νԤâνϵޤ館Դˡ
		   eofflg2*/

letter	evalbuf[2][2][OUTSIZ];
char	ebf_sw = '\0';
letter	saishu_out[OUTSIZ];
letter	delchr, delchr2 = EOLTTR, nisedl; /* DELΥ饯ĤޤǻƤ*/

modetyp	chgmod(), incmod(), decmod();


/* letter֤ؿڤʰˤcharΤΤ⺮äƤ */

static letter	mchedsrc();
letter	romkan_next(), romkan_unnext();
letter	romkan_getc(), romkan_ungetc(), *romkan_henkan();
letter 	*romkan_henkan_body();
letter	to_zenalpha(), to_zenhira(), to_zenkata();
/* to_zenhira;kata ʸޤȤˤʤ*/

void BUGreport();
static void maeato_henkan(), add_at_eof(), rk_delete(),
set_rubout(), mchevl(), codeout_chg(), ltrevlcpy();
int match();
static int p_eq(), hen_ikisrc(), henkan_ok(), rk_rst(),
head_bytecount();
extern void readdata(), romkan_reset_body(), hank_setup(), to_hankata(),
to_digit(), dakuadd(), handakuadd(), allchgmod();
extern int ltov();


static
letter	*ltrcpy(lp1, lp2)
letter	*lp1, *lp2;
{
	letter	*org;

	org = lp1;
	while((*lp1++ = *lp2++) != EOLTTR);
	return(org);
}

/** letter˰ʸĤʤ */
static
letter	*ltr1cat(lp, l)
letter	*lp, l;
{
	letter	*org;

	org = lp;
	totail(lp);
	*lp++ = l;
	*lp = EOLTTR;
	return(org);
}

/** ʸ˰ʸĤʤ롣ltr1catchar */
char	*chrcat(s, c)
char	*s, c;
{
	char	*org;

	org = s;
	strtail(s);
	*s++ = c;
	*s = '\0';
	return(org);
}

static
letter	*ltrcat(lp1, lp2)
letter	*lp1, *lp2;
{
	letter	*org;

	org = lp1;
	totail(lp1);
	ltrcpy(lp1, lp2);
	return(org);
}

/** letterlp2γǤκǾ̥ӥåȤΩƤƤ顢lp1θˤĤʤ롣*/
static
letter	*bitup_ltrcat(lp1, lp2)
letter	*lp1, *lp2;
{
	letter	*org;

	org = lp1;
	totail(lp1);

	while((*lp1 = *lp2++) != EOLTTR) *lp1++ |= HG1BIT;
	/** lp2 ƤκǾ̥ӥåȤΩƤ롣*lp2NISEBP(rk_spclval.h
		     define)ʤɤΤȤϺǽ餫Ǿ̤ΩäƤ뤫褤 */

	return(org);
}

/** ltrcatȡ̤ʸ˥ݥ󥿤äƤ*/
letter	*ltrgrow(lp1, lp2)
letter	*lp1, *lp2;
{
	totail(lp1);
	while((*lp1 = *lp2++) != EOLTTR) lp1++;
	return(lp1);
}

static int
ltrlen(lp)
letter	*lp;
{
	letter	*org;

	for(org = lp; *lp != EOLTTR; lp++);
	return(lp - org);
}

/**	letterκǸʸؤΥݥ󥿤֤âʸФƤ
	Τޤ֤*/
letter	*ltrend(lp)
letter	*lp;
{
	return((*lp != EOLTTR) ? (lp + ltrlen(lp) - 1) : lp);
}

/**	ʸκǸʸؤΥݥ󥿤֤ltrend()charǡltrend()
	Ʊ͡ʸΤȤ㤬롣*/
char	*strend(s)
char	*s;
{
	return(*s ? (s + strlen(s) - 1) : s);
}

int
ltrcmp(lp1, lp2)
letter	*lp1, *lp2;
{
	for(; *lp1 == *lp2; lp1++, lp2++) if(*lp1 == EOLTTR) return(0);
	return(*lp1 > *lp2 ? 1 : -1);
}

static
letter	*ltr_rindex(lp, l)
letter	l, *lp;
{
	letter	*lp2;

	for(lp += ltrlen(lp2 = lp); lp2 != lp; ) if(*--lp == l) return(lp);
	return(NULL);
}

/** ʸʸ򥫥åȤ롣*/
letter	*ltr1cut(lp)
letter	*lp;
{
	int	l;

	if(0 == (l = ltrlen(lp))) BUGreport(0); /* Illegal POP */
	*(lp + --l) = EOLTTR;
	return(lp);
}

/** letterΰʸĹʸѴ */
static
letter	*ltr_to_ltrseq(lp, l)
letter	*lp, l;
{
	*lp++ = l;
	*lp-- = EOLTTR;
	return(lp);
}

/** char󤫤letterļФâ'\0'EOLTTRѤ */
letter
letterpick(lbfpptr, cur_rk)
uns_chr **lbfpptr;
ARGS *cur_rk;
{
	letter	l = 0;
	register int	i;

	for(i = (*bytcnt_method)(*lbfpptr); i; i--)
		l = (l << 8) + *(*lbfpptr)++;
	return(l == 0 ? EOLTTR : l);
}

/**	Ϥ줿ɤʸñ̤ˤޤȤ롣âEOFLTREOFrk_spclval.h
	ˤˤѤ롣*/
letter
romkan_next_body(cur_rk)
ARGS *cur_rk;
{
	letter	in;
	int	i, n;
	uns_chr c;

	/* unnextƤϡФ*/
	if(unnext_buf != EOLTTR)
		return(in = unnext_buf, unnext_buf = EOLTTR, in);

	if( (letter)EOF == (in = (*keyin_method)() )) return(LTREOF);
	c = (in &= 0xff);
	n = (*kbytcnt_method)(&c);
	for(i = 1; i < n; i++) in = (in << 8) + ((*keyin_method)() & 0xff);
	return(in);
}

letter
romkan_next()
{
	ARGS *cur_rk = NULL;

	letter x;
	x = romkan_next_body(cur_rk);
	return x;
}

/*	letterʸ l charʸ c ӡɥޡƱΡletter
	ɥޡEOLTTRcharΤ'\0'ˤפȤߤʤ*/
#define ltrchreq(l, c) ((l) == ((c) != 0 ? (c) : EOLTTR))

/** letterʸcharʸ â羮ӤʤȤƤ */
int
ltrstrcmp(l, s)
register letter *l;
register char	*s;
{
	for(; ltrchreq(*l, *s); l++, s++) if(*s == 0) return(0);
	return((*l < (uns_chr)*s || *l == EOLTTR)? -1 : 1);
}

/** Ǹ˥ޥåʸ ĤޤurabufκǸ塣urabufEOLTTR֤ */
static letter
lastmch(cur_rk)
ARGS *cur_rk;
{
	return(*(ltrend(urabuf)));
}

/* end of 'letter' functions */


/** ѴХåեΥꥢ */
void
romkan_clear_body(cur_rk)
ARGS *cur_rk;
{
#ifdef KDSP
#  ifdef MVUX
	*displine = EOLTTR;
#  endif
#endif
	ungetc_buf = *keybuf = *urabuf = *disout = *rk_output = EOLTTR;
	curdis = DISOUT;
	lastoutlen = lastkbflen = 0;
}

void
romkan_clear()
{
	ARGS *cur_rk = NULL;

	romkan_clear_body(cur_rk);
}

/**	ɽɤ߹Ѵν򤹤롣part 1*/
int
romkan_init
(modhyo, delchr_, chmoutf, keyinfn, bytcntfn)
char	*modhyo, chmoutf;
letter	delchr_;
letter	(*keyinfn)();
int	(*bytcntfn)(); /* ξܺ٤romkan_init3򻲾 */
{
	return(
	    romkan_init2
	    (modhyo, delchr_, chmoutf, keyinfn, bytcntfn, 0, 0, 0));
}

#define ifflg(a, b) ((a) ? (b) : 0)

/**	ɽɤ߹Ѵν򤹤롣part 2: ϤФɬ
	֤褦ˤ뤫Хåե򥯥ꥢ뤫ɤʤɤġ*/
int
romkan_init2
(modhyo, delchr_, chmoutf, keyinfn, bytcntfn, keyackf, restartf, nonisecodf)
char	*modhyo, chmoutf, keyackf, restartf, nonisecodf;
letter	delchr_;
letter	(*keyinfn)();
int	(*bytcntfn)(); /* ξܺ٤romkan_init3򻲾 */
{
	return(
	    romkan_init3
	    (modhyo, delchr_, toNISE(delchr_), EOLTTR,
	    keyinfn, bytcntfn, (int (*)())NULL,
	    restartf,
	    ifflg(chmoutf, RK_CHMOUT) |
	    ifflg(keyackf, RK_KEYACK) |
	    ifflg(nonisecodf, RK_NONISE) |
	    RK_DSPNIL));
}

/**	ɽɤ߹Ѵν򤹤롣part 3*/
int
romkan_init3
(modhyo, delchr_, nisedl_, delchr2_, keyinfn, bytcntfn, kbytcntfn, restartf, flags_)
char	*modhyo;	/* ⡼ɽ̾ϤΥѥ̾ */
letter	delchr_;	/* DELȤƻȤ */
letter	nisedl_;	/* DELȤƻȤ */
letter	delchr2_;	/* DELȤƻȤɤĤ礽Τ⤦ */
letter	(*keyinfn)();	/* ؿ */
int	(*bytcntfn)();	/* Хȥȴؿ */
int	(*kbytcntfn)(); /* βѥХȥȴؿNULLλ
			   bytcntfnƱΤȤ */
char	restartf;
/*	rk_rst()⤫ƤФ줿Ωĥե饰줬ΩĤȡХåե򥯥ꥢ
	˺Ѥޤλϥ顼лΥå⾯ۤʤ */
int	flags_;
/* ʲΥե饰Ѳġrk_spclval.hˤ
	RK_CHMOUT:⡼ɥ󥸤Τ餻륳ɤ֤
	RK_KEYACK:Фɬ֤
	RK_DSPNIL:romkan_disp(off)modeΥǥեȤʸˤ뤫
	RK_NONISE:ɤФʤ褦ˤ뤫
	RK_REDRAW:Wnnüե饰redrawѤΥե饰Фɤ
	RK_SIMPLD:deleteưñˤ뤫
	RK_VERBOS:verbose⡼ɤǵ
 */
{
	int	errcod; /* ν1Τ */
	ARGS 	*cur_rk;

	cur_rk = NULL;

	/* ɤФromkan_clearǻȤΤǡե饰
		    ˤäƤʤȤʤ*/
	if((flags = flags_) & RK_VERBOS){
		fprintf(stderr, "romkan_init invoked.\r\n");
		fflush(stderr);
	}

#ifdef	OMAKE
	if(modhyo == NULL) takeoka(-1); /* ޤ̾ϼ¹Ԥʤ */
#endif	/* OMAKE */

	keyin_method = keyinfn;
	bytcnt_method = (bytcntfn == NULL ? head_bytecount : bytcntfn);
	kbytcnt_method = (kbytcntfn == NULL ? bytcnt_method : kbytcntfn);
	strcpy(prv_modfnm, modhyo);

	delchr = delchr_;
	nisedl = nisedl_;
	delchr2 = delchr2_;
	/**	¤DELΥ饯ĤޤǻƤ롣ܡdelchr2ϡ̤
		ȤͤEOLTTRˤ̵뤵롣ʳϡdelchr2Ϥ
		delchrϤ줿ΤƱ񤤤򤹤롣*/

	if((errcod = setjmp(env0)) != 0){
		fprintf(stderr,"romkan_init failed.");
		if(!restartf){
			romkan_reset_body(cur_rk);
			/*	fprintf(stderr,
						      "No conversion is currently performed."); */
			fprintf(stderr, "\r\n");
		} else {
			fprintf(stderr,
			    "Conversion method was unchanged.\r\n");
		}
	} else {
		readdata(memory, dat_data, hensudefhyo, modhyo, cur_rk);
		if(!restartf){
			romkan_clear_body(cur_rk);
			hank_setup();
		}
	}

	if(!errcod && (flags & RK_VERBOS)){
		fprintf(stderr, "romkan_init finished.\r\n");
		fflush(stderr);
	}

	return(errcod); /* ｪλʤ0 */
}

/**	ХȥȴؿΥǥեȡsλؤƤäƤΤ
	Хȥɤ֤
	romkan_nextաǤϡХȥȴؿͤ
	ΰʸܤˤΤ߰¸ȲꤷƤ롣*/
static int
head_bytecount(s)
uns_chr *s;
{
#ifdef IKIS
	return((*s <= 0xa0 || *s == 0xff)? 1 : 2);
#else
	return((((*s <= 0xa0) && (*s != HNKAK1)) || (*s == 0xff))? 1 : 2);
#endif
}

/** Ѵ줿ʸ缡֤ */
letter
romkan_getc_body(cur_rk)
ARGS *cur_rk;
{
	letter	l;

	/* ungetcƤϡФ*/
	if(ungetc_buf != EOLTTR)
		return(l = ungetc_buf, ungetc_buf = EOLTTR, l);

	while(*curdis == EOLTTR){
		/* romkan_next()ͤLTREOFλ⡢Τޤɤ*/
		curdis = romkan_henkan_body(romkan_next_body(cur_rk), cur_rk);

		/* keyackflg0ʤ顢󤬤ɬ֤
				    ᡢ֤٤ΤʤEOLTTR֤Ȥˤ롣*/
		if(flags & RK_KEYACK) break;
	}

	if(EOLTTR != (l = *curdis)) curdis++;
	return(l);
	/* ʪʸʤ顢HG1BITΩäƤ롣*/
	/* ̤ʥ(㤨еBEEPȤNISEBP)֤Ȥ롣
		    rk_spclval.hƤ롣*/
}

letter
romkan_getc()
{
	letter x;
	ARGS *cur_rk = NULL;

	x = romkan_getc_body(cur_rk);
	return x;
}

/**	romkan_getcβ̴ؿȤơϤʸä
	Ѵ̤ʸϤ롣*/
letter *
romkan_henkan_body(mae_in, cur_rk)
letter	mae_in;
ARGS *cur_rk;
{
	letter	mae_out[2], *p, *x;

	/* if(*curdis != EOLTTR){p = curdis; curdis = nil; return(p);} */
	/* Ǥmae_in̵뤵 */
	curdis = nil;

	/* ؤϤϾˤʸ */
	mae_out[0] = mae_out[1] = EOLTTR;

	eofflg = rk_errstat = 0;
	*rk_output = *disout = EOLTTR;

	maeato_henkan(mae_in, mae_out, usemaehyo, cur_rk);
	rk_input = *mae_out;

	if(rk_input == LTREOF){
		/* LTREOF褿硢(error)̵뤷ܽХåե
				    Ѵ롣Τeofflg1ˤ롣θ塢̤
				    ˡLTREOF褿̥ɡʻꤵƤСˤȡ
				    LTREOFĤʤ*/
		eofflg = 1;
		match(cur_rk);

		eofflg = 2;
		add_at_eof(cur_rk); /* codeoutˡLTREOF褿Фɤ롣*/
		ltr1cat(codeout, LTREOF);

		ltrcat(disout, codeout);
		ltrcat(rk_output, codeout);
	} else if(rk_input == EOLTTR){
		/* EOLTTR褿⡢ƱͤνԤLTREOF
				    Ĥʤʤʤromkan_getc()ƤǤ
				    ʤromkan_next()EOLTTR֤ʤˡ*/
		eofflg = 1;
		match(cur_rk);
	} else if(rk_input == delchr || rk_input == delchr2){
		/* delchr2̤ʤ餽ͤEOLTTRʤΤrk_inputʤ*/
		rk_delete(rk_input, cur_rk);
	} else {
		ltr1cat(keybuf, rk_input);
		ltr1cat(disout, toNISE(rk_input));
		match(cur_rk);
	}

	if(!(flags & RK_CHMOUT)){
		/* chmoutflg0λϡCHMSIGФʤ*/
		for(p = DISOUT; ; p++){
			while(*p == CHMSIG) ltrcpy(p, p + 1);
			if(*p == EOLTTR) break;
		}
	}

	if((flags & RK_REDRAW) && NULL != (p = ltr_rindex(disout, nisedl))){
		for(p++; *p != EOLTTR || (ltr1cat(disout, REDRAW), 0); p++)
			if(!isSPCL(*p)) break;
	}
	/* wnnredrawΥե饰ΩäƤơdisoutnisedlʸü쥳ɤΤ
		    ǽäƤ顢REDRAWФơWnnѴԤredraw򤵤롣*/

	x = DISOUT;
	return x;
}

letter *
romkan_henkan(mae_in)
letter  mae_in;
{
	letter *x;
	ARGS *cur_rk = NULL;

	x = romkan_henkan_body(mae_in, cur_rk);
	return x;
}


/* ǥХåѴؿ */
#ifdef KDSP
#  ifdef MVUX

void
pridbg2(a, b, c)
char	*a, *c;
letter	*b;
{
	printf("%s", a); 
	dump_fordbg(b); 
	printf("%s", c);
}

int
ltr_displen(l)
letter	l;
{
	while(l >= 256) l >>= 8;

	if(l == 0) return(0);
	if(l < ' ') return(0);
	if(168 <= l && l <= 170) return(1);
	return(l > 160 ? 2 : 1);
}

void
dump_fordbg(lp)
letter	*lp;
{
	while(*lp != EOLTTR) printf("%x/", *lp++);
}

void
print_fordbg(lp)
letter	*lp;
{
	while(*lp != EOLTTR) putletter(*lp++ & ~HG1BIT);
}

void
print_ltrseq(lp, cur_rk)
letter	*lp;
ARGS *cur_rk;
{
	while(*lp != EOLTTR) print_ltr(*lp++ & ~HG1BIT, cur_rk);
}

void
print_ltr(l, cur_rk)
letter	l;
ARGS *cur_rk;
{
	letter	*disptail;
	int	i;

	if(!isSPCL(l)) l &= ~HG1BIT;

	if(l == CHMSIG)
#ifdef CHMDSP
		printf("...mode=%s\n",romkan_dispmode_body(cur_rk))
#endif
		    ;
		else
#define BEEPCH	'\007'
#define NEWLIN	'\n'
		if(l == BEEPCH || l == NISEBP) putchar(BEEPCH);
		else
			if(l == NEWLIN){
				*displine = *keybuf = *urabuf = EOLTTR;
				lastoutlen = lastkbflen = 0;
				putchar(l);
			}
	else
				if(l == delchr || l == nisedl){
					if(*displine == EOLTTR) putchar(BEEPCH);
					else {
						disptail = ltrend(displine);
						for(i = ltr_displen(*disptail); i; i--)
							printf("\031 \031");
						*disptail = EOLTTR;
					}
				}
				else {
					ltr1cat(displine, l);
					putletter(l);
				}
}

#  endif /* of #ifdef MVUX */
#endif
/* ǥХåѴؿ */


/** DELϤ줿Ȥν򤹤 */
static void
rk_delete(input_del, cur_rk)
letter	input_del;
ARGS *cur_rk;
{
	if(ltrlen(keybuf) > ((flags & RK_SIMPLD) ? 0 : lastkbflen)){
		ltr1cut(keybuf);
		set_rubout(disout, 1, nisedl);
	} else {
		if(*urabuf != EOLTTR && !(flags & RK_SIMPLD)){
			ltr1cut(ltrcpy(keybuf, urabuf));
			*urabuf = EOLTTR;

			set_rubout(rk_output, lastoutlen, input_del);

			set_rubout(disout, lastkbflen, nisedl);
			bitup_ltrcat(ltrcat(disout, rk_output), keybuf);

			lastkbflen = lastoutlen = 0;
		} else {
			set_rubout(disout, 1, input_del);
			set_rubout(rk_output, 1, input_del);
		}
	}
}

/**	letter lp1  lp2 Υޥåߤ롣ͤϡlp1lp2Ƭ
	פλ -1lp1ޤϤƬlp2פΤȤϰĹlp2
	ʸλޤࡣξͤ0ˡʳ -2
	lp2¦˼ޤޤƤɾ򤹤롣lp1¦ˤϼޤǤϤ */
static int
prefixp(lp1, lp2, cur_rk)
letter	*lp1, *lp2;
ARGS *cur_rk;
{
	/* 1ԥޥå뤴Ȥˡޤmatch򥯥ꥢƤ顣
		   Ĥޤꡢhenmatch[0] . ltrmch = EOLTTR; ȤƤ*/

	register int	mch_len = 0, d_len;

	for(;;){
		if(*lp2 == EOLTTR) return(mch_len);
		if(*lp1 == EOLTTR) return(-1);
		if((d_len = p_eq(&lp2, &lp1, cur_rk)) < 0) return(d_len);
		mch_len += d_len;
	}
}

/** numܤѿˤʸȥޥåƤȲꤷơʸ֤ */
static letter
mchedsrc(num, cur_rk)
int	num;
ARGS *cur_rk;
{
	struct	matchpair	*pairptr;

	for(pairptr = henmatch; pairptr -> ltrmch != EOLTTR; pairptr++){
		if(num == pairptr -> hennum)
			return(pairptr -> ltrmch);
	}
	return(BUGreport(8), 0);
}

/**	numܤѿʸ l ȥޥå뤫Ĵ٤롣ѿunboundä
	 l bind롣ޥå(bindλޤ)1ʤ0֤ */
static int
mchsrc(num, l, cur_rk)
int	num;
letter	l;
ARGS *cur_rk;
{
	struct	matchpair	*pairptr;

	if(hen_ikisrc(num, l, cur_rk) == 0) return(0);
	for(pairptr = henmatch; pairptr -> ltrmch != EOLTTR; pairptr++){
		if(num == pairptr -> hennum)
			return(pairptr -> ltrmch == l);
	}

	pairptr -> ltrmch = l;
	pairptr -> hennum = num;
	(++pairptr) -> ltrmch = EOLTTR;
	return(1);
}

/**	l1pñ̤äɾʸl2Ȱפ뤫ɤ֤ɾ
	̤ʸˤʤʤä顢פʤ*/
static int
l_eq(l1p, l2, cur_rk)
letter	*l1p, l2;
ARGS *cur_rk;
{
	letter	evlrsl[RSLMAX];

	switch(SHUBET(*l1p)){
	case 0: 
		return(*l1p == l2);
	case 1: 
		return(mchsrc((int)LWRMSK(*l1p), l2, cur_rk));
	case 2:
		mchevl(&l1p, evlrsl, cur_rk);
		return(evlrsl[0] == l2 && evlrsl[1] == EOLTTR);
	default:
		return(BUGreport(1), 0);
	}
}

/**	prefixpǻ	 âνϵաʤޤޤ줦Τl1pp¦
	Τߡl1ppñ̤֤äɾΤl2ppΥޥåߤ롣
	l2ppޤϤƬȥޥåаĹ֤l1ppɾ̤ʸ
	λޤࡣξͤ0ˡդl1ppɾ̤Ƭl2ppޥ
	 -1֤ޥåԤͤ -2*/
static int
p_eq(l1pp, l2pp, cur_rk)
register letter **l1pp, **l2pp;
ARGS *cur_rk;
{
	int	num;
	letter	evlrsl[RSLMAX], *rslptr;
	register int	retval = -2;

	/*  l2pp¦ˤϼޤޤʤȦ */
	if(!is_HON(**l2pp)){
		/*	if(is_HON(**l1pp)) retval = p_eq(l2pp, l1pp); else  */
		BUGreport(9);
	} else {
		switch(SHUBET(**l1pp)){
		case 0: /* ʸƱ */
			retval = (*(*l1pp)++ == *(*l2pp)++ ? 1 : -2);
			break;
		case 1: /* ѿʸ */
			num = LWRMSK(*(*l1pp)++);
			retval = (mchsrc(num, *(*l2pp)++, cur_rk) ? 1 : -2);
			break;
		case 2: /* ʸ */
			mchevl(l1pp, rslptr = evlrsl, cur_rk);
			for(retval = 0; *rslptr != EOLTTR; retval++){
				if(**l2pp == EOLTTR){
					retval = -1; 
					break;
				} else if(*rslptr++ != *(*l2pp)++){
					retval = -2; 
					break;
				}
			}
			break;
		default:
			BUGreport(2);
		}
	}

	return(retval);
}

/** l1pñɾl2p */
static void
mchevl(l1pp, l2p, cur_rk)
letter	**l1pp, *l2p;
ARGS *cur_rk;
{
	letter	*l1p, tmpevl[RSLMAX];

	l1p = *l1pp;

	switch(SHUBET(*l1p)){
	case 0: 
		*l2p++ = *l1p++; 
		break;
	case 1: 
		*l2p++ = mchedsrc((int)LWRMSK(*l1p++), cur_rk); 
		break;
	case 2:	 /* toupper, tolower, error,  */
		switch(LWRMSK(*l1p++)){
		case 2: 
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p++ = to_upper(*tmpevl);
			break;
		case 3: 
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p++ = to_lower(*tmpevl);
			break;
		case 4:
			*l2p++ = CHMSIG;
			*l2p++ = LWRMSK(*l1p++);
			*l2p++ = 0; 
			break; /* EOLǤϤʤ */
		case 5:
			*l2p++ = CHMSIG;
			*l2p++ = LWRMSK(*l1p++);
			*l2p++ = 1; 
			break;
		case 6:
			*l2p++ = CHMSIG;
			*l2p++ = XY2INT(2, LWRMSK(*l1p++));
			*l2p++ = 1; 
			break;
		case 7:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p++ = to_updown(*tmpevl);
			break;
		case 8:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p++ = to_zenalpha(*tmpevl, cur_rk);
			break;
		case 9:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p++ = to_hira(*tmpevl);
			break;
		case 10:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p++ = to_kata(*tmpevl);
			break;
		case 11:
			mchevl(&l1p, tmpevl, cur_rk);
			to_hankata(*tmpevl, &l2p);
			break; /* ü */
		case 12:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p++ = to_zenhira(*tmpevl, cur_rk);
			break;
		case 13:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p++ = to_zenkata(*tmpevl, cur_rk);
			break;
		case 14:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p = *tmpevl;
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p += *tmpevl;
			LWRCUT(*l2p++);
			break;
		case 15:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p = *tmpevl;
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p -= *tmpevl;
			LWRCUT(*l2p++);
			break;
		case 16:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p = *tmpevl;
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p *= *tmpevl;
			LWRCUT(*l2p++);
			break;
		case 17:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p = *tmpevl;
			mchevl(&l1p, tmpevl, cur_rk);
			if(! *tmpevl) *l2p = LTRHUG;
			else *l2p /= *tmpevl;
			LWRCUT(*l2p++);
			break;
		case 18:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p = *tmpevl;
			mchevl(&l1p, tmpevl, cur_rk);
			if(! *tmpevl) *l2p = LTRHUG;
			else *l2p %= *tmpevl;
			LWRCUT(*l2p++);
			break;
			/* 192130ϡȶʸ
							    ǤʤUNUSDCʸȤ֤*/
		case 19:
			mchevl(&l1p, tmpevl, cur_rk);
			if(lastmch(cur_rk) != *tmpevl)
				*l2p++ = UNUSDC;
			break;
		case 20:
			if(! modesw[LWRMSK(*l1p++)] . curmode)
				*l2p++ = UNUSDC;
			break;
		case 21:
			if(modesw[LWRMSK(*l1p++)] . curmode)
				*l2p++ = UNUSDC;
			break;
		case 22:
			*l2p++ = REASIG;
			break;
		case 23:
			*l2p++ = delchr;
			break;
		case 24:
			*l2p++ = CHMSIG;
			*l2p++ = XY2INT(1, 0);
			/* ǡallפɽ */
			*l2p++ = 0; 
			break;
		case 25:
			*l2p++ = CHMSIG;
			*l2p++ = XY2INT(1, 0);
			*l2p++ = 1; 
			break;
		case 26:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p = *tmpevl;
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p &= *tmpevl;
			LWRCUT(*l2p++);
			break;
		case 27:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p = *tmpevl;
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p |= *tmpevl;
			LWRCUT(*l2p++);
			break;
		case 28:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p = ~(*tmpevl);
			LWRCUT(*l2p++);
			break;
		case 29:
			*l2p++ = URBFCL;
			break;
		case 30:
			if(eofflg != 2 || *keybuf != EOLTTR)
				*l2p++ = UNUSDC;
			break;
		case 31:
			{
				letter	code, basenum;

				mchevl(&l1p, tmpevl, cur_rk);
				code = *tmpevl;
				mchevl(&l1p, tmpevl, cur_rk);
				if((basenum = *tmpevl) <= 1 ||
				    BASEMX < basenum)
					basenum = 10;
				to_digit(code, basenum, &l2p);
			}
			break;
		case 32:
			mchevl(&l1p, tmpevl, cur_rk);
			dakuadd(*tmpevl, &l2p);
			break; /* ü */
		case 33:
			mchevl(&l1p, tmpevl, cur_rk);
			handakuadd(*tmpevl, &l2p);
			break; /* ü */
		case 34:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p++ = ltov(*tmpevl);
			break;
		case 35:
			*l2p++ = ERRCOD;
			break;
			/*	case 36: omitted */
		case 37:
			*l2p++ = CHMSIG;
			*l2p++ = LWRMSK(*l1p++);
			*l2p++ = *l1p++; 
			break;
		case 38:
			*l2p++ = CHMSIG;
			*l2p++ = XY2INT(2, LWRMSK(*l1p++));
			*l2p++ = *l1p++; 
			break;
		case 39:
			*l2p++ = CHMSIG;
			*l2p++ = XY2INT(3, LWRMSK(*l1p++));
			*l2p++ = *l1p++; 
			break;
		case 40:
			{
				letter	modnum;

				modnum = LWRMSK(*l1p++);
				if(modesw[modnum] . curmode != *l1p++)
					*l2p++ = UNUSDC;
				break;
			}
		case 41:
			{
				letter	modnum;

				modnum = LWRMSK(*l1p++);
				if(modesw[modnum] . curmode == *l1p++)
					*l2p++ = UNUSDC;
				break;
			}
		case 42:
			{
				letter	modnum;

				modnum = LWRMSK(*l1p++);
				if(modesw[modnum] . curmode >= *l1p++)
					*l2p++ = UNUSDC;
				break;
			}
		case 43:
			{
				letter	modnum;

				modnum = LWRMSK(*l1p++);
				if(modesw[modnum] . curmode <= *l1p++)
					*l2p++ = UNUSDC;
				break;
			}
		case 44:
			mchevl(&l1p, tmpevl, cur_rk);
			*l2p++ = SENDCH;
			*l2p++ = *tmpevl;
			break;
		default:/* case 0ڤӾ嵭ʳ */
			;
			BUGreport(7);
		}
	}

	*l2p = EOLTTR;
	*l1pp = l1p;
}

/** numܤѿѰ褬ʸ l ޤफɤ֤ */
static int
hen_ikisrc(num, l, cur_rk)
int	num;
letter	l;
ARGS *cur_rk;
{
	letter	*defptr;

	defptr = hyo_n[hyonum] . hensudef[num];
	if(*defptr == VARRNG){
		for(defptr++; *defptr != EOLTTR; )
			if(*defptr++ <= l && l <= *defptr++) return(1);
		return(0);
	}

	for(; *defptr != EOLTTR; defptr++){
		if(l == *defptr) return(1);
	}
	return(0);
}

/**	ѴΥᥤ롼ܽԤĤǤ˸äƤ롣
	ʤߤϡromkan_getcβ̴ؿromkan_henkanǡ
	δؿƤˤäƤ롣
	δؿϡromkan_nextʸ٤˸ƤФ롣ƤӽФ줿ľ
	output϶ʸdisoutˤϥɰʸäƤ롣
	δؿʸ󤬡romkan_henkanϤꡢ
	romkan_getcϡʸȤʬ򤷤֤
	(error)ǥ顼줿0֤ｪλ1֤ */
int
match(cur_rk)
ARGS *cur_rk;
{
	int	henkanflg = 0, okcode = 0, chm_exist;
	letter	*p;
	letter	urabufcreate[KBFSIZ], orgkeybuf[KBFSIZ], kbftail[KBFSIZ];
	letter	*urabufjunbi, *outcutptr, *dis_end;

	if(*keybuf == EOLTTR){
		*urabuf = EOLTTR;
		return(1);
	}

	ltrcpy(urabufjunbi = orgkeybuf, keybuf);
	outcutptr = rk_output;

	while((okcode = henkan_ok(cur_rk)) > 0){
		henkanflg = 1;

		codeout_chg(cur_rk);
		ltrcat(rk_output, codeout);

		ltrcpy(kbftail, keybuf + codein_len);
		ltrcat(ltrcpy(keybuf, remainkbf), kbftail);

		if(okcode == 2){
			ltrcpy(urabufjunbi = urabufcreate, keybuf);
			totail(outcutptr);
		}
	}

	if(okcode == 0){
		ltr1cut(ltrcpy(keybuf, orgkeybuf));
		ltr_to_ltrseq(disout, NISEBP);
		*rk_output = EOLTTR;
		return(0);
	}
	if(henkanflg){
		ltrcpy(urabuf, urabufjunbi);

		set_rubout(disout, ltrlen(orgkeybuf) - 1, nisedl);

		dis_end = disout;
		totail(dis_end);
		ltrcpy(dis_end, rk_output);

		/* ⡼ɥ󥸤ľΤ餻뤿 CHMSIG
				    flagsRK_CHMOUTΩäƤʤȡȤǰʸĤ
				    ʬ򤹤ǡCHMSIG򥫥åȡˡ
				    ârk_outputϡCHMSIGȴ
				    ޤCHMSIGˣ󤷤Ϥʤ
				    ʣʾ夢äƤ⡢ˤޤȤơ֤ˡ*/
		for(chm_exist = 0, p = rk_output; ; p++){
			while(*p == CHMSIG){
				chm_exist = 1;
				if(ltrcpy(p, p + 1) < outcutptr) outcutptr--;
			}
			if(*p == EOLTTR) break;
		}
		if(chm_exist){
			/* CHMSIG򣱤ĤˤޤȤ᤿Τdis_endˤĤʤľ
					    ifʸ򥫥åȤСCHMSIGΤȤޤȤϤʤ */
			ltr1cat(ltrcpy(dis_end, rk_output), CHMSIG);
		}

		bitup_ltrcat(disout, keybuf);
		lastoutlen = ltrlen(outcutptr);
		lastkbflen = ltrlen(keybuf);
	}
	return(1);
}

/**	LTREOFäȤˡФ褦˻ꤵƤ뤫Ĵ٤ơ
	codeout򤽤η̤ʸʻ꤬ʤäˤ˥ݥȤ롣
	Ķޤ館ǡü쥳ϰ̵뤹롣*/
static void
add_at_eof(cur_rk)
ARGS *cur_rk;
{
	register struct dat	*datptr;
	register int	i;
	int	hyoseq;
	letter	evlrsl[RSLMAX], *p;

	for(hyoseq = 0; (hyonum = usehyo[hyoseq]) != -1; hyoseq++){
		for(i = 0, datptr = hyo_n[hyonum] . data;
		    NULL != (p = datptr[i] . code[0]); i++){
			henmatch[0] . ltrmch = EOLTTR;
			while(*p != EOLTTR){
				switch(SHUBET(*p)){
				case 0: /* ʸ */
				case 1: /* ѿ */
					/* 餬ϡNULLȤ
										    ޥåʤ*/
					goto Pass;
				case 2: /*  */
					mchevl(&p, evlrsl, cur_rk);
					if(*evlrsl != EOLTTR)
						goto Pass;
					/* ϥˡɾ
										    ʸˤʤΤ¾ˤϤʤ
										    Ȥ*/
				}
			}

			ltrevlcpy(codeout = p = evalbuf[0][0],
			    datptr[i] . code[1], cur_rk);
			while(*p != EOLTTR){
				if(isSPCL(*p)) ltrcpy(p, p + 1);
				else p++;
			}
			codeout_chg(cur_rk);
			return;

Pass:			
			;
		}
	}
	codeout = nil;
}

/**	ޥåߤ롣ͤϡޥåƳꤷ1ʥ⡼ɥ󥸤
	äƤ2ˡޥå̤λ-1ޥåʤä0
	¹ϡѿ l ˡޤǤ˰פĹκǹ⵭ϿƤꡢ
	ĹפΤĤ뤴Ȥˡ򹹿롣lͤϡޥå
	ƤƤ0ˤʤ뤳Ȥ⤢롣p_eq() ڤ prefixp() ʸ򻲾ȡ*/
static int
henkan_ok(cur_rk)
ARGS *cur_rk;
{
	register struct dat	*datptr;
	register int	i, k;
	int	l, j, hyoseq;
	char	urabuf_clrf; /* ⡼ɥ󥸤ʤɤǡurabuf򥯥ꥢɬפ
					Ϥ줬Ωη̡henkan_ok()
					1֤٤Ȥ2֤򸫤ơ
					match()urabufʤɤĴ򤹤롣*/
	register letter *p;

	if(*keybuf == EOLTTR) return(-1);

	for(l = -1, hyoseq = 0; (hyonum = usehyo[hyoseq]) != -1; hyoseq++){
		for(i = 0, datptr = hyo_n[hyonum] . data;
		    NULL != (p = datptr[i] . code[0]); i++){
			henmatch[0] . ltrmch = EOLTTR;
			switch(k = prefixp(keybuf, p, cur_rk)){
			case -2: 
				break;
			case -1:
				if(eofflg != 0) break;
				/* eofflgΩäƤ顢̤βǽ
								    ΤƤ롣*/
				return(-1);
			default:
				if(k > l){
					ebf_sw = !ebf_sw;
					for(j = 1; j <= 2; j++){
						ltrevlcpy(
						    evalbuf[(int)ebf_sw][j-1],
						    datptr[i] . code[j], cur_rk);
					}
					l = k;
				}
			}
		}
	}

	if(l >= 0){
		codein_len = l;
		codeout = evalbuf[(int)ebf_sw][0];
		remainkbf = evalbuf[(int)ebf_sw][1];

		for(urabuf_clrf = 0, p = codeout; *p != EOLTTR;){
			switch(*p){
			case CHMSIG:
				p++;
				/* codeout1Хܤ˴ؿΥåȥ⡼ֹ桢
							    2Хܤ˥⡼ɤο֤äƤ */
				switch(SHUBET(*p)){
				case 0:
					chgmod((int)*p,
					    (modetyp)*(p + 1), cur_rk);
					break;
				case 1:
					allchgmod((modetyp)
					    *(p + 1), cur_rk);
					break;
				case 2:
					incmod((int)LWRMSK(*p)
					    ,(modetyp)*(p + 1), cur_rk);
					break;
				case 3:
					decmod((int)LWRMSK(*p)
					    ,(modetyp)*(p + 1), cur_rk);
					break;
				}
				ltrcpy(p, p + 2);
				/* CHMSIGĤ1,2Хcut */

				urabuf_clrf = 1;
				break;
			case URBFCL:
				/* urabufΥꥢŪ˻ꤹ */
				urabuf_clrf = 1;
				ltrcpy(p, p + 1);
				break;
			default:
				p++;
			}
		}

		if(*codeout == ERRCOD){
			if(eofflg == 0){
				rk_errstat = 1;
				return(0);
			}

			/* (error)ǤäơeofflgΩäƤ顢keybuf
						    ޤǡΤޤ޽Ф*/
			codein_len = ltrlen(keybuf);
			codeout = ltrcpy(evalbuf[(int)ebf_sw][0], keybuf);
			remainkbf = nil;
			rk_errstat = 2;

			return(1);
		}
		/* (error)ñȤǤ񤱤ʤΤǡ顼ФϤǽʬ*/

		if(*codeout == REASIG){
			*codeout = (rk_rst(cur_rk) != 0 ? EOLTTR : CHMSIG);
			/* readǥä⡼ɥ󥸤ΤϤʤ */

			urabuf_clrf = 1;
		}
		/* ɽκreadâ줬äȤ򳰤Τ餻ΤCHMSIG
			      ΥɤΤΤϳؽФʤ(restart)ϡ(error)Ʊ͡
			      ñȤǤ񤱤ʤΤǡФϤǽʬ*/

		return(urabuf_clrf ? 2 : 1);
	}

	/* ɽ˸ƤʤɤϤΤޤ֤ */

	codein_len = 1;
	*(codeout = oneletter) = *keybuf;
	remainkbf = nil;
	return(1);
}

/* rk_rstǻȤޥ */
#define taihi(X, Y, N) {for(i = 0; i < N; i++) X[i] = Y[i];}
#define recov(X, Y, N) {for(i = 0; i < N; i++) Y[i] = X[i];}

/**	ɽưŪɤ߹ߤ򤹤롣ߤɽ򤷡Ʊ
	ǥ쥯ȥʤˡߤΤȤˤɽɤ߹ࡣ⤷
	ɤ߹˥顼򸡽ФСȤǡ褷0֤*/
static int
rk_rst(cur_rk)
ARGS *cur_rk;
{
	register int	i;
	int	j;

	letter	memoryt[SIZALL];
	struct	dat	datat[LINALL];
	struct	hyo	hyo_nt[HYOMAX];
	letter	*hensudefhyot[VARTOT];
	struct	modestat	modeswt[MODMAX];
	char	hyoshut[HYOMAX];
	char	*modmeibgnt[MODMAX], modmeimem_t[MODMEI];
	char	*dspnambgnt[DMDMAX], dspcod_t[DMDCHR];
	int	usemaehyot[HYOMAX], usehyot[HYOMAX], useatohyot[HYOMAX];
	int	naibu_t[NAIBMX];
	char	*dspmodt[2][2];

	taihi(memoryt,		memory,		SIZALL);
	taihi(datat,		dat_data,	LINALL);
	taihi(hyo_nt,		hyo_n,		HYOMAX);
	taihi(hensudefhyot,	hensudefhyo,	VARTOT);
	taihi(modeswt,		modesw,		MODMAX);
	taihi(hyoshut,		hyoshu,		HYOMAX);
	taihi(modmeibgnt,	modmeibgn,	MODMAX);
	taihi(modmeimem_t,	modmeimem_,	MODMEI);
	taihi(dspnambgnt,	dspnambgn,	DMDMAX);
	taihi(dspcod_t,		dspcod_,	DMDCHR);
	taihi(usemaehyot,	usemaehyo,	HYOMAX);
	taihi(usehyot,		usehyo,		HYOMAX);
	taihi(useatohyot,	useatohyo,	HYOMAX);
	taihi(naibu_t,		naibu_,		NAIBMX);
	for(i = 0; i < 2; i++)
		for(j = 0; j < 2; j++)	dspmodt[i][j] = dspmod[i][j];

	if(0 == romkan_init3(prv_modfnm, delchr, nisedl, delchr2,
	    keyin_method, bytcnt_method, kbytcnt_method,
	    1, flags & ~RK_VERBOS)) {
		return(0); /* ｪλ */
	}

	recov(memoryt,		memory,		SIZALL);
	recov(datat,		dat_data,	LINALL);
	recov(hyo_nt,		hyo_n,		HYOMAX);
	recov(hensudefhyot,	hensudefhyo,	VARTOT);
	recov(modeswt,		modesw,		MODMAX);
	recov(hyoshut,		hyoshu,		HYOMAX);
	recov(modmeibgnt,	modmeibgn,	MODMAX);
	recov(modmeimem_t,	modmeimem_,	MODMEI);
	recov(dspnambgnt,	dspnambgn,	DMDMAX);
	recov(dspcod_t,		dspcod_,	DMDCHR);
	recov(usemaehyot,	usemaehyo,	HYOMAX);
	recov(usehyot,		usehyo,		HYOMAX);
	recov(useatohyot,	useatohyo,	HYOMAX);
	recov(naibu_t,		naibu_,		NAIBMX);
	for(i = 0; i < 2; i++)
		for(j = 0; j < 2; j++)	dspmod[i][j] = dspmodt[i][j];
	return(1);
}

/** lp2ɾʸlp1˥ԡ */
static void
ltrevlcpy(lp1, lp2, cur_rk)
letter	*lp1, *lp2;
ARGS *cur_rk;
{
	while(*lp2 != EOLTTR){
		mchevl(&lp2, lp1, cur_rk);
		totail(lp1);
	}
	*lp1 = EOLTTR;
}

static void
set_rubout(lp, n, del)
/** lp delnĤ򥻥åȤ롣 del  'delchr''nisedl' */
letter	*lp, del;
int	n;
{
	for(; n; n--) *lp++ = del;
	*lp = EOLTTR;
}

/** 줬¹Ԥ줿Хâ¹ԤϤΤޤ³ */
void
BUGreport(n)
int	n;
{
	fprintf(stderr, "\r\nromkan-Bug%d!!\r\n", n);
}

/** (mae_inmae_out)ϸ(ato_inato_out)Ԥ*/
static void
maeato_henkan(in, outp, m_a_hyo, cur_rk)
letter	in;		/* Ϥΰʸ */
letter	*outp;		/* ϤϤ */
int	*m_a_hyo;	/* ɤɽ򤵤Ƥ뤫ξ */
ARGS *cur_rk;
{
	struct	dat	*datptr;
	int	i, hyoseq;
	letter	*curdat;

	if(isSPCL(in)){
		/* LTREOFCHMSIG褦Τǡü쥳ɤϤΤޤ֤褦
			    ٹƤʤȤʤ*/
		ltr_to_ltrseq(outp, in);
		return;
	}

	for(hyoseq = 0; (hyonum = m_a_hyo[hyoseq]) != -1; hyoseq++){
		for(i = 0, datptr = hyo_n[hyonum] . data;
		    NULL != (curdat = datptr[i] . code[0]); i++){
			henmatch[0] . ltrmch = EOLTTR;
			if(!l_eq(curdat, in, cur_rk)) continue;

			ltrevlcpy(outp, datptr[i] . code[1], cur_rk);
			return;
		}
	}
	ltr_to_ltrseq(outp, in);
}

/**  */
static void
codeout_chg(cur_rk)
ARGS *cur_rk;
{
	letter	*saishu_outp;

	*(saishu_outp = saishu_out) = EOLTTR;

	for(; *codeout != EOLTTR; codeout++){
		maeato_henkan(*codeout, saishu_outp, useatohyo, cur_rk);
		totail(saishu_outp);
	}

	codeout = saishu_out;
}

/** ʸץå塦Хå */
letter
romkan_ungetc_body(l, cur_rk)
letter	l;
ARGS *cur_rk;
{
	ungetc_buf = l;
	return l;
}

letter
romkan_ungetc(l)
letter  l;
{
	letter x;
	ARGS *cur_rk = NULL;

	x = romkan_ungetc_body(l, cur_rk);
	return x;
}

/** romkan_nextФʸץå塦Хå */
letter
romkan_unnext_body(l, cur_rk)
letter	l;
ARGS *cur_rk;
{
	unnext_buf = l;
	return l;
}

letter
romkan_unnext(l)
letter  l;
{
	letter x;
	ARGS *cur_rk = NULL;

	x = romkan_unnext_body(l, cur_rk);
	return x;
}

 /**	deleteȤƻȤ饯ʵdeleteˡ¹Ը
	romkan_clear¹ԤƤʤȺΤȤˤʤޤ*/
/*	ѻߡ
void
romkan_setdel(delchr_, nisedl_)
letter	delchr_, nisedl_;
{
	delchr = delchr_;
	nisedl = nisedl_;
}
*/

