#!/usr/bin/perl
use strict;
use lib 'blib/lib';
use lib 'blib/arch';
use Rast;

if (@ARGV ne 3) {
    print "usage: $0 <dbpath1> <dbpath2> <query>\n";
    exit;
}

my $dbpath1 = @ARGV[0];
my $dbpath2 = @ARGV[1];
my $query = @ARGV[2];

die "dbpath1 is not found.\n"
    unless -e $dbpath1 || $dbpath1 =~ m|^xmlrpc.https?://|io;
die "dbpath2 is not found.\n"
    unless -e $dbpath2 || $dbpath2 =~ m|^xmlrpc.https?://|io;

die "$query is not found.\n"
    unless $query;

my $db = Rast->open([ $dbpath1, $dbpath2 ]);

my $result = $db->search($query,{
 need_summary => 1,
 properties => ["title", "filename", "last_modified", "filesize"]
});

die "search error\n"
    unless $result;

print "Query: $query\n";
print "Hit  : " . $result->hit_count . "\n";
while (my $row = $result->fetch) {
    print "
doc_id: " . $row->{doc_id} . "
score: " . $row->{score} . "
filename: " . $row->{properties}->[1] . "
title: " . $row->{properties}->[0] . "
last_modified: " . $row->{properties}->[2] . "
filesize: " . $row->{properties}->[3] . "
summary:
$row->{summary}
---------------------------------------------
";
}
$db->close();

exit;
