"""
File:		Thread.py
Purpose:	Thread handler
"""


### Imports

# App 1
import	Import

# Python
try :
	from subprocess import *
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException( "PyQt4" )

# App 2
import	Display, File, Main, Profile, Settings


### Threads

# Create
class tCreate( QtCore.QThread ) :

	def create( self ) :

		# Declare process
		self.pArc = QtCore.QProcess()

		# Declare paths
		dSource = QtCore.QDir()
		dOutput = QtCore.QDir()

		# Source
		dSource.setPath( self.oAI.Source.slFiles.__getitem__(self.oAI.Source.iNext) )

		# Archive name
		sArcName = QtCore.QString()
		sExt = QtCore.QString()
		# User specified
		if self.oAI.Dest.bName and not self.oAI.Dest.sName.isEmpty() :
			sArcName = self.oAI.Dest.sName
		# One input only or separate archives
		elif self.oAI.Source.slFiles.count() == 1 or self.oAI.Dest.bSeparate :
			sArcName = dSource.dirName()
		# Multiple inputs and only one archive
		else :
			sArcName = Settings.Application.sName

		dSource.cdUp()

		# CLI or GUI?
		if Import.Init.bInvisible or not Settings.Exec.P7Zip.GUI.bUse :
			sCmd = Settings.Exec.P7Zip.CLI.sCommand
			sArgs = Settings.Exec.P7Zip.CLI.sArgs
		else :
			sCmd = Settings.Exec.P7Zip.GUI.sCommand
			sArgs = Settings.Exec.P7Zip.GUI.sArgs

		# Arguments
		sArcCmdArgs = QtCore.QString()
		slCmdArgs = QtCore.QStringList()
		slCmdArgs.clear()
		slArgs = QtCore.QStringList( sArgs.split( ' ' ) )
		while not slArgs.isEmpty() and not slArgs.first().isEmpty() :
			slCmdArgs.append( slArgs.takeFirst() )

		# Switches
		if self.oAI.Misc.bSwitches :
			slSwitches = QtCore.QStringList( self.oAI.Misc.sSwitches.trimmed().split( ' ' ) )
			while not slSwitches.isEmpty() and not slSwitches.first().isEmpty() :
				slCmdArgs.append( slSwitches.takeFirst() )

		# Algorithm
		if self.oAI.Type.sAlgorithm == "XZ" or self.oAI.Type.sAlgorithm == "BZip2" \
			or self.oAI.Type.sAlgorithm == "GZip" or self.oAI.Type.sAlgorithm == "Tar" :

			# Linux
			if Settings.sOS == "Linux" :

				# Command
				sCmd = Settings.Exec.Tar.sCommand

				# Format
				if self.oAI.Type.sAlgorithm == "XZ" :
					slCmdArgs.append( "-J" )
					sExt = ".tar.xz"
				elif self.oAI.Type.sAlgorithm == "BZip2" :
					slCmdArgs.append( "-j" )
					sExt = ".tar.bz2"
				elif self.oAI.Type.sAlgorithm == "GZip" :
					slCmdArgs.append( "-z" )
					sExt = ".tar.gz"
				else :
					sExt = ".tar"

				# Keep permissions
				slCmdArgs.append( "-p" )

				# Exclusions
				slWildcards = QtCore.QStringList( Settings.User.Syntax.sExclusions.split( ' ' ) )
				while not slWildcards.isEmpty() and not slWildcards.first().isEmpty() :
					slCmdArgs.append( "--exclude=" + slWildcards.takeFirst() )

				# Working directory
				slCmdArgs.append( "-cC" )
				#slCmdArgs.append( '\"' + dSource.path() + '\"' )
				slCmdArgs.append( dSource.path() )

				# Use relative paths for tarball contents
				if not self.oAI.Dest.bSeparate :
					for iEntry in range(0,self.oAI.Source.slFiles.count()) :
						self.oAI.Source.slFiles.replace( iEntry , dSource.relativeFilePath( self.oAI.Source.slFiles.__getitem__( iEntry ) ) )
				else :
					self.oAI.Source.slFiles.replace( self.oAI.Source.iNext , dSource.relativeFilePath( self.oAI.Source.slFiles.__getitem__( self.oAI.Source.iNext ) ) )

				# Archive file
				slCmdArgs.append( "-f" )

			"""
			else :

				# Format
				if self.oAI.Type.sAlgorithm == "BZip2" :
					slCmdArgs.append( "-tbzip2" )
					sExt = ".tar.bz2"
				elif self.oAI.Type.sAlgorithm == "GZip" :
					slCmdArgs.append( "-tgzip" )
					sExt = ".tar.gz"
				else :
					slCmdArgs.append( "-ttar" )
					sExt = ".tar"

				# Method
				slCmdArgs.append( "u" )
				slCmdArgs.append( "-uq0" )

				# Yes to all
				slCmdArgs.append( "-y" )

				# Recursive
				slCmdArgs.append( "-r" )
			"""

		else :

			# Format
			if self.oAI.Type.sAlgorithm == "7-Zip" :
				slCmdArgs.append( "-t7z" )
				sExt = ".7z"

				# Scrambled
				if not self.oAI.Security.bScramble :
					slCmdArgs.append( "-mhe=off" )
				else :
					slCmdArgs.append( "-mhe=on" )

				# Solid
				if not self.oAI.Type.bSolid :
					slCmdArgs.append( "-ms=off" )
				else :
					slCmdArgs.append( "-ms=on" )

				# Volumes
				if self.oAI.Type.sVolume == "Floppy" :
					slCmdArgs.append( "-v1440k" )
				elif self.oAI.Type.sVolume == "CD" :
					slCmdArgs.append( "-v720000k" )
				elif self.oAI.Type.sVolume == "DVD" :
					slCmdArgs.append( "-v4700000000b" )

			elif self.oAI.Type.sAlgorithm == "Zip" :
				slCmdArgs.append( "-tzip" )
				sExt = ".zip"

			# Compression level
			if self.oAI.Type.sComp == "None" :
				slCmdArgs.append( "-mx0" )
			elif self.oAI.Type.sComp == "Fastest" :
				slCmdArgs.append( "-mx1" )
			elif self.oAI.Type.sComp == "Fast" :
				slCmdArgs.append( "-mx3" )
			elif self.oAI.Type.sComp == "Normal" :
				slCmdArgs.append( "-mx5" )
			elif self.oAI.Type.sComp == "Maximum" :
				slCmdArgs.append( "-mx7" )
			elif self.oAI.Type.sComp == "Ultra" :
				slCmdArgs.append( "-mx9" )

			# Method
			if self.oAI.Type.sMethod == "Update" :
				slCmdArgs.append( "u" )
			elif self.oAI.Type.sMethod == "Sync" :
				slCmdArgs.append( "u" )
				slCmdArgs.append( "-uq0" )
			elif self.oAI.Type.sMethod == "Add" :
				slCmdArgs.append( "a" )

			# Yes to all
			slCmdArgs.append( "-y" )

			# Password
			if self.oAI.Security.bPassword and not self.oAI.Security.sPassword.isEmpty() :
				slCmdArgs.append( "-p" + self.oAI.Security.sPassword )

			# SFX
			if self.oAI.Type.bSFX :
				slCmdArgs.append( "-sfx" )
				sExt = ".exe"

			# Recursive
			slCmdArgs.append( "-r" )

			# Exclusions
			slWildcards = QtCore.QStringList( Settings.User.Syntax.sExclusions.split( ' ' ) )
			while not slWildcards.isEmpty() and not slWildcards.first().isEmpty() :
				slCmdArgs.append( "-x!" + slWildcards.takeFirst() )

		# Destination
		if not self.oAI.Dest.bDest or self.oAI.Dest.sDir.isEmpty() :
			dOutput.setPath( dSource.path() + Settings.Path.sSep )
		else :
			dOutput.setPath( self.oAI.Dest.sDir + Settings.Path.sSep )

		# Structured
		if self.oAI.Dest.bStructured :
			dOutput.setPath( dOutput.path() + Settings.Path.sSep + dSource.path().replace( ':' , '' ) + Settings.Path.sSep )

		# Test destination
		if not dOutput.exists() :
			dOutput.mkpath( dOutput.path() )

		dOutput.setPath( dOutput.path() + Settings.Path.sSep + sArcName + sExt )
		#self.oAI.Dest.sFullPath = "'" + dOutput.path() + "'"
		self.oAI.Dest.sFullPath = dOutput.path()

		# Append archive and file(s)
		slCmdArgs.append( self.oAI.Dest.sFullPath )

		# Input
		# Many archives
		if self.oAI.Dest.bSeparate :
			slCmdArgs.append( self.oAI.Source.slFiles.__getitem__(self.oAI.Source.iNext) )
		# Single archive
		else :
			slCmdArgs << self.oAI.Source.slFiles

		# Volumes
		if self.oAI.Type.sVolume != "Unlimited" :
			self.oAI.Dest.sFullPath += ".001"

		# Messages
		File.slMessage( Settings.Message.iInformation, "Input = " + self.oAI.Source.slFiles.__getitem__(self.oAI.Source.iNext) )
		File.slMessage( Settings.Message.iInformation, "Archive = " + self.oAI.Dest.sFullPath )
		File.slMessage( Settings.Message.iInformation, "Command = " + sCmd )
		for iEntry in range(0,slCmdArgs.count()) :
			sArcCmdArgs += slCmdArgs.__getitem__( iEntry ) + " "
		File.slMessage( Settings.Message.iInformation, "Arguments = " + sArcCmdArgs )

		# Execute process
		self.pArc.start( sCmd , slCmdArgs )

		if self.pArc.waitForStarted( Settings.Timer.Process.iPause ) :

			# Messages
			File.slMessage( Settings.Message.iInformation, "The archiving process has started." )

			iWaitCount = 0

			#if not self.pArc.waitForFinished( -1 ) :
			while not self.pArc.waitForFinished( Settings.Timer.Process.iPause ) :
				pass
				#self.emit( QtCore.SIGNAL( "error(QString)" ) , "The archiving process unexpectedly terminated." )
				"""
				if iWaitCount >= Settings.Timer.Process.iWaitMax :
					# Messages
					self.emit( QtCore.SIGNAL( "error(QString)" ) , "The archiving process was taking too long to complete." )
					break
				iWaitCount += 1
				# Search for percentage indicator
				#sArcData = QtCore.QString( self.pArc.readData(512) )
				"""

			sOutput = QtCore.QString( self.pArc.readAllStandardOutput() )
			sError = QtCore.QString( self.pArc.readAllStandardError() )

			# Analyse exit-code
			if self.pArc.exitCode() is not 0 or sOutput.contains( "Break signaled" ) :

				# Progress
				self.oAI.iProgress = 0
				self.oAI.bSuccess = False

				# CLI or GUI?
				if sOutput == "" :
					# Using Tar
					if sCmd == Settings.Exec.Tar.sCommand :
						sOutput = sError
					# Invisible or CLI
					elif Import.Init.bInvisible or not Settings.Exec.P7Zip.GUI.bUse :
						sOutput = "An unspecified error occurred, perhaps due to a segmentation fault."

				self.emit( QtCore.SIGNAL( "error(QString)" ) , sOutput )

				# Messages
				File.slMessage( Settings.Message.iError, "File "  + str(self.oAI.Source.iNext) + " failed to archive: " + self.oAI.Source.slFiles.__getitem__(self.oAI.Source.iNext) )

				# Invisible?
				if Import.Init.bInvisible :
					Display.slQuit()

			else :

				# Progress
				if not self.oAI.Dest.bSeparate :
					self.oAI.iProgress = 100
				else :
					self.oAI.iProgress = 100 * (self.oAI.Source.iNext+1) / self.oAI.Source.slFiles.count()

				# Adjust percentage
				if self.oAI.bTest :
					self.oAI.iProgress /= 2

				# Messages
				File.slMessage( Settings.Message.iInformation, "File " + str(self.oAI.Source.iNext) + " was successfully archived." )

				"""
				# Separate
				if self.oAI.Dest.bSeparate :
					self.oAI.Source.iNext += 1
				"""

			self.emit( QtCore.SIGNAL( "done(int)" ) , self.oAI.iProgress )

		else :
			self.emit( QtCore.SIGNAL( "error(QString)" ) , "Can't start the archiving process." )

		#return self.oAI


	def stop( self ) :

		try :
			# Stop archiving
			if self.pArc.state() == QtCore.QProcess.Running :
				self.pArc.kill()
				pShell = Popen( ["killall", Settings.Exec.P7Zip.sCommand], stdout=PIPE, stderr=PIPE )
				pShell.communicate()[0]
				#pShell = Popen( ["kill", str(self.pArc.pid()+1)], stdout=PIPE, stderr=PIPE )
				#pShell.communicate()[0]
				# Messages
				File.slMessage( Settings.Message.iInformation, "The archiving process was stopped by the user." )
			else :
				tiExtract.stop()
		except :
			pass

		# Exit
		self.exit()


	def run( self ) :

		# Invisible?
		if not Import.Init.bInvisible :
			# Priority
			self.setPriority( QtCore.QThread.LowPriority )

		# Process
		#self.pArc = QtCore.QProcess()

		# Profile
		#self.oAI = QtCore.QObject()
		self.oAI = Profile.oInfo

		# Operation
		self.oAI.iOperation = Settings.Operation.iCreate

		# GUI
		Display.slGuiProfileGetCreate( self.oAI )

		# Execute archiver
		for self.oAI.Source.iNext in range(0,self.oAI.Source.slFiles.count()) :

			# Set GUI
			self.emit( QtCore.SIGNAL( "operation(int)" ) , Settings.Operation.iCreate )

			# Create archive
			if self.oAI.bSuccess :
				self.create()
			else :
				break

			if self.oAI.bSuccess :

				if not self.oAI.Dest.bSeparate :

					# Test the archive
					if self.oAI.bTest :

						# Operation
						self.oAI.iSource = Settings.Operation.iCreate
						self.oAI.iOperation = Settings.Operation.iTest

						# Get GUI
						Display.slGuiProfileGetExtract( self.oAI )

						# Archive
						self.oAI.Source.slFiles.clear()
						self.oAI.Source.slFiles.append( self.oAI.Dest.sFullPath )

						# Set GUI
						self.emit( QtCore.SIGNAL( "operation(int)" ) , Settings.Operation.iTest )

						# Test
						tiExtract.extract( self.oAI )

					break

				else :
					self.oAI.Source.iNext += 1

			else :
				break

			# Start event loop
			#self.exec_()

		else :
			self.emit( QtCore.SIGNAL( "error(QString)" ) , "" )

		# Invisible?
		if Import.Init.bInvisible :
			Display.slQuit()


# Extract the archive
class tExtract( QtCore.QThread ) :

	def extract( self , oAI ) :

		# Declare process
		self.pArc = QtCore.QProcess()

		# Declare paths
		dSource = QtCore.QDir()
		dOutput = QtCore.QDir()

		# Source
		dSource.setPath( oAI.Source.slFiles.first() )
		dSource.makeAbsolute()

		# Beneath
		sBeneath = dSource.dirName()
		sBeneath.resize( sBeneath.lastIndexOf( '.' ) )
		dSource.cdUp()

		# Destination
		if not oAI.Dest.bDest or oAI.Dest.sDir.isEmpty() :
			dOutput.setPath( dSource.path() + Settings.Path.sSep )
		else :
			dOutput.setPath( oAI.Dest.sDir + Settings.Path.sSep )

		# Filename
		if oAI.Dest.bName :
			dOutput.setPath( dOutput.path() + Settings.Path.sSep + oAI.Dest.sName )

		if oAI.Dest.bBeneath :
			dOutput.setPath( dOutput.path() + Settings.Path.sSep + sBeneath )

		# CLI or GUI?
		if Import.Init.bInvisible or not Settings.Exec.P7Zip.GUI.bUse :
			sCmd = Settings.Exec.P7Zip.CLI.sCommand
			sArgs = Settings.Exec.P7Zip.CLI.sArgs
		else :
			sCmd = Settings.Exec.P7Zip.GUI.sCommand
			sArgs = Settings.Exec.P7Zip.GUI.sArgs

		# Arguments
		sArcCmdArgs = QtCore.QString()
		slCmdArgs = QtCore.QStringList()
		slCmdArgs.clear()
		slArgs = QtCore.QStringList( sArgs.split( ' ' ) )
		while not slArgs.isEmpty() and not slArgs.first().isEmpty() :
			slCmdArgs.append( slArgs.takeFirst() )

		"""
		# Switches
		if oAI.Misc.bSwitches :
			slSwitches = QtCore.QStringList( oAI.Misc.sSwitches.trimmed().split( ' ' ) )
			while not slSwitches.isEmpty() and not slSwitches.first().isEmpty() :
				slCmdArgs.append( slSwitches.takeFirst() )
		"""

		# Algorithm
		#if Settings.sOS == "Linux" and oAI.iOperation == Settings.Operation.iExtract
		if oAI.Source.slFiles.first().endsWith( ".tar.xz" ) or oAI.Source.slFiles.first().endsWith( ".tar.bz2" ) \
			or oAI.Source.slFiles.first().endsWith( ".tar.gz" ) or oAI.Source.slFiles.first().endsWith( ".tar" ) :

			# Command
			sCmd = Settings.Exec.Tar.sCommand

			# Extract or test
			if oAI.iOperation == Settings.Operation.iExtract :
				slCmdArgs.append( "-x" )
			else :
				slCmdArgs.append( "-t" )

			# Keep permissions
			slCmdArgs.append( "-p" )

			# Exclusions
			slWildcards = QtCore.QStringList( Settings.User.Syntax.sExclusions.split( ' ' ) )
			while not slWildcards.isEmpty() and not slWildcards.first().isEmpty() :
				slCmdArgs.append( "--exclude=" + slWildcards.takeFirst() )

			# Working directory
			slCmdArgs.append( "-C" )
			#slCmdArgs.append( "'" + dOutput.path() + Settings.Path.sSep + "'" )
			slCmdArgs.append( dOutput.path() + Settings.Path.sSep )

			# Archive file
			slCmdArgs.append( "-f" )

			# Archive
			#slCmdArgs.append( "'" + oAI.Source.slFiles.first() + "'" )
			slCmdArgs.append( oAI.Source.slFiles.first() )

		else :

			# Extract or test
			if oAI.iOperation == Settings.Operation.iExtract :
				slCmdArgs.append( "x" )
			else :
				slCmdArgs.append( "t" )

			# Answer 'yes' to all queries
			slCmdArgs.append( "-y" )

			# Recursive
			slCmdArgs.append( "-r" )

			# Exclusions
			slWildcards = QtCore.QStringList( Settings.User.Syntax.sExclusions.split( ' ' ) )
			while not slWildcards.isEmpty() and not slWildcards.first().isEmpty() :
				slCmdArgs.append( "-x!" + slWildcards.takeFirst() )

			# Output directory
			#slCmdArgs.append( "-o'" + dOutput.path() + Settings.Path.sSep + "'" )
			slCmdArgs.append( "-o" + dOutput.path() + Settings.Path.sSep )

			# Password
			if oAI.Security.bPassword and not oAI.Security.sPassword.isEmpty() :
				slCmdArgs.append( "-p" + oAI.Security.sPassword )
			else :
				slCmdArgs.append( "-pNoPassword" )

			# Archive
			#slCmdArgs.append( "'" + oAI.Source.slFiles.first() + "'" )
			slCmdArgs.append( oAI.Source.slFiles.first() )

		# Test destination
		if not dOutput.exists() :
			dOutput.mkpath( dOutput.path() )

		# Messages
		File.slMessage( Settings.Message.iInformation, "Archive = " + oAI.Source.slFiles.first() )
		File.slMessage( Settings.Message.iInformation, "Destination = " + dOutput.path() + Settings.Path.sSep )
		File.slMessage( Settings.Message.iInformation, "Command = " + sCmd )
		for iEntry in range(0,slCmdArgs.count()) :
			sArcCmdArgs += slCmdArgs.__getitem__( iEntry ) + " "
		File.slMessage( Settings.Message.iInformation, "Arguments = " + sArcCmdArgs )

		# Execute process
		self.pArc.start( sCmd , slCmdArgs )

		if self.pArc.waitForStarted( Settings.Timer.Process.iPause ) :

			# Messages
			File.slMessage( Settings.Message.iInformation, "The extracting/testing process has started." )

			iWaitCount = 0

			#if not self.pArc.waitForFinished( -1 ) :
			while not self.pArc.waitForFinished( Settings.Timer.Process.iPause ) :
				pass
				#self.emit( QtCore.SIGNAL( "error(QString)" ) , "The extracting/testing process unexpectedly terminated." )
				"""
				if iWaitCount >= Settings.Timer.Process.iWaitMax :
					# Messages
					self.emit( QtCore.SIGNAL( "error(QString)" ) , "The extracting/testing process was taking too long to complete." )
					break
				iWaitCount += 1

				# Get output
				sArcData = QtCore.QString( self.pArc.readData(512) )

				# Password?
				if sArcData.contains( "Enter password" ) :

					# Messages
					File.slMessage( Settings.Message.iInformation, "Password Requested" )

					idPassword = QtGui.QInputDialog()
					Main.uiMain.leEPassword.setText( idPassword.getText( QtGui.QWidget, Settings.Application.sName + ": Enter Password" , Settings.Application.sName + ": Enter Password" ) )
				"""

			sOutput = QtCore.QString( self.pArc.readAllStandardOutput() )
			sError = QtCore.QString( self.pArc.readAllStandardError() )

			# Analyse exit-code
			if self.pArc.exitCode() is not 0 or sOutput.contains( "Break signaled" ) :

				oAI.iProgress = 0
				oAI.bSuccess = False

				# CLI or GUI?
				if sOutput == "" :
					# Using Tar
					if sCmd == Settings.Exec.Tar.sCommand :
						sOutput = sError
					# Invisible or CLI
					elif Import.Init.bInvisible or not Settings.Exec.P7Zip.GUI.bUse :
						sOutput = "An unspecified error occurred, perhaps due to a segmentation fault."

				self.emit( QtCore.SIGNAL( "error(QString)" ) , sOutput )

				File.slMessage( Settings.Message.iError, "File " + str(oAI.Source.iNext) + " failed to extract/test: " + oAI.Source.slFiles.first() )

				# Invisible?
				if Import.Init.bInvisible :
					Display.slQuit()

			else :

				oAI.iProgress = 100
				#oAI.bSuccess = True

				# Messages
				File.slMessage( Settings.Message.iInformation, "File " + str(oAI.Source.iNext) + " was successfully extracted/tested." )

			self.emit( QtCore.SIGNAL( "done(int)" ) , oAI.iProgress )

		else :
			self.emit( QtCore.SIGNAL( "error(QString)" ) , "Can't start the extracting/testing process." )

		return oAI


	def stop( self ) :

		try :
			# Stop archiving
			if self.pArc.state() == QtCore.QProcess.Running :
				self.pArc.kill()
				pShell = Popen( ["killall", Settings.Exec.P7Zip.sCommand], stdout=PIPE, stderr=PIPE )
				pShell.communicate()[0]
				#pShell = Popen( ["kill", str(self.pArc.pid()+1)], stdout=PIPE, stderr=PIPE )
				#pShell.communicate()[0]
				# Messages
				File.slMessage( Settings.Message.iInformation, "The extracting/testing process was stopped by the user." )
		except :
			pass

		# Exit
		self.exit()


	def run( self ) :

		# Invisible?
		if not Import.Init.bInvisible :
			# Priority
			self.setPriority( QtCore.QThread.LowPriority )

		# Process
		#self.pArc = QtCore.QProcess()

		# Profile
		#self.oAI = QtCore.QObject()
		self.oAI = Profile.oInfo

		# Operation
		self.oAI.iSource = Settings.Operation.iExtract

		# Get GUI
		Display.slGuiProfileGetExtract( self.oAI )

		# Execute archiver
		if not self.oAI.Source.slFiles.first().isEmpty() :

			# Extract or test
			if self.oAI.bTest :
				self.oAI.iOperation = Settings.Operation.iTest
				self.emit( QtCore.SIGNAL( "operation(int)" ) , Settings.Operation.iTest )
			else :
				self.oAI.iOperation = Settings.Operation.iExtract
				self.emit( QtCore.SIGNAL( "operation(int)" ) , Settings.Operation.iExtract )

			# Extract/Test archive
			self.extract( self.oAI )

			# Start event loop
			#self.exec_()

		else :
			self.emit( QtCore.SIGNAL( "error(QString)" ) , "" )

		# Invisible?
		if Import.Init.bInvisible :
			Display.slQuit()


### Variables

tiCreate	= tCreate()
tiExtract	= tExtract()


### Slots

# Start the 'create' thread
def slCreate() :

	# Stop
	slArcStop()

	# Disable GUI
	Display.slDisableGUI()

	# Invisible?
	if Import.Init.bInvisible :
		# Start
		tiCreate.run()
		# Start event loop
		#tiCreate.exec_()
	else :
		# Start
		tiCreate.start()
		#tiCreate.setPriority( QtCore.QThread.LowPriority )
		tiCreate.msleep( 50 )


# Start the 'extract' thread
def slExtract() :

	# Stop
	slArcStop()

	# Disable GUI
	Display.slDisableGUI()

	# Invisible?
	if Import.Init.bInvisible :
		# Start
		tiExtract.run()
		# Start event loop
		#tiExtract.exec_()
	else :
		# Start
		tiExtract.start()
		#tiExtract.setPriority( QtCore.QThread.LowPriority )
		tiExtract.msleep( 50 )


# Finished
def slArcDone( iRetVal ) :

	# Quit threads
	#slArcQuit()

	# Progress
	Display.slProgress( iRetVal )

	# Reset GUI
	if iRetVal == 100 :
		Display.slEnableGUI()

	# Default and storage
	if iRetVal == 100 and Settings.Input.iNumArgs >= 3 :
		if Settings.Init.bAutoQuit :
			Display.slQuit()


# Error
def slError( sError ) :

	# Stop
	slArcStop()

	# Error
	Display.slMessage( Settings.Message.iError , sError )


# Stop Archiving
def slArcStop() :

	# Quit threads
	slArcQuit()

	# Reset GUI
	Display.slEnableGUI()


# Quit threads
def slArcQuit() :

	# Create
	if tiCreate.isRunning() :
		tiCreate.stop()
		tiCreate.exit()
		tiCreate.wait( Settings.Timer.Process.iPause )

	# Extract
	if tiExtract.isRunning() :
		tiExtract.stop()
		tiExtract.exit()
		tiExtract.wait( Settings.Timer.Process.iPause )
