# -*- coding: utf-8 -*-
"""
File:		Settings.py
Purpose:	Settings handler
"""


### Imports

# App 1
import	Import

# Python
try :
	import	os, platform, sys, time
	from subprocess import *
	from datetime import date
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore, QtNetwork
except :
	Import.slException( "PyQt4" )

# App 2
import	Display, File, Main


### Variables

# Author
Author					= QtCore.QObject()
Author.sName			= "Chris Giles"
Author.Email			= QtCore.QObject()
Author.Email.sUser		= "Chris.G.27"
Author.Email.sDomain	= "@Gmail.com"

# Application
Application				= QtCore.QObject()
Application.sName		= "Q7Z"
Application.sVersion	= QtCore.QString( "0.8.0" )
Application.sDomain		= "k7z.sourceforge.net"
Application.sCurrent	= "/7Z/" + Application.sName + "/Current.txt"
Application.sDownload	= "http://sourceforge.net/project/showfiles.php?group_id=177755&package_id=204816"
Application.sAbout1 = \
	Application.sName + " " + Application.sVersion + "\nDesigned by " + Author.sName + "\n"
Application.sAbout2 = \
	"\n#7Z is a 7-Zip GUI for Windows; Q7Z is a P7Zip GUI for Linux. #7Z and Q7Z attempt to simplify data compression and backup.\n" \
	"\n7-Zip is a file archiver for Windows with a high compression ratio; P7Zip is a port of 7-Zip from Windows to Linux.\n" \
	"\nSeek further information or send feedback via the 'Help' menu.\n"
Application.sUsage = \
	"\nUsage: " + Application.sName + " [commands] [files]\n" \
	"\ncommands\n\n" \
	"	c: Create archive\n" \
	"	e: Extract archive\n" \
	"	t: Test archive\n\n" \
	"	Create using:\n" \
	"	d: 'Default' profile\n" \
	"	f: 'Flash' profile\n" \
	"	l: 'Local' profile\n" \
	"	r: 'Remote' profile\n" \
	"	s: 'Storage' profile\n" \
	"	L: List file\n\n" \
	"	Extract:\n" \
	"	b: Beneath\n\n" \
	"	i: Invisible\n" \
	"	p: Prevent auto update checking\n" \
	"	v: Verbose\n" \
	"	h: Help\n"

# Qt
QtCore.QCoreApplication.setApplicationName( Application.sName )
QtCore.QCoreApplication.setOrganizationName( Author.sName )
QtCore.QCoreApplication.setOrganizationDomain( Application.sDomain )

# Operating system
sOS					= platform.system()

# Environment
Env = QtCore.QObject()
Env.sDate = str(date.today().isoformat())
Env.sUser = os.getenv( 'USER' ) or ""
Env.sLogName = os.getenv( 'LOGNAME' ) or ""
Env.sHome = os.getenv( 'HOME' ) or ""
Env.sProxy = os.getenv( 'http_proxy' ) or ""
#Env.sKDESV = os.getenv( 'KDE_SESSION_VERSION' ) or ""

if Env.sUser == "" :
	Env.sUser = Env.sLogName

if Env.sHome == "" :
	Env.sHome = os.path.expanduser('~')
	#Env.sHome = '/home/' + Env.sUser

# Path
Path				= QtCore.QObject()
Path.sSep			= QtCore.QString( QtCore.QDir.separator() )
Path.App				= QtCore.QObject()
Path.App.sPrefix	= ""
Path.App.sSBin		= ""
Path.App.sInstall		= "/share/" + Application.sName
Path.App.sConfig		= Env.sHome + '/.config/' + Author.sName + Path.sSep + Application.sName + Path.sSep
Path.KDE			= QtCore.QObject()
Path.KDE.sAutoStart	= ""
Path.KDE.sConfig	= ""
Path.KDE.sPrefix	= ""
Path.KDE.sLocalPrefix	= ""
Path.Xfce		= QtCore.QObject()
Path.Xfce.sAutoStart	= Env.sHome + '/.config/autostart/'
Path.Sys				= QtCore.QObject()
Path.Sys.sPrefix	= "/usr"
Path.Sys.sSBin		= Path.Sys.sPrefix + "/sbin"
Path.Sys.sBin		= Path.Sys.sPrefix + "/bin"
Path.Local					= QtCore.QObject()
Path.Local.sPrefix	= Env.sHome + "/.local"
Path.Local.sSBin		= Path.Local.sPrefix + "/sbin"
Path.Local.sBin			= Path.Local.sPrefix + "/bin"
Path.Proxy			= QtNetwork.QNetworkProxy()

# Init
Init				= QtCore.QObject()
#Init.bVerbose		= False
#Init.bInvisible		= False
Init.bAutoQuit		= False
Init.bAutoUpdate	= True
"""
Init.Create				= QtCore.QObject()
Init.Extract				= QtCore.QObject()
Init.Extract.bBeneath = False
"""

# Timer
Timer						= QtCore.QObject()
Timer.Process				= QtCore.QObject()
Timer.Process.iPause		= 500
Timer.Process.iWaitMax	= 100

# Exec
Exec						= QtCore.QObject()
Exec.P7Zip			= QtCore.QObject()
Exec.P7Zip.CLI	= QtCore.QObject()
Exec.P7Zip.GUI	= QtCore.QObject()
Exec.Tar				= QtCore.QObject()

# Message
Message					= QtCore.QObject()
Message.iClear			= 0
Message.iTitle			= 1
Message.iStatus			= 2
Message.iTray				= 3
Message.iTrayTip		= 4
Message.iInformation	= 5
Message.iError			= 6
Message.iQuestion		= 7

# Input
Input				= QtCore.QObject()
Input.iNumArgs		= len(sys.argv)

"""
# Profiles
Profile				= QtCore.QObject()
Profile.iOther		= 1
Profile.iDefault	= 2
Profile.iStorage	= 3
"""

# Operations
Operation				= QtCore.QObject()
Operation.iCreate		= 0
Operation.iExtract	= 1
Operation.iTest			= 2

# String-lists
List					= QtCore.QObject()
List.slFiles			= QtCore.QStringList()
List.slTHelpCmdArgs		= QtCore.QStringList()

# Setting
Settings					= QtCore.QSettings()
User						= QtCore.QObject()
User.Geometry			= QtCore.QObject()
User.Geometry.bPosition	= False
User.Appearance			= QtCore.QObject()
User.Appearance.bARC		= False
User.Syntax		= QtCore.QObject()
User.Syntax.sExclusions	= ".svn *Trash* *.sys"
#User.smCurrent			= QtGui.QSessionManager()

URL							= QtCore.QObject()
URL.sQ7Z					= QtCore.QString( "http://" + Application.sDomain )
URL.sDocumentation			= QtCore.QString( URL.sQ7Z + "/7Z/Doc/HTML/" )
URL.sP7Zip				= QtCore.QString( "http://p7zip.sourceforge.net/" )
URL.sQt					= QtCore.QString( "http://www.trolltech.com/products/qt" )
URL.sPyQt				= QtCore.QString( "http://www.riverbankcomputing.co.uk/software/pyqt/intro" )
URL.sPython				= QtCore.QString( "http://www.python.org/" )
URL.sTar					= QtCore.QString( "http://www.gnu.org/software/tar/" )
URL.sMake				= QtCore.QString( "http://www.gnu.org/software/make/" )
URL.sCheckInstall	= QtCore.QString( "http://asic-linux.com.mx/~izto/checkinstall/" )
URL.sAutoPackage	= QtCore.QString( "http://www.autopackage.org/" )
URL.sEric				= QtCore.QString( "http://eric-ide.python-projects.org/" )


### Slots

# Inits
def slInits() :

	# Visible?
	# TODO: Try to use the local 'bInvisible' instead
	if not Import.Init.bInvisible :

		# Window
		Settings.beginGroup( "Geometry" )
		#Main.mwMain.resize( Settings.value( "Size" ).toSize() )
		if Settings.contains( "Position" ) :
			User.Geometry.bPosition = True
			Main.mwMain.move( Settings.value( "Position" ).toPoint() )
			# Messages
			File.slMessage( Message.iInformation, "The application settings were loaded from the config file." )
		Settings.endGroup()

	# Others
	slLoad()
	slVariables()
	slCommands()
	slServiceMenus( False )


# Variables
def slVariables() :

	# Linux
	if sOS == "Linux" :

		# KDE Configs
		pShell = Popen( ["which", "kde-config"], stdout=PIPE, stderr=PIPE )
		Path.KDE.sConfig3 = pShell.communicate()[0].rstrip( '\n' )
		pShell = Popen( ["which", "kde4-config"], stdout=PIPE, stderr=PIPE )
		Path.KDE.sConfig4 = pShell.communicate()[0].rstrip( '\n' )

		# KDE 4
		if len( Path.KDE.sConfig4 ) :
			Env.sKDESV = '4'
			Path.KDE.sConfig = Path.KDE.sConfig4
			pShell = Popen( [Path.KDE.sConfig, "--prefix"], stdout=PIPE, stderr=PIPE )
			Path.KDE.sPrefix = pShell.communicate()[0].rstrip( '\n' )
			pShell = Popen( [Path.KDE.sConfig, "--localprefix"], stdout=PIPE, stderr=PIPE )
			Path.KDE.sLocalPrefix = pShell.communicate()[0].rstrip( '\n' )
			#pShell = Popen( [Path.KDE.sConfig, "--qt-binaries"], stdout=PIPE, stderr=PIPE )
			#Path.Sys.sBin = pShell.communicate()[0].rstrip( '\n' )
		# KDE 3
		elif len( Path.KDE.sConfig3 ) :
			Env.sKDESV = '3'
			Path.KDE.sConfig = Path.KDE.sConfig3
			pShell = Popen( [Path.KDE.sConfig, "--prefix"], stdout=PIPE, stderr=PIPE )
			Path.KDE.sPrefix = pShell.communicate()[0].rstrip( '\n' )
			pShell = Popen( [Path.KDE.sConfig, "--localprefix"], stdout=PIPE, stderr=PIPE )
			Path.KDE.sLocalPrefix = pShell.communicate()[0].rstrip( '\n' )
		# Unknown
		else :
			Env.sKDESV = '?'
			Path.KDE.sConfig = ""
			Path.KDE.sPrefix = '/usr'
			Path.KDE.sLocalPrefix = Env.sHome + '/.kde4/'
			#Path.Sys.sBin = Path.Sys.sPrefix + '/bin'

		# Misc
		Path.KDE.sAutoStart = Path.KDE.sLocalPrefix + "/Autostart/"

		# Installation
		# KDE
		if QtCore.QFile.exists( Path.Sys.sPrefix + Path.App.sInstall + "/Source/" ) :
			Path.App.sPrefix	= Path.Sys.sPrefix
			Path.App.sSBin		= Path.App.sPrefix + "/sbin"
		# User
		elif QtCore.QFile.exists( Path.Local.sPrefix + Path.App.sInstall + "/Source/" ) :
			Path.App.sPrefix	= Path.Local.sPrefix
			Path.App.sSBin		= Path.App.sPrefix + "/sbin"
		# Local
		else :
			Path.App.sPrefix	= os.path.realpath( os.path.dirname( __file__ ) ) + "/../"
			Path.App.sSBin		= Path.App.sPrefix + "/Bin"
			Path.App.sInstall	= ""

		# Proxy
		if Env.sProxy != "" :

			sProxy = QtCore.QString( Env.sProxy )

			# Type
			#Path.Proxy.setType( QtNetwork.QNetworkProxy.HttpProxy )
			Path.Proxy.setType( QtNetwork.QNetworkProxy.HttpCachingProxy )

			# Protocol supplied
			if sProxy.contains( "://" ) :
				sProxy = sProxy.section( "://" , 1 , 1 )

			# Username and password supplied
			if sProxy.contains( '@' ) :
				sLogin = sProxy.section( '@' , 0 , 0 )
				sProxy = sProxy.section( '@' , 1 , 1 )
				Path.Proxy.setUser( sLogin.section( ':' , 0 , 0 ) )
				Path.Proxy.setPassword( sLogin.section( ':' , 1 , 1 ) )

			# Port supplied
			if sProxy.contains( ':' ) :
				Path.Proxy.setHostName( sProxy.section( ':' , 0 , 0 ) )
				sPort = QtCore.QString( sProxy.section( ':' , 1 , 1 ) )
				Path.Proxy.setPort( int( sPort.section( '/' , 0 , 0 ) ) )
			else :
				Path.Proxy.setHostName( sProxy.section( '/' , 0 , 0 ) )
				Path.Proxy.setPort( int( 80 ) )

			# Temp
			#Path.Proxy.setApplicationProxy( Path.Proxy )

		# Display
		Display.slInit()

	# Others
	else :

		print "\nUnfortunately, your OS is not yet supported by " + Application.sName + " " + Application.sVersion + ".\n \
					Please email the author, specifying your system details.\n"

		# Exit
		sys.exit()

	"""
	# Windows
	elif sOS == "Windows" :

		if not Path.Sys.sPrefix :
			Path.Sys.sPrefix	= ''

		if not Path.KDE.sLocalPrefix :
			Path.KDE.sLocalPrefix	= ''

		Path.sReg	= QtCore.QSettings( "HKEY_LOCAL_MACHINE\\Software\\Archiving\\" + Application.sName , QtCore.QSettings.NativeFormat )
		Path.App.sPrefix	= Path.sReg.value( "Path" ).toString()

		# Commands
		Path.sReg		= QtCore.QSettings( "HKEY_LOCAL_MACHINE\\Software\\7-Zip" , QtCore.QSettings.NativeFormat )
		Exec.P7Zip.CLI.sCommand		= Path.sReg.value( "Path" ).toString() + "/7z.exe"
	"""

	# Verbose
	File.slVariables()


# Commands
def slCommands() :

	bRet = True

	# Static
	Exec.Tar.sCommand		= "tar"

	# Tests
	pShell = Popen( ["which", Exec.Tar.sCommand], stdout=PIPE, stderr=PIPE )
	if QtCore.QString( pShell.communicate()[0] ).isEmpty() :
		bRet = False
		Display.slNoBin( "Tar" , URL.sTar )

	# Messages
	File.slMessage( Message.iInformation, "The optional commands will now be found and selected." )

	# Dynamic
	# P7Zip-GUI
	Exec.P7Zip.GUI.sCommand, Exec.P7Zip.GUI.sArgs = File.slChooseBinary( "P7Zip-GUI" , "" )
	if QtCore.QString( Exec.P7Zip.GUI.sCommand ).isEmpty() :
		Exec.P7Zip.GUI.bUse = False
		#Display.slNoBin( "P7Zip-GUI" , URL.sP7Zip )
	else :
		Exec.P7Zip.GUI.bUse = True
	# P7Zip-CLI
	Exec.P7Zip.CLI.sCommand, Exec.P7Zip.CLI.sArgs = File.slChooseBinary( "P7Zip-CLI" , "" )
	if QtCore.QString( Exec.P7Zip.CLI.sCommand ).isEmpty() :
		bRet = False
		Display.slNoBin( "P7Zip-CLI" , URL.sP7Zip )

	return bRet


# Verbose
def slVerbose() :

	Import.Init.bVerbose = Main.uiMain.aVerbose.isChecked()
	Main.uiMain.aAReview.setEnabled( Import.Init.bVerbose )

	File.slAbout()
	Display.slMessage( Message.iStatus , "Verbose mode was toggled" ) ;


# Load
def slLoad() :

	# Syntax
	Settings.beginGroup( "Syntax" )
	if Settings.contains( "Exclusions" ) :
		User.Syntax.sExclusions = Settings.value( "Exclusions" ).toString().trimmed()
		# Messages
		File.slMessage( Message.iInformation, "The user settings were loaded from the config file." )
	Settings.endGroup()

	# Visible?
	if not Import.Init.bInvisible :
		Main.uiSettings.leExclExt.setText( User.Syntax.sExclusions )

	# Linux
	if sOS == "Linux" :

		# Visible?
		if not Import.Init.bInvisible :

			# KDE 4 service menus
			sDestPath = "/share/kde4/services/ServiceMenus/"

			# Check Top Level
			if QtCore.QFile.exists( Path.KDE.sLocalPrefix + sDestPath + Application.sName + ".marker.top" ) :
				Main.uiSettings.cbKTopLevel.setCheckState( QtCore.Qt.Checked )
			else :
				Main.uiSettings.cbKTopLevel.setCheckState( QtCore.Qt.Unchecked )

			# Enable
			#Main.uiSettings.gbKonq.setEnabled( True )

# Save
def slSave() :

	# Window
	Settings.beginGroup( "Geometry" )
	#Settings.setValue( "Size" , QtCore.QVariant(Main.mwMain.size()) )
	Settings.setValue( "Position" , QtCore.QVariant(Main.mwMain.pos()) )
	#Settings.remove( "Position" )
	Settings.endGroup()

	# Messages
	File.slMessage( Message.iInformation, "The application settings were saved to the config file." )

# Accept
def slAccept() :

	# Syntax
	User.Syntax.sExclusions = Main.uiSettings.leExclExt.displayText().trimmed()
	User.Syntax.sExclusions.remove( ',' )
	User.Syntax.sExclusions.remove( ';' )

	Settings.beginGroup( "Syntax" )
	Settings.setValue( "Exclusions" , QtCore.QVariant(User.Syntax.sExclusions) )
	Settings.endGroup()

	# Messages
	File.slMessage( Message.iInformation, "The user settings were saved to the config file." )

	# Linux
	if sOS == "Linux" :

		# User service menus
		slServiceMenus( True )

	# Commands
	slCommands()


# Dialog
def slDialog() :

	# Load
	slLoad()

	# Modal
	Main.dSettings.exec_()


# User service menus
def slServiceMenus( bGUI ) :

	sBackupPath = Path.App.sPrefix + Path.App.sInstall + "/Desktop"

	# Gnome service menus
	sDestPath = "/.gnome2/nautilus-scripts/Archiving/" + Application.sName

	# Create directory
	dDestPath = QtCore.QDir( Env.sHome + sDestPath )
	if not dDestPath.exists() :

		# Messages
		#File.slMessage( Message.iInformation, "Service Menus (Gnome) = " + Env.sHome + sDestPath )

		dDestPath.mkpath( Env.sHome + sDestPath )
		dDestPath.mkpath( Env.sHome + sDestPath + "/Create/" )
		dDestPath.mkpath( Env.sHome + sDestPath + "/Extract/" )

		# Copy files
		pShell = Popen( "cp -r " + sBackupPath + "/Gnome/* " + Env.sHome + sDestPath, shell=True, stdout=PIPE, stderr=PIPE )
		pShell.communicate()[0]

	# Xfce service menus
	sDestPath = "/.config/Thunar"

	# Create directory
	dDestPath = QtCore.QDir( Env.sHome + sDestPath )
	if not dDestPath.exists() :

		dDestPath.mkpath( Env.sHome + sDestPath )

	if not QtCore.QFile.exists( Env.sHome + sDestPath + "/uca.xml." + Application.sName ) :

		# Messages
		#File.slMessage( Message.iInformation, "Service Menus (Xfce) = " + Env.sHome + sDestPath )

		QtCore.QFile.copy( sBackupPath + "/Xfce/uca.xml" ,  Env.sHome + sDestPath + "/uca.xml." + Application.sName )

	# Use GUI settings?
	if bGUI :

		# Top Level?
		if Main.uiSettings.cbKTopLevel.isChecked() :
			sFileExt = ".top"
		else :
			sFileExt = ""

		# KDE 4 service menus
		sDestPath = "/share/kde4/services/ServiceMenus/"

		# Messages
		#File.slMessage( Message.iInformation, "Service Menus (KDE 4) = " + Path.KDE.sLocalPrefix + sDestPath )

		# Remove current entries
		pShell = Popen( "rm -f " + Path.KDE.sLocalPrefix + sDestPath + Application.sName + "*", shell=True, stdout=PIPE, stderr=PIPE )
		pShell.communicate()[0]

		# Create directory
		dDestPath = QtCore.QDir( Path.KDE.sLocalPrefix + sDestPath )
		if not dDestPath.exists() :
			dDestPath.mkpath( Path.KDE.sLocalPrefix + sDestPath )

		# Copy files
		QtCore.QFile.copy( sBackupPath + "/KDE/" + Application.sName + "c.desktop" + sFileExt , Path.KDE.sLocalPrefix + sDestPath + Application.sName + "c.desktop" )
		QtCore.QFile.copy( sBackupPath + "/KDE/" + Application.sName + "e.desktop" + sFileExt , Path.KDE.sLocalPrefix + sDestPath + Application.sName + "e.desktop" )
		QtCore.QFile.copy( sBackupPath + "/KDE/" + Application.sName + ".marker" , Path.KDE.sLocalPrefix + sDestPath + Application.sName + ".marker" + sFileExt )
