"""
File:		Profile.py
Purpose:	Profile handler
"""


### Imports

# App 1
import	Import

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException( "PyQt4" )

# App 2
import	Display, File, Main, Settings


### Variables

# Profile
oInfo						= QtCore.QObject()
oInfo.Type				= QtCore.QObject()
oInfo.Type.bSFX			= False
oInfo.Type.bSolid		= False
oInfo.Security					= QtCore.QObject()
oInfo.Security.bScramble = False
oInfo.Security.bPassword = False
oInfo.Source					= QtCore.QObject()
oInfo.Source.slFiles		= QtCore.QStringList()
oInfo.Dest						= QtCore.QObject()
oInfo.Dest.bDest			= False
oInfo.Dest.bStructured	= False
oInfo.Dest.bSeparate		= False
oInfo.Dest.bName			= False
oInfo.Misc				= QtCore.QObject()


### Slots

# Load profile
def slLoad( sName ) :

	sProPath = QtCore.QString( Settings.Path.App.sConfig + "/Profiles/" )

	# Choose file
	if sName != "" :
		sProPath += sName + ".txt"
	else :
		sProPath = QtGui.QFileDialog.getOpenFileName( None , "" , sProPath , "Profiles (*.txt)" )

	if not sProPath.isEmpty() :

		if not sProPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sProPath += ".txt"

		# Read profile
		fPro = QtCore.QFile( sProPath )

		# Determine filename
		sName = fPro.fileName().section( Settings.Path.sSep , -1 , -1 )
		sName = sName.left( sName.lastIndexOf( '.' ) )

		if not fPro.open( QtCore.QIODevice.ReadOnly | QtCore.QIODevice.Text ) :

			# Messages
			Display.slMessage( Settings.Message.iError , "Can't load the '" + sName + "' profile" )

		else :

			# Profile
			oPI = oInfo

			# Defaults
			oPI.Misc.bSwitches = False
			oPI.Misc.sSwitches = ""

			# Prepare text stream
			tsPro = QtCore.QTextStream( fPro )

			while not tsPro.atEnd() :
				sLine = QtCore.QString( tsPro.readLine() )

				# Recognised options

				# Type
				if sLine.startsWith( "Archive_Format " ) :
					oPI.Type.sAlgorithm = sLine.section( ' ', 2 )
				elif sLine.startsWith( "Creation_Method " ) :
					oPI.Type.sMethod = sLine.section( ' ', 2 )
				elif sLine.startsWith( "Compression_Level " ) :
					oPI.Type.sComp = sLine.section( ' ', 2 )
				elif sLine.startsWith( "Volume_Size " ) :
					oPI.Type.sVolume = sLine.section( ' ', 2 )
				elif sLine.startsWith( "SFX " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Type.bSFX = True
					else :
						oPI.Type.bSFX = False
				elif sLine.startsWith( "Solid " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Type.bSolid = True
					else :
						oPI.Type.bSolid = False

				# Security
				elif sLine.startsWith( "Scramble " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Security.bScramble = True
					else :
						oPI.Security.bScramble = False
				elif sLine.startsWith( "Password " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Security.bPassword = True
					else :
						oPI.Security.bPassword = False

				# Destination
				elif sLine.startsWith( "Destination " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Dest.bDest = True
					else :
						oPI.Dest.bDest = False
				elif sLine.startsWith( "Structured " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Dest.bStructured = True
					else :
						oPI.Dest.bStructured = False
				elif sLine.startsWith( "Separate " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Dest.bSeparate = True
					else :
						oPI.Dest.bSeparate = False
				elif sLine.startsWith( "Destination_Dir " ) :
					oPI.Dest.sDir = sLine.section( ' ', 2 )
				elif sLine.startsWith( "Archive_Name " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Dest.bName = True
					else :
						oPI.Dest.bName = False

				# Misc
				elif sLine.startsWith( "Switches " ) :
					if sLine.section( ' ', 2 ) == "Yes" :
						oPI.Misc.bSwitches = True
					else :
						oPI.Misc.bSwitches = False
				if sLine.startsWith( "Switches_List " ) :
					oPI.Misc.sSwitches = sLine.section( ' ', 2 ).trimmed()

			fPro.close()

			# Messages
			Display.slMessage( Settings.Message.iStatus , "Loaded the '" + sName + "' profile" )

			# Set GUI
			Display.slGuiProfileSetCreate( oPI )


# Load 'Other' profile
def slLoadOther() :
	slLoad( "" )

# Load 'Default' profile
def slLoadDefault() :
	slLoad( "Default" )

# Load 'Flash' profile
def slLoadFlash() :
	slLoad( "Flash" )

# Load 'Local' profile
def slLoadLocal() :
	slLoad( "Local" )

# Load 'Remote' profile
def slLoadRemote() :
	slLoad( "Remote" )

# Load 'Secure' profile
def slLoadSecure() :
	slLoad( "Secure" )

# Load 'Storage' profile
def slLoadStorage() :
	slLoad( "Storage" )


# Save profile
def slSave( sName ) :

	sProPath = QtCore.QString( Settings.Path.App.sConfig + "/Profiles/" )

	# Choose file
	if sName != "" :
		sProPath += sName + ".txt"
	else :
		sProPath = QtGui.QFileDialog.getSaveFileName( None , "" , sProPath ,
			"Profiles (*.txt)" , "" , QtGui.QFileDialog.DontConfirmOverwrite )

	if not sProPath.isEmpty() :

		if not sProPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sProPath += ".txt"

		# Write profile
		fPro = QtCore.QFile( sProPath )

		# Determine filename
		sName = fPro.fileName().section( Settings.Path.sSep , -1 , -1 )
		sName = sName.left( sName.lastIndexOf( '.' ) )

		if not fPro.open( QtCore.QIODevice.WriteOnly | QtCore.QIODevice.Text ) :

			# Messages
			Display.slMessage( Settings.Message.iError , "Can't save the '" + sName + "' profile" )

		else :

			# Profile
			oPI = oInfo

			# Get GUI
			Display.slGuiProfileGetCreate( oPI )

			# Prepare text stream
			tsPro = QtCore.QTextStream( fPro )

			# Header
			tsPro << "### " + Settings.Application.sName + " " + Settings.Application.sVersion + ": Profile\n"

			# Recognised options

			# Type
			tsPro << "\n# Type\n"
			tsPro << "Archive_Format = " + oPI.Type.sAlgorithm + "\n"
			tsPro << "Creation_Method = " + oPI.Type.sMethod + "\n"
			tsPro << "Compression_Level = " + oPI.Type.sComp + "\n"
			tsPro << "Volume_Size = " + oPI.Type.sVolume + "\n"
			if not oPI.Type.bSFX :
				tsPro << "SFX = No\n"
			else :
				tsPro << "SFX = Yes\n"
			if not oPI.Type.bSolid :
				tsPro << "Solid = No\n"
			else :
				tsPro << "Solid = Yes\n"

			# Security
			tsPro << "\n# Security\n"
			if not oPI.Security.bScramble :
				tsPro << "Scramble = No\n"
			else :
				tsPro << "Scramble = Yes\n"
			if not oPI.Security.bPassword :
				tsPro << "Password = No\n"
			else :
				tsPro << "Password = Yes\n"

			# Destination
			tsPro << "\n# Destination\n"
			if not oPI.Dest.bDest :
				tsPro << "Destination = No\n"
			else :
				tsPro << "Destination = Yes\n"
			if not oPI.Dest.bStructured :
				tsPro << "Structured = No\n"
			else :
				tsPro << "Structured = Yes\n"
			if not oPI.Dest.bSeparate :
				tsPro << "Separate = No\n"
			else :
				tsPro << "Separate = Yes\n"
			tsPro << "Destination_Dir = " + oPI.Dest.sDir + "\n"
			if not oPI.Dest.bName :
				tsPro << "Archive_Name = No\n"
			else :
				tsPro << "Archive_Name = Yes\n"

			# Misc
			tsPro << "\n# Misc\n"
			if not oPI.Misc.bSwitches :
				tsPro << "Switches = No\n"
			else :
				tsPro << "Switches = Yes\n"
			tsPro << "Switches_List = " + oPI.Misc.sSwitches.trimmed() + "\n"

			fPro.close()

			# Messages
			Display.slMessage( Settings.Message.iStatus , "Saved the '" + sName + "' profile" )

# Save 'Other' profile
def slSaveOther() :
	slSave( "" )

# Save 'Default' profile
def slSaveDefault() :
	slSave( "Default" )

# Save 'Flash' profile
def slSaveFlash() :
	slSave( "Flash" )

# Save 'Local' profile
def slSaveLocal() :
	slSave( "Local" )

# Save 'Remote' profile
def slSaveRemote() :
	slSave( "Remote" )

# Save 'Secure' profile
def slSaveSecure() :
	slSave( "Secure" )

# Save 'Storage' profile
def slSaveStorage() :
	slSave( "Storage" )


# Reset profile
def slReset( sName ) :

	sBackupPath = Settings.Path.App.sPrefix + Settings.Path.App.sInstall + "/Desktop/Profiles/"
	sBackupPath += sName + ".txt"
	sProPath = QtCore.QString( Settings.Path.App.sConfig + "/Profiles/" + sName + ".txt" )

	# Remove current
	QtCore.QFile.remove( sProPath )

	# Copy original
	if QtCore.QFile.copy( sBackupPath , sProPath ) :
		Display.slMessage( Settings.Message.iStatus , "Reset the '" + sName + "' profile" )
	else :
		Display.slMessage( Settings.Message.iStatus , "Can't reset the '" + sName + "' profile" )


# Reset 'Default' profile
def slResetDefault() :
	slReset( "Default" )

# Reset 'Flash' profile
def slResetFlash() :
	slReset( "Flash" )

# Reset 'Local' profile
def slResetLocal() :
	slReset( "Local" )

# Reset 'Remote' profile
def slResetRemote() :
	slReset( "Remote" )

# Reset 'Secure' profile
def slResetSecure() :
	slReset( "Secure" )

# Reset 'Storage' profile
def slResetStorage() :
	slReset( "Storage" )
