"""
File:		List.py
Purpose:	List handler
"""


### Imports

# App 1
import	Import

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException( "PyQt4" )

# App 2
import	Display, File, Help, Main, Settings


### Variables

"""
# List
oInfo			= QtCore.QObject()
oInfo.sName		= QtCore.QString()
"""

### Slots

# Load list
def slLoad( sName ) :

	sName = QtCore.QString( sName )
	sPath = QtCore.QString( Settings.Path.App.sConfig + "/Lists/" )

	# Choose file
	if not sName.isEmpty() :
		sPath += sName + ".txt"
	else :
		sPath = QtGui.QFileDialog.getOpenFileName( None , "" , sPath , "Lists (*.txt)" )

	if not sPath.isEmpty() :

		# Forget current files
		Settings.List.slFiles.clear()

		if not sPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sPath += ".txt"

		# Read list file
		fList = QtCore.QFile( sPath )

		# Determine filename
		sName = fList.fileName().section( Settings.Path.sSep , -1 , -1 )
		sName = sName.left( sName.lastIndexOf( '.' ) )

		if not fList.open( QtCore.QIODevice.ReadOnly | QtCore.QIODevice.Text ) :

			# Messages
			Display.slMessage( Settings.Message.iError , "Can't load the '" + sName + "' list" )

		else :

			# Prepare text stream
			tsList = QtCore.QTextStream( fList )

			while not tsList.atEnd() :
				sLine = QtCore.QString( tsList.readLine() )

				# Test the path validity
				if QtCore.QFile.exists( sLine ) :
					Settings.List.slFiles.append( sLine )

			fList.close()

			# Messages
			Display.slMessage( Settings.Message.iStatus , "Loaded the '" + sName + "' list" )

			Display.slGUIExternal( Settings.Operation.iCreate )

# Load 'Other' list
def slLoadOther() :
	slLoad( "" )


# Edit list
def slEdit( sName ) :

	sName = QtCore.QString( sName )
	sPath = QtCore.QString( Settings.Path.App.sConfig + "/Lists/" )

	# Choose file
	if not sName.isEmpty() :
		sPath += sName + ".txt"
	else :
		sPath = QtGui.QFileDialog.getOpenFileName( None , "" , sPath , "Lists (*.txt)" )

	if not sPath.isEmpty() :

		if not sPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sPath += ".txt"

		# Read list file
		fList = QtCore.QFile( sPath )

		# Determine filename
		sName = fList.fileName().section( Settings.Path.sSep , -1 , -1 )
		sName = sName.left( sName.lastIndexOf( '.' ) )

		# Test existence
		if not fList.exists() :
			# Messages
			Display.slMessage( Settings.Message.iError , "Can't edit the '" + sName + "' list" )
		else :
			Help.slUOpen( QtCore.QUrl( "file:" + sPath ) )

# Edit 'Other' list
def slEditOther() :
	slEdit( "" )


# Save list
def slSave( sName ) :

	sName = QtCore.QString( sName )
	sPath = QtCore.QString( Settings.Path.App.sConfig + "/Lists/" )

	# Choose file
	if not sName.isEmpty() :
		sPath += sName + ".txt"
	else :
		sPath = QtGui.QFileDialog.getSaveFileName( None , "" , sPath ,
			"Lists (*.txt)" , "" , QtGui.QFileDialog.DontConfirmOverwrite )

	if not sPath.isEmpty() :

		if not sPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sPath += ".txt"

		# Read list file
		fList = QtCore.QFile( sPath )

		# Determine filename
		sName = fList.fileName().section( Settings.Path.sSep , -1 , -1 )
		sName = sName.left( sName.lastIndexOf( '.' ) )

		if not fList.open( QtCore.QIODevice.WriteOnly | QtCore.QIODevice.Text ) :

			# Messages
			Display.slMessage( Settings.Message.iError , "Can't save the '" + sName + "' list" )

		else :

			# Prepare text stream
			tsList = QtCore.QTextStream( fList )

			# Header
			tsList << "### " + Settings.Application.sName + " " + Settings.Application.sVersion + ": List\n"
			tsList << "\n# Directories and/or files\n"

			# List of files to archive
			for iEntry in range(0,Settings.List.slFiles.count()) :
				tsList << Settings.List.slFiles.__getitem__(iEntry) + "\n"

			fList.close()

			# Messages
			Display.slMessage( Settings.Message.iStatus , "Saved the '" + sName + "' list" )

# Save 'Other' list
def slSaveOther() :
	slSave( "" )
