"""
File:		Input.py
Purpose:	Input arguments handler
"""


### Imports

# App 1
import	Import

# Python
try :
	import	sys
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore
except :
	Import.slException( "PyQt4" )

# App 2
import	Display, Import, File, List, Main, Profile, Settings, Thread


### Slots

# CLI Arguments
def slArgTest() :

	# Supplied arguments
	if Settings.Input.iNumArgs >= 2 :

		# Help
		if "h" in sys.argv[1] :

			print Settings.Application.sAbout1
			print Settings.Application.sAbout2
			print Settings.Application.sUsage

			# Exit
			sys.exit()

		"""
		# Verbose
		if "v" in sys.argv[1] :

			Import.Init.bVerbose = True

			File.slAbout()
		"""

		# Profile
		if "f" in sys.argv[1] :
			Profile.slLoadFlash()
		elif "l" in sys.argv[1] :
			Profile.slLoadLocal()
		elif "r" in sys.argv[1] :
			Profile.slLoadRemote()
		elif "s" in sys.argv[1] :
			Profile.slLoadStorage()
		else :
			Profile.slLoadDefault()

		# Auto-Updates
		if "p" in sys.argv[1] :
			Settings.Init.bAutoUpdate = False

		# Supplied arguments
		if Settings.Input.iNumArgs >= 3 :

			# Visibility
			"""
			if "i" in sys.argv[1] :
				Settings.Init.bInvisible = True
			"""
			#Settings.Init.bInvisible = Import.Init.bInvisible

			if "L" in sys.argv[1] :
				# Use a list file
				List.slLoad( sys.argv[2] )
			else :
				# List of files to archive
				for iEntry in range(2,Settings.Input.iNumArgs) :
					Settings.List.slFiles.append( sys.argv[iEntry].decode('utf-8') )

			# Create Archive
			if "c" in sys.argv[1] :

				# Arrange the interface
				Display.slGUIExternal( Settings.Operation.iCreate )

				# Auto-quit
				if "d" in sys.argv[1] or "f" in sys.argv[1] or "l" in sys.argv[1] or "r" in sys.argv[1] or "s" in sys.argv[1] :
					Settings.Init.bAutoQuit = True
					Thread.slCreate()

			# Extract Archive
			elif "e" in sys.argv[1] :

				# Arrange the interface
				Display.slGUIExternal( Settings.Operation.iExtract )

				# Beneath
				if "b" in sys.argv[1] :
					Display.slGUIBeneath()

				# Profile
				if "d" in sys.argv[1] :
					Settings.Init.bAutoQuit = True
					Thread.slExtract()

			# Extract Archive
			elif "t" in sys.argv[1] :

				# Arrange the interface
				Display.slGUIExternal( Settings.Operation.iTest )

				# Default
				if "d" in sys.argv[1] :
					Settings.Init.bAutoQuit = True
					Thread.slExtract()

	else :

		# Load 'Default' profile
		Profile.slLoadDefault()
