"""
File:		Help.py
Purpose:	Help menu handler
"""


### Imports

# App 1
import	Import

# Python
try :
	import	random
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore, QtNetwork
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException( "PyQt4" )

# App 2
import	Display, File, Main, Settings


### Slots

# About Qt4
def slAboutQt4() :
	QtGui.QApplication.aboutQt()

# About Q7Z
def slAboutQ7Z() :

	# Replacements
	sMessage = QtCore.QString( Settings.Application.sAbout1 + Settings.Application.sAbout2 ).replace( "\n" , "<br>" )

	# Message
	QtGui.QMessageBox.about( Main.uiMain.cwMain, "About " + Settings.Application.sName, sMessage )


# Open URL
def slUOpen( uURL ) :

	Display.slMessage( Settings.Message.iStatus , "Launching the URL handler ..." )

	# Visible?
	if not Import.Init.bInvisible :
		QtGui.QDesktopServices.openUrl( uURL )


# UIsNewer
def slUIsNewer( sLocal , sRemote ) :

	bNewer = False

	# Compare
	if not sLocal.isEmpty() and not sRemote.isEmpty() :

		# Major
		if sLocal[0].toInt() < sRemote[0].toInt() :
			bNewer = True
		elif sLocal[0].toInt() == sRemote[0].toInt() :
			# Minor
			if sLocal[2].toInt() < sRemote[2].toInt() :
				bNewer = True
			elif sLocal[2].toInt() == sRemote[2].toInt() :
				# Point
				if sLocal[4].toInt() < sRemote[4].toInt() :
					bNewer = True

	return bNewer


# Variables
Update = QtCore.QObject()
Update.bAuto = False
Update.hCurrent = QtNetwork.QHttp()

# Done
def slUDone( bError ) :
#def slUDone( iID , bError ) :

	# Prevent recalls
	Update.hCurrent.disconnect( Update.hCurrent , QtCore.SIGNAL("done(bool)") , slUDone )

	if not bError :

		bGet = False
		bFound = False

		sData = QtCore.QString( Update.hCurrent.readAll() )

		if sData.isEmpty() :

			slUBegin()

		elif sData.contains( "<HTML>" ) :

			# Messages
			#if not Update.bAuto :
			Display.slMessage( Settings.Message.iError , "The updates server can't be contacted.<br>Check your network settings and try again." )

		else :

			slLines = QtCore.QStringList( sData.split( '\n' ) )
			sReqVer = QtCore.QString()
			sRecVer = QtCore.QString()

			while not slLines.isEmpty() :

				sLine = QtCore.QString( slLines.takeFirst() )
				slElems = QtCore.QStringList( sLine.split( ' ' ) )

				if slElems.count() == 3 :

					if slElems.first() == "Required" :
						sReqVer = str( slElems.last() )
						bFound = True ;
					elif slElems.first() == "Recommended" :
						sRecVer = str( slElems.last() )
						bFound = True ;

		if bFound :

			try :

				# Major
				if slUIsNewer( Settings.Application.sVersion , QtCore.QString(sReqVer) ) :

					# Messages
					bGet = Display.slMessage( Settings.Message.iQuestion , Settings.Application.sName + " " + sReqVer + " is available.<br><br>Would you like to download this stable release now?" )

				# Minor
				elif slUIsNewer( Settings.Application.sVersion , QtCore.QString(sRecVer) ) and not Update.bAuto :

					# Messages
					bGet = Display.slMessage( Settings.Message.iQuestion , Settings.Application.sName + " " + sRecVer + " is available.<br><br>Would you like to download this beta release now?" )

				# None
				else :

					# Messages
					if not Update.bAuto :
						Display.slMessage( Settings.Message.iInformation , "You're already using the latest release." )

				# Get
				if bGet == QtGui.QMessageBox.Yes :

					# Launch
					slUOpen( QtCore.QUrl( Settings.Application.sDownload ) )

					# Quit
					#Main.uiMain.aAQuit.trigger()
					Display.slQuit()

			except :

				# Messages
				#if not Update.bAuto :
				Display.slMessage( Settings.Message.iError, "Can't compare the local and remote version numbers." )

	else :

		# Messages
		#if not Update.bAuto :
		Display.slMessage( Settings.Message.iError , "The updates server can't be contacted.<br>Check your network settings and try again." )

	Update.bAuto = False

	# Clear
	Display.slMessage( Settings.Message.iClear , "" )

# Begin
def slUBegin() :

	# Check
	#Display.slMessage( Settings.Message.iTitle , "Checking ..." )
	Display.slMessage( Settings.Message.iStatus , "Checking for a newer release ..." )

	Update.hCurrent = QtNetwork.QHttp()
	Update.hCurrent.setHost( Settings.Application.sDomain )
	if not Settings.Path.Proxy.hostName().isEmpty() :
		Update.hCurrent.setProxy( Settings.Path.Proxy )
	Update.hCurrent.connect( Update.hCurrent , QtCore.SIGNAL("done(bool)") , slUDone )
	#Update.hCurrent.connect( Update.hCurrent , QtCore.SIGNAL("requestFinished(int,bool)") , slUDone )

	if not Update.hCurrent.get( Settings.Application.sCurrent ) :
	#and not Update.bAuto :
		Display.slMessage( Settings.Message.iError , "The updates server can't be contacted.<br>Check your network settings and try again." )

# Begin
def slUCheck() :

	# Auto-Update
	if Settings.Init.bAutoUpdate and not Import.Init.bInvisible :

		if random.randint( 0 , 10 ) == 5 :
		#if random.randint( 0 , 0 ) == 0 :

			# Silent
			Update.bAuto = True

			slUBegin()


# Feedback: Bad
def slFBBad() :

	# Set URL
	uURL = QtCore.QUrl( "mailto:" + Settings.Author.Email.sUser + Settings.Author.Email.sDomain + "?subject=" + Settings.Application.sName + " " + Settings.Application.sVersion + ": Feedback: Bad" )

	slUOpen( uURL )

# Feedback: Good
def slFBGood() :

	# Set URL
	uURL = QtCore.QUrl( "mailto:" + Settings.Author.Email.sUser + Settings.Author.Email.sDomain + "?subject=" + Settings.Application.sName + " " + Settings.Application.sVersion + ": Feedback: Good" )

	slUOpen( uURL )

# Feedback: Idea
def slFBIdea() :

	# Set URL
	uURL = QtCore.QUrl( "mailto:" + Settings.Author.Email.sUser + Settings.Author.Email.sDomain + "?subject=" + Settings.Application.sName + " " + Settings.Application.sVersion + ": Feedback: Idea" )

	slUOpen( uURL )


# URL: Q7Z
def slUQ7Z() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sQ7Z ) )

# URL: P7Zip
def slUP7Zip() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sP7Zip ) )

# URL: Qt4
def slUQt4() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sQt ) )

# URL: PyQt4
def slUPyQt4() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sPyQt ) )

# URL: Python
def slUPython() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sPython ) )

# URL: Tar
def slUTar() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sTar ) )

# URL: Make
def slUMake() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sMake ) )

# URL: CheckInstall
def slUCheckInstall() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sCheckInstall ) )

# URL: AutoPackage
def slUAutoPackage() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sAutoPackage ) )

# URL: Eric
def slUEric() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sEric ) )


# Documentation
def slDoc() :

	# Set URL
	slUOpen( QtCore.QUrl( Settings.URL.sDocumentation ) )

"""
# Doc: Changes
def slDocChanges() :

	# Set URL
	slUOpen( QtCore.QUrl( "file:" + Settings.Path.App.sPrefix + Settings.Path.App.sInstall + "/Doc/ChangeLog.txt" ) )
"""
