"""
File:		File.py
Purpose:	File handler
"""


### Imports

# App 1
import	Import

# Python
try :
	from subprocess import *
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException( "PyQt4" )

# App 2
import	Display, Help, Profile, Settings


### Variables


### Slots

# Review output
def slReview() :

	sName = QtCore.QString()
	sPath = QtCore.QString( Settings.Path.App.sConfig + "/Output/" )

	# Choose file
	if not sName.isEmpty() :
		sPath += sName + ".txt"
	else :
		sPath = QtGui.QFileDialog.getOpenFileName( None , "" , sPath , "Outputs (*.txt)" )

	if not sPath.isEmpty() :

		if not sPath.endsWith( ".txt" , QtCore.Qt.CaseInsensitive ) :
			sPath += ".txt"

		# Read list file
		fList = QtCore.QFile( sPath )

		# Determine filename
		sName = fList.fileName().section( Settings.Path.sSep , -1 , -1 )
		sName = sName.left( sName.lastIndexOf( '.' ) )

		# Test existence
		if not fList.exists() :
			# Messages
			Display.slMessage( Settings.Message.iError , "Can't review the '" + sName + "' output" )
		else :
			Help.slUOpen( QtCore.QUrl( "file:" + sPath ) )


# About
def slAbout() :

	slMessage( Settings.Message.iInformation , "\n- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n" )

	# Message
	slMessage( Settings.Message.iInformation , Settings.Application.sAbout1 )


# Variables
def slVariables() :

	# Message
	slMessage( Settings.Message.iInformation, "OS = " + Settings.sOS )

	slMessage( Settings.Message.iInformation, "KDE Version = " + Settings.Env.sKDESV )
	slMessage( Settings.Message.iInformation, "KDE Config = " + Settings.Path.KDE.sConfig )
	slMessage( Settings.Message.iInformation, "KDE Prefix = " + Settings.Path.KDE.sPrefix )
	slMessage( Settings.Message.iInformation, "KDE Local Prefix = " + Settings.Path.KDE.sLocalPrefix )
	slMessage( Settings.Message.iInformation, "Sys Prefix = " + Settings.Path.Sys.sPrefix )
	slMessage( Settings.Message.iInformation, "Sys SBin = " + Settings.Path.Sys.sSBin )
	slMessage( Settings.Message.iInformation, "Sys Bin = " + Settings.Path.Sys.sBin )

	slMessage( Settings.Message.iInformation, "Local Prefix = " + Settings.Path.Local.sPrefix )
	slMessage( Settings.Message.iInformation, "Local SBin = " + Settings.Path.Local.sSBin )
	slMessage( Settings.Message.iInformation, "Local Bin = " + Settings.Path.Local.sBin )

	slMessage( Settings.Message.iInformation, Settings.Application.sName + " Prefix = " + Settings.Path.App.sPrefix )
	slMessage( Settings.Message.iInformation, Settings.Application.sName + " Config = " + Settings.Path.App.sConfig )

	slMessage( Settings.Message.iInformation, "Proxy = " + Settings.Path.Proxy.user() + " : " + Settings.Path.Proxy.password() + " @ " + Settings.Path.Proxy.hostName() + " : " + str( Settings.Path.Proxy.port() ) + "\n" )


# Message
def slMessage( iType , sMessage ) :

	sDate = Settings.Env.sDate
	sMessage = QtCore.QString( sMessage ).replace( "<br>" , "\n" )

	if Import.Init.bVerbose :

		fOutput = QtCore.QFile( Settings.Path.App.sConfig + "/Output/" + sDate + ".txt" )

		if fOutput.open( QtCore.QIODevice.Append | QtCore.QIODevice.Text ) :

			# Prepare text stream
			tsOutput = QtCore.QTextStream( fOutput )

			if iType == Settings.Message.iClear :
				tsOutput << "\n"
			elif iType == Settings.Message.iStatus :
				tsOutput << "Status: " + sMessage + "\n"
			elif iType == Settings.Message.iInformation :
				tsOutput << sMessage + "\n"
			elif iType == Settings.Message.iError :
				tsOutput << "Error: " + sMessage + "\n"
				if Import.Init.bInvisible :
					Display.slQuit()
			elif iType == Settings.Message.iQuestion :
				tsOutput << "Question: " + sMessage + "\n"

			fOutput.close()


# Binaries
def slChooseBinary( sTask , sFallback ) :

	# Open file
	fTask = QtCore.QFile( Settings.Path.App.sPrefix + Settings.Path.App.sInstall + "/Options/" + sTask + ".txt" )

	# Initialise
	bFound 		= False
	sCommand		= QtCore.QString()
	sArgs			= QtCore.QString()
	sFallback	= QtCore.QString( sFallback )

	if not fTask.open( QtCore.QIODevice.ReadOnly | QtCore.QIODevice.Text ) :

		# Messages
		Display.slMessage( Settings.Message.iError , "Can't load the " + sTask + " options file." )

	else :

		# Prepare text stream
		tsTask = QtCore.QTextStream( fTask )

		while not tsTask.atEnd() :
			sLine = QtCore.QString( tsTask.readLine() )

			# Relevant data?
			if not sLine.isEmpty() and not sLine.startsWith( '#' ) :

				pShell = Popen( ["which", str( sLine.section( ' ', 0, 0 ) )], stdout=PIPE, stderr=PIPE )
				if not QtCore.QString( pShell.communicate()[0] ).isEmpty() :
					bFound = True
					sCommand	= sLine.section( ' ', 0, 0 )
					sArgs		= sLine.section( ' ', 1 )
					slMessage( Settings.Message.iInformation, "For the " + sTask + " task, the chosen command is: " + sLine )
					break
				else :
					slMessage( Settings.Message.iInformation, "For the " + sTask + " task, an absent command is: " + sLine )

		fTask.close()

	"""
	# Fallback
	if not bFound and not sFallback.isEmpty() :

		pShell = Popen( ["which", str(sFallback.section( ' ', 0, 0 ) )], stdout=PIPE, stderr=PIPE )
		if not QtCore.QString( pShell.communicate()[0] ).isEmpty() :
			bFound = True
			sCommand	= QtCore.QString( Settings.Exec.Terminal.sCommand )
			sArgs		= QtCore.QString( Settings.Exec.Terminal.sArgs + " " + sFallback )
			slMessage( Settings.Message.iInformation, "For the " + sTask + " task, the chosen fallback command is: " + sFallback )
		else :
			slMessage( Settings.Message.iInformation, "For the " + sTask + " task, an absent fallback command is: " + sFallback )
	"""

	return sCommand, sArgs


# Test directory
def slTestDir( sDir ) :

	dPath = QtCore.QDir( Settings.Path.App.sConfig + "/" + sDir + "/" )

	# Create profile directory
	if not dPath.exists() :
		dPath.mkpath( dPath.path() )

# Test directories
def slTestDirs() :

	slTestDir( "Lists" )
	slTestDir( "Output" )
	slTestDir( "Profiles" )

# Test profile
def slTestProfile( sName ) :

	if not QtCore.QFile.exists( Settings.Path.App.sConfig + "/Profiles/" + sName + ".txt" ) :
		Profile.slReset( sName )

# Test profiles
def slTestProfiles() :

	slTestProfile( "Default" )
	slTestProfile( "Flash" )
	slTestProfile( "Local" )
	slTestProfile( "Remote" )
	slTestProfile( "Secure" )
	slTestProfile( "Storage" )
