"""
File:		Event.py
Purpose:	Event handler
"""


### Imports

# App 1
import	Import

# Python
try :
	import	sys
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore
except :
	Import.slException( "PyQt4" )

# App 2
import	Display, File, Help, List, Main, Profile, Settings, Thread


### Slots

def slConnections():

	# Visible?
	if not Import.Init.bInvisible :

		# Actions
		Main.uiMain.aACreate.connect( Main.uiMain.aACreate, QtCore.SIGNAL( "triggered()" ), Thread.slCreate )
		Main.uiMain.aAExtract.connect( Main.uiMain.aAExtract, QtCore.SIGNAL( "triggered()" ), Thread.slExtract )
		Main.uiMain.aAStop.connect( Main.uiMain.aAStop, QtCore.SIGNAL( "triggered()" ), Thread.slArcStop )
		Main.uiMain.aAReview.connect( Main.uiMain.aAReview, QtCore.SIGNAL( "triggered()" ), File.slReview )
		Main.uiMain.aAQuit.connect( Main.uiMain.aAQuit, QtCore.SIGNAL( "triggered()" ), Display.slQuit )

		# Profiles
		Main.uiMain.aLOther.connect( Main.uiMain.aLOther, QtCore.SIGNAL( "triggered()" ), Profile.slLoadOther )
		Main.uiMain.aLDefault.connect( Main.uiMain.aLDefault, QtCore.SIGNAL( "triggered()" ), Profile.slLoadDefault )
		Main.uiMain.aLFlash.connect( Main.uiMain.aLFlash, QtCore.SIGNAL( "triggered()" ), Profile.slLoadFlash )
		Main.uiMain.aLLocal.connect( Main.uiMain.aLLocal, QtCore.SIGNAL( "triggered()" ), Profile.slLoadLocal )
		Main.uiMain.aLRemote.connect( Main.uiMain.aLRemote, QtCore.SIGNAL( "triggered()" ), Profile.slLoadRemote )
		Main.uiMain.aLSecure.connect( Main.uiMain.aLSecure, QtCore.SIGNAL( "triggered()" ), Profile.slLoadSecure )
		Main.uiMain.aLStorage.connect( Main.uiMain.aLStorage, QtCore.SIGNAL( "triggered()" ), Profile.slLoadStorage )
		Main.uiMain.aSOther.connect( Main.uiMain.aSOther, QtCore.SIGNAL( "triggered()" ), Profile.slSaveOther )
		Main.uiMain.aSDefault.connect( Main.uiMain.aSDefault, QtCore.SIGNAL( "triggered()" ), Profile.slSaveDefault )
		Main.uiMain.aSFlash.connect( Main.uiMain.aSFlash, QtCore.SIGNAL( "triggered()" ), Profile.slSaveFlash )
		Main.uiMain.aSLocal.connect( Main.uiMain.aSLocal, QtCore.SIGNAL( "triggered()" ), Profile.slSaveLocal )
		Main.uiMain.aSRemote.connect( Main.uiMain.aSRemote, QtCore.SIGNAL( "triggered()" ), Profile.slSaveRemote )
		Main.uiMain.aSSecure.connect( Main.uiMain.aSSecure, QtCore.SIGNAL( "triggered()" ), Profile.slSaveSecure )
		Main.uiMain.aSStorage.connect( Main.uiMain.aSStorage, QtCore.SIGNAL( "triggered()" ), Profile.slSaveStorage )
		Main.uiMain.aRDefault.connect( Main.uiMain.aRDefault, QtCore.SIGNAL( "triggered()" ), Profile.slResetDefault )
		Main.uiMain.aRFlash.connect( Main.uiMain.aRFlash, QtCore.SIGNAL( "triggered()" ), Profile.slResetFlash )
		Main.uiMain.aRLocal.connect( Main.uiMain.aRLocal, QtCore.SIGNAL( "triggered()" ), Profile.slResetLocal )
		Main.uiMain.aRRemote.connect( Main.uiMain.aRRemote, QtCore.SIGNAL( "triggered()" ), Profile.slResetRemote )
		Main.uiMain.aRSecure.connect( Main.uiMain.aRSecure, QtCore.SIGNAL( "triggered()" ), Profile.slResetSecure )
		Main.uiMain.aRStorage.connect( Main.uiMain.aRStorage, QtCore.SIGNAL( "triggered()" ), Profile.slResetStorage )

		# Lists
		Main.uiMain.aLLoad.connect( Main.uiMain.aLLoad, QtCore.SIGNAL( "triggered()" ), List.slLoadOther )
		Main.uiMain.aLEdit.connect( Main.uiMain.aLEdit, QtCore.SIGNAL( "triggered()" ), List.slEditOther )
		Main.uiMain.aLSave.connect( Main.uiMain.aLSave, QtCore.SIGNAL( "triggered()" ), List.slSaveOther )

		# Option
		Main.uiMain.aVerbose.connect( Main.uiMain.aVerbose, QtCore.SIGNAL( "triggered()" ), Settings.slVerbose )
		Main.uiMain.aSettings.connect( Main.uiMain.aSettings, QtCore.SIGNAL( "triggered()" ), Settings.slDialog )

		# About
		Main.uiMain.aAQ7Z.connect( Main.uiMain.aAQ7Z, QtCore.SIGNAL( "triggered()" ), Help.slAboutQ7Z )
		Main.uiMain.aAQt4.connect( Main.uiMain.aAQt4, QtCore.SIGNAL( "triggered()" ), Help.slAboutQt4 )

		# URLs
		Main.uiMain.aUQ7Z.connect( Main.uiMain.aUQ7Z, QtCore.SIGNAL( "triggered()" ), Help.slUQ7Z )
		Main.uiMain.aUP7Zip.connect( Main.uiMain.aUP7Zip, QtCore.SIGNAL( "triggered()" ), Help.slUP7Zip )
		Main.uiMain.aUMake.connect( Main.uiMain.aUMake, QtCore.SIGNAL( "triggered()" ), Help.slUMake )
		Main.uiMain.aUQt4.connect( Main.uiMain.aUQt4, QtCore.SIGNAL( "triggered()" ), Help.slUQt4 )
		Main.uiMain.aUTar.connect( Main.uiMain.aUTar, QtCore.SIGNAL( "triggered()" ), Help.slUTar )
		Main.uiMain.aUPyQt4.connect( Main.uiMain.aUPyQt4, QtCore.SIGNAL( "triggered()" ), Help.slUPyQt4 )
		Main.uiMain.aUPython.connect( Main.uiMain.aUPython, QtCore.SIGNAL( "triggered()" ), Help.slUPython )
		Main.uiMain.aUCheckInstall.connect( Main.uiMain.aUCheckInstall, QtCore.SIGNAL( "triggered()" ), Help.slUCheckInstall )
		Main.uiMain.aUAutoPackage.connect( Main.uiMain.aUAutoPackage, QtCore.SIGNAL( "triggered()" ), Help.slUAutoPackage )
		Main.uiMain.aUEric.connect( Main.uiMain.aUEric, QtCore.SIGNAL( "triggered()" ), Help.slUEric )

		# Update
		Main.uiMain.aUpdate.connect( Main.uiMain.aUpdate, QtCore.SIGNAL( "triggered()" ), Help.slUBegin )

		# Feedback
		Main.uiMain.aFBGood.connect( Main.uiMain.aFBGood, QtCore.SIGNAL( "triggered()" ), Help.slFBGood )
		Main.uiMain.aFBBad.connect( Main.uiMain.aFBBad, QtCore.SIGNAL( "triggered()" ), Help.slFBBad )
		Main.uiMain.aFBIdea.connect( Main.uiMain.aFBIdea, QtCore.SIGNAL( "triggered()" ), Help.slFBIdea )

		# Documents
		Main.uiMain.aDoc.connect( Main.uiMain.aDoc, QtCore.SIGNAL( "triggered()" ), Help.slDoc )
		#Main.uiMain.aDChanges.connect( Main.uiMain.aDChanges, QtCore.SIGNAL( "triggered()" ), Help.slDocChanges )

		# Toggles
		Main.uiMain.gbCDestination.connect( Main.uiMain.gbCDestination, QtCore.SIGNAL( "toggled(bool)" ), Display.slToggles )
		Main.uiMain.gbEDestination.connect( Main.uiMain.gbEDestination, QtCore.SIGNAL( "toggled(bool)" ), Display.slToggles )
		Main.uiMain.cbSeparate.connect( Main.uiMain.cbSeparate, QtCore.SIGNAL( "stateChanged(int)" ), Display.slToggles )

		# Push Buttons
		Main.uiMain.pbCreate.connect( Main.uiMain.pbCreate, QtCore.SIGNAL( "clicked()" ), Thread.slCreate )
		Main.uiMain.pbExtract.connect( Main.uiMain.pbExtract, QtCore.SIGNAL( "clicked()" ), Thread.slExtract )
		Main.uiMain.pbStop.connect( Main.uiMain.pbStop, QtCore.SIGNAL( "clicked()" ), Thread.slArcStop )

		Main.uiMain.pbSDir.connect( Main.uiMain.pbSDir, QtCore.SIGNAL( "clicked()" ), Display.slCGetSDir )
		Main.uiMain.pbSArc.connect( Main.uiMain.pbSArc, QtCore.SIGNAL( "clicked()" ), Display.slEGetSArc )
		Main.uiMain.pbCDDir.connect( Main.uiMain.pbCDDir, QtCore.SIGNAL( "clicked()" ), Display.slCGetDDir )
		Main.uiMain.pbEDDir.connect( Main.uiMain.pbEDDir, QtCore.SIGNAL( "clicked()" ), Display.slEGetDDir )

		Main.uiSettings.pbAccept.connect( Main.uiSettings.pbAccept, QtCore.SIGNAL( "clicked()" ), Settings.slAccept )

		# Misc
		Main.uiMain.twOperations.connect( Main.uiMain.twOperations, QtCore.SIGNAL( "currentChanged(int)" ), Display.slTabPage )

	# Processes
	Thread.tiCreate.connect( Thread.tiCreate, QtCore.SIGNAL( "done(int)" ), Thread.slArcDone )
	Thread.tiCreate.connect( Thread.tiCreate, QtCore.SIGNAL( "error(QString)" ), Thread.slError )
	Thread.tiCreate.connect( Thread.tiCreate, QtCore.SIGNAL( "operation(int)" ), Display.slOperation )
	Thread.tiExtract.connect( Thread.tiExtract, QtCore.SIGNAL( "done(int)" ), Thread.slArcDone )
	Thread.tiExtract.connect( Thread.tiExtract, QtCore.SIGNAL( "error(QString)" ), Thread.slError )
	Thread.tiExtract.connect( Thread.tiExtract, QtCore.SIGNAL( "operation(int)" ), Display.slOperation )
