"""
File:		Display.py
Purpose:	Display handler
"""


### Imports

# App 1
import	Import

# Python
try :
	import	sys
except :
	Import.slException( "Python" )

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException( "PyQt4" )

# App 2
import	File, Help, Main, Settings
"""
try :
	from	Main_ui			import Ui_Main
	from	Main_rc			import *
	from	Settings_ui		import Ui_Settings
	from	Settings_rc		import *
except :
	Import.slException( Settings.Application.sName )
"""

### Slots

# Display init
def slInit() :

	# Visible?
	if not Import.Init.bInvisible :

		# Show the GUI?
		if not Settings.User.Geometry.bPosition :
			Main.mwMain.move( QtGui.QApplication.desktop().screen().rect().center() - Main.mwMain.rect().center() )

		slToggles()

		Main.mwMain.show()


# Choose the source creation directory
def slCGetSDir() :
	Main.uiMain.leSDir.setText( QtGui.QFileDialog.getExistingDirectory( None , "" , Main.uiMain.leSDir.displayText() ) )

# Choose the source extraction archive
def slEGetSArc() :
	dOutput = QtCore.QDir()
	dOutput.setPath( Main.uiMain.leArchive.displayText() )
	Main.uiMain.leArchive.setText( QtGui.QFileDialog.getOpenFileName( None , "" , dOutput.path() ,
		"Archives (*.exe *.7z *.bz2 *.zip *.rpm *.deb *.gz *.tar *.udf *.xar *.dmg *.hfs *.xz *.cab *.msi *.wim *.arj *.cpio *.rar *.chm *.iso *.lzh *.lha *.nsi *.z *.001)" ) )

# Choose the destination creation directory
def slCGetDDir() :
	Main.uiMain.leCDDir.setText( QtGui.QFileDialog.getExistingDirectory( None , "" , Main.uiMain.leCDDir.displayText() ) )

# Choose the destination extraction directory
def slEGetDDir() :
	Main.uiMain.leEDDir.setText( QtGui.QFileDialog.getExistingDirectory( None , "" , Main.uiMain.leEDDir.displayText() ) )


# Enable or disable items
def slToggles() :

	# Check boxes
	# Destinations
	if not Main.uiMain.gbCDestination.isChecked() :
		Main.uiMain.cbCName.setCheckState( QtCore.Qt.Unchecked )
		Main.uiMain.cbStructured.setCheckState( QtCore.Qt.Unchecked )
		Main.uiMain.cbSeparate.setCheckState( QtCore.Qt.Unchecked )
	# Separate
	if Main.uiMain.cbSeparate.isChecked() :
		Main.uiMain.cbCName.setCheckState( QtCore.Qt.Unchecked )
		Main.uiMain.cbCTest.setCheckState( QtCore.Qt.Unchecked )
	if not Main.uiMain.gbEDestination.isChecked() :
		Main.uiMain.cbEName.setCheckState( QtCore.Qt.Unchecked )
		Main.uiMain.cbBeneath.setCheckState( QtCore.Qt.Unchecked )

	# Menus
	Main.uiMain.aVerbose.setChecked( Import.Init.bVerbose )
	Main.uiMain.aAReview.setEnabled( Import.Init.bVerbose )


# GUI Profile Get Create
def slGuiProfileGetCreate( oPI ) :

	# Source
	oPI.Source.slFiles.clear()
	if not Import.Init.bInvisible and Settings.Input.iNumArgs < 3 :
		if not Main.uiMain.leSDir.displayText().isEmpty() :
			oPI.Source.slFiles.append( Main.uiMain.leSDir.displayText() )
	else :
		oPI.Source.slFiles << Settings.List.slFiles
	oPI.Source.iNext		= 0

	# Misc
	oPI.bTest				= False
	oPI.bSuccess			= True
	oPI.iProgress			= 0

	# Visible?
	if not Import.Init.bInvisible :

		# Type
		oPI.Type.sAlgorithm 	= Main.uiMain.cbAlgorithm.currentText()
		oPI.Type.sMethod		= Main.uiMain.cbMethod.currentText()
		oPI.Type.sComp			= Main.uiMain.cbComp.currentText()
		oPI.Type.sVolume		= Main.uiMain.cbVolume.currentText()
		oPI.Type.bSFX			= Main.uiMain.cbSFX.isChecked()
		oPI.Type.bSolid			= Main.uiMain.cbSolid.isChecked()

		# Security
		oPI.Security.bScramble	= Main.uiMain.cbScramble.isChecked()
		oPI.Security.bPassword	= Main.uiMain.cbCPassword.isChecked()
		oPI.Security.sPassword	= Main.uiMain.leCPassword.displayText()

		# Destination
		oPI.Dest.bDest			= Main.uiMain.gbCDestination.isChecked()
		oPI.Dest.bStructured	= Main.uiMain.cbStructured.isChecked()
		oPI.Dest.bSeparate	= Main.uiMain.cbSeparate.isChecked()
		oPI.Dest.sDir			= Main.uiMain.leCDDir.displayText()
		oPI.Dest.bName			= Main.uiMain.cbCName.isChecked()
		oPI.Dest.sName			= Main.uiMain.leCName.displayText()
		oPI.Dest.bBeneath		= False

		# Misc
		oPI.Misc.bSwitches	= Main.uiMain.cbCSwitches.isChecked()
		oPI.Misc.sSwitches	= Main.uiMain.leCSwitches.displayText()
		oPI.bTest				= Main.uiMain.cbCTest.isChecked()


# GUI Profile Set Create
def slGuiProfileSetCreate( oPI ) :

	# Visible?
	if not Import.Init.bInvisible :

		# Type
		Main.uiMain.cbAlgorithm.setCurrentIndex( Main.uiMain.cbAlgorithm.findText( oPI.Type.sAlgorithm ) )
		Main.uiMain.cbMethod.setCurrentIndex( Main.uiMain.cbMethod.findText( oPI.Type.sMethod ) )
		Main.uiMain.cbComp.setCurrentIndex( Main.uiMain.cbComp.findText( oPI.Type.sComp ) )
		Main.uiMain.cbVolume.setCurrentIndex( Main.uiMain.cbVolume.findText( oPI.Type.sVolume ) )
		if not oPI.Type.bSFX :
			Main.uiMain.cbSFX.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbSFX.setCheckState( QtCore.Qt.Checked )
		if not oPI.Type.bSolid :
			Main.uiMain.cbSolid.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbSolid.setCheckState( QtCore.Qt.Checked )
		# Security
		if not oPI.Security.bScramble :
			Main.uiMain.cbScramble.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbScramble.setCheckState( QtCore.Qt.Checked )
		if not oPI.Security.bPassword :
			Main.uiMain.cbCPassword.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbCPassword.setCheckState( QtCore.Qt.Checked )
		# Destination
		if not oPI.Dest.bDest :
			Main.uiMain.gbCDestination.setChecked( False )
		else :
			Main.uiMain.gbCDestination.setChecked( True )
		if not oPI.Dest.bStructured :
			Main.uiMain.cbStructured.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbStructured.setCheckState( QtCore.Qt.Checked )
		if not oPI.Dest.bSeparate :
			Main.uiMain.cbSeparate.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbSeparate.setCheckState( QtCore.Qt.Checked )
		Main.uiMain.leCDDir.setText( oPI.Dest.sDir )
		if not oPI.Dest.bName :
			Main.uiMain.cbCName.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbCName.setCheckState( QtCore.Qt.Checked )
		# Misc
		if not oPI.Misc.bSwitches :
			Main.uiMain.cbCSwitches.setCheckState( QtCore.Qt.Unchecked )
		else :
			Main.uiMain.cbCSwitches.setCheckState( QtCore.Qt.Checked )
		Main.uiMain.leCSwitches.setText( oPI.Misc.sSwitches )

# GUI Profile Get Extract
def slGuiProfileGetExtract( oPI ) :

	# Source operation
	if oPI.iSource == Settings.Operation.iCreate :

		# Security
		oPI.Security.bPassword	= Main.uiMain.cbCPassword.isChecked()
		oPI.Security.sPassword	= Main.uiMain.leCPassword.displayText()

	else :

		# Source
		oPI.Source.slFiles.clear()
		if not Import.Init.bInvisible and Settings.Input.iNumArgs < 3 :
			#if not Main.uiMain.leArchive.displayText().isEmpty() :
			oPI.Source.slFiles.append( Main.uiMain.leArchive.displayText() )
		else :
			oPI.Source.slFiles << Settings.List.slFiles
		oPI.Source.iNext		= 0

		# Destination
		oPI.Dest.bBeneath		= False

		# Misc
		oPI.bTest				= False
		oPI.bSuccess			= True
		oPI.iProgress			= 0

		# Visible?
		if not Import.Init.bInvisible :

			# Security
			oPI.Security.bPassword	= Main.uiMain.cbEPassword.isChecked()
			oPI.Security.sPassword	= Main.uiMain.leEPassword.displayText()

			# Destination
			oPI.Dest.bDest			= Main.uiMain.gbEDestination.isChecked()
			oPI.Dest.bBeneath		= Main.uiMain.cbBeneath.isChecked()
			oPI.Dest.sDir			= Main.uiMain.leEDDir.displayText()
			oPI.Dest.bName			= Main.uiMain.cbEName.isChecked()
			oPI.Dest.sName			= Main.uiMain.leEName.displayText()

			# Misc
			oPI.bTest				= Main.uiMain.cbETest.isChecked()


# Progress
def slProgress( iRetVal ) :

	# Visible?
	if not Import.Init.bInvisible :

		# Update
		Main.uiMain.pbComplete.setValue( iRetVal )

# Enable GUI
def slEnableGUI() :

	# Visible?
	if not Import.Init.bInvisible :

		Main.uiMain.aAStop.setEnabled( False )
		Main.uiMain.pbStop.setEnabled( False )
		Main.uiMain.pbComplete.setEnabled( False )
		Main.uiMain.twOperations.setEnabled( True )

		slTabPage()

		slMessage( Settings.Message.iClear , "" )

# Disable GUI
def slDisableGUI() :

	# Visible?
	if not Import.Init.bInvisible :

		# Reset or disable items
		Main.uiMain.twOperations.setEnabled( False )
		Main.uiMain.aAStop.setEnabled( True )
		Main.uiMain.pbComplete.setEnabled( True )
		Main.uiMain.pbStop.setEnabled( True )
		Main.uiMain.pbComplete.setValue( 0 )
		Main.uiMain.aACreate.setEnabled( False )
		Main.uiMain.aAExtract.setEnabled( False )

# External files
def slGUIExternal( iOperation ) :

	# Visible?
	if not Import.Init.bInvisible :

		# Create
		Main.uiMain.leSDir.setText( "External File(s)" )
		Main.uiMain.leSDir.setEnabled( False )
		Main.uiMain.pbSDir.setEnabled( False )

		# Extract
		Main.uiMain.leArchive.setText( "External File(s)" )
		Main.uiMain.leArchive.setEnabled( False )
		Main.uiMain.pbSArc.setEnabled( False )

		# FIXME: These lines are minor hacks
		Settings.Input.iNumArgs = 3

		# Operation
		if iOperation == Settings.Operation.iCreate :
			Main.uiMain.twOperations.setCurrentIndex( 0 )
			Main.uiMain.twOperations.setTabEnabled( 1 , False )
		elif iOperation == Settings.Operation.iExtract :
			Main.uiMain.twOperations.setCurrentIndex( 1 )
			Main.uiMain.twOperations.setTabEnabled( 0 , False )
		elif iOperation == Settings.Operation.iTest :
			Main.uiMain.twOperations.setCurrentIndex( 1 )
			Main.uiMain.twOperations.setTabEnabled( 0 , False )
			Main.uiMain.cbETest.setChecked( True )

		slTabPage()

# Beneath
def slGUIBeneath() :

	# Visible?
	if not Import.Init.bInvisible :
		Main.uiMain.gbEDestination.setChecked( True )
		Main.uiMain.cbBeneath.setCheckState( QtCore.Qt.Checked )

# TabPage
def slTabPage() :

	# Which tab is active?
	if Main.uiMain.twOperations.currentWidget() == Main.uiMain.tCreate :

		# Menus
		Main.uiMain.mProfile.setEnabled( True )
		Main.uiMain.mList.setEnabled( True )

		# Menu entries
		Main.uiMain.aACreate.setEnabled( True )
		Main.uiMain.aAExtract.setEnabled( False )

		# Buttons
		Main.uiMain.pbCreate.setDefault( True )

	if Main.uiMain.twOperations.currentWidget() == Main.uiMain.tExtract :

		# Menus
		Main.uiMain.mProfile.setEnabled( False )
		Main.uiMain.mList.setEnabled( False )

		# Menu entries
		Main.uiMain.aACreate.setEnabled( False )
		Main.uiMain.aAExtract.setEnabled( True )

		# Buttons
		Main.uiMain.pbExtract.setDefault( True )

# Operation
def slOperation( iOperation ) :

	# Messages
	if iOperation == Settings.Operation.iCreate :
		slMessage( Settings.Message.iTitle , "Creating ..." )
		slMessage( Settings.Message.iStatus , "Creating the archive(s) ..." )
	elif iOperation == Settings.Operation.iExtract :
		slMessage( Settings.Message.iTitle , "Extracting ..." )
		slMessage( Settings.Message.iStatus , "Extracting the archive(s) ..." )
	elif iOperation == Settings.Operation.iTest :
		slMessage( Settings.Message.iTitle , "Testing ..." )
		slMessage( Settings.Message.iStatus , "Testing the archive(s) ..." )


# Message
def slMessage( iType , sMessage ) :

	bResult = False

	# Visible?
	if not Import.Init.bInvisible :

		bResult = QtGui.QMessageBox.Ok

		# Clear
		if iType == Settings.Message.iClear :
			Main.mwMain.setWindowTitle( Settings.Application.sName )
			Main.uiMain.sbMain.clearMessage()
		# Title bar
		elif iType == Settings.Message.iTitle :
			Main.mwMain.setWindowTitle( Settings.Application.sName + " - " + sMessage )
		# Status bar
		elif iType == Settings.Message.iStatus :
			Main.uiMain.sbMain.showMessage( sMessage )
		# Tray icon tip
		elif iType == Settings.Message.iTrayTip :
			Main.stiMain.setToolTip( Settings.Application.sName + " - " + sMessage )

		# Dialog?
		if sMessage != "" and Main.mwMain.isVisible() :
			# Information
			if iType == Settings.Message.iInformation :
				QtGui.QMessageBox.information( Main.uiMain.cwMain, Settings.Application.sName + " - Information", sMessage, QtGui.QMessageBox.Ok )
			# Error
			elif iType == Settings.Message.iError :
				QtGui.QErrorMessage.showMessage( QtGui.QErrorMessage.qtHandler() , "Error:<br>" + sMessage )
			# Question
			elif iType == Settings.Message.iQuestion :
				bResult = QtGui.QMessageBox.question( Main.uiMain.cwMain, Settings.Application.sName + " - Question", sMessage, QtGui.QMessageBox.Yes | QtGui.QMessageBox.No )
		"""
		else :
			# Tray icon message
			if iType == Settings.Message.iTray and QtGui.QSystemTrayIcon.supportsMessages() :
				Main.stiMain.showMessage( Settings.Application.sName , sMessage , \
										 QtGui.QSystemTrayIcon.Information , Settings.Timer.Control.iLaunched )
		"""

	else :

		sMessage = QtCore.QString( sMessage ).replace( "<br>" , "\n" )

		if sMessage != "" :
			# Error
			if iType == Settings.Message.iError :
				print "Error: " + sMessage

	File.slMessage( iType , sMessage )

	return bResult


# No binaries
def slNoBin( sApp , sWebsite ) :

	# Launch website
	if not sWebsite.isEmpty() :
		Help.slUOpen( QtCore.QUrl( sWebsite ) )

	# Message
	sMessage = "The required " + sApp + " executable file can't be found.  " \
						"Download and install it, then restart " + Settings.Application.sName + "."
	slMessage( Settings.Message.iError, sMessage )


# Quit
def slQuit() :

	# Visible?
	if not Import.Init.bInvisible :

		# Save
		Settings.slSave()

		# Close main window
		Main.mwMain.close()

	else :

		# Exit
		sys.exit()
