'''OpenGL extension EXT.blend_minmax

Overview (from the spec)
	
	Blending capability is extended by respecifying the entire blend
	equation.  While this document defines only two new equations, the
	BlendEquationEXT procedure that it defines will be used by subsequent
	extensions to define additional blending equations.
	
	The two new equations defined by this extension produce the minimum
	(or maximum) color components of the source and destination colors.
	Taking the maximum is useful for applications such as maximum projection
	in medical imaging.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/blend_minmax.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_FUNC_ADD_EXT = constant.Constant( 'GL_FUNC_ADD_EXT', 0x8006 )
GL_MIN_EXT = constant.Constant( 'GL_MIN_EXT', 0x8007 )
GL_MAX_EXT = constant.Constant( 'GL_MAX_EXT', 0x8008 )
GL_BLEND_EQUATION_EXT = constant.Constant( 'GL_BLEND_EQUATION_EXT', 0x8009 )
glget.addGLGetConstant( GL_BLEND_EQUATION_EXT, (1,) )
glBlendEquationEXT = platform.createExtensionFunction( 
	'glBlendEquationEXT', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum,),
	doc = 'glBlendEquationEXT( GLenum(mode) ) -> None',
	argNames = ('mode',),
)


def glInitBlendMinmaxEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_EXT_blend_minmax' )
