/* 
 * $Id: shellux.c,v 1.4 2003/02/16 12:42:14 isizaka Exp isizaka $
 * 
 * This file is part of "Ngraph for X11".
 * 
 * Copyright (C) 2002, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for X11" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for X11" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/**
 *
 * $Log: shellux.c,v $
 * Revision 1.4  2003/02/16 12:42:14  isizaka
 * for release 6.13.18
 *
 * Revision 1.3  2002/07/06 08:51:42  isizaka
 * change to GPL.
 *
 * Revision 1.2  1999/04/11 06:08:10  isizaka
 * *** empty log message ***
 *
 * Revision 1.1  1999/03/17 13:46:09  isizaka
 * Initial revision
 *
 *
 **/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef WINDOWS
#include <unistd.h>
#include <signal.h>
#include <time.h>
#else
#include <windows.h>
#include <dos.h>
#endif
#include "ngraph.h"
#include "nstring.h"
#include "object.h"
#include "ioutil.h"
#include "shell.h"
#include "shellux.h"

#define TRUE  1
#define FALSE 0

int cmtrue(struct nshell *nshell,int argc,char **argv)
{
  return 0;
}

int cmfalse(struct nshell *nshell,int argc,char **argv)
{
  return 1;
}

#ifndef WINDOWS

int timeout;

void cmsleeptimeout(int sig)
{
  signal(sig,SIG_IGN);
  timeout=TRUE;
  signal(SIGALRM,cmsleeptimeout);
}

int cmsleep(struct nshell *nshell,int argc,char **argv)
{
  int a;
  char *arg,*endptr;

  if (argc<2) {
    sherror4(argv[0],ERRSMLARG);
    return ERRSMLARG;
  }
  arg=argv[1];
  a=strtol(arg,&endptr,10);
  if (endptr[0]!='\0') {
    sherror3(argv[0],ERRNUMERIC,arg);
    return ERRNUMERIC;
  }
  timeout=FALSE;
  signal(SIGALRM,cmsleeptimeout);
  alarm(a);
  while (!timeout) eventloop();
  alarm(0);
  return 0;
}

#else

typedef struct {
  int Sleep;
  int Second;
} ThreadParam;

DWORD WINAPI SleepThread(LPVOID lpvThreadParam)
{
  ThreadParam *pTH;

  pTH=(ThreadParam *)lpvThreadParam;
  sleep(pTH->Second);
  pTH->Sleep=FALSE;
  return 0;
}

int cmsleep(struct nshell *nshell,int argc,char **argv)
{
  int a;
  char *arg,*endptr;
  ThreadParam TH;
  DWORD IDThread;

  if (argc<2) {
    sherror4(argv[0],ERRSMLARG);
    return ERRSMLARG;
  }
  arg=argv[1];
  a=strtol(arg,&endptr,10);
  if (endptr[0]!='\0') {
    sherror3(argv[0],ERRNUMERIC,arg);
    return ERRNUMERIC;
  }
  TH.Sleep=TRUE;
  TH.Second=a;
  CreateThread(NULL,0,SleepThread,&TH,0,&IDThread);
  while (TH.Sleep) eventloop();
  return 0;
}

#endif

int testexpand(int pre,int *oppo,int *numpo,
               int numbuf[],char *numbufc[],char opbuf[],int prebuf[])
{
  int argnum;
  int d1,d2;
  char *endptr1,*endptr2;
  struct stat buf;

  while ((*oppo>=0) && (pre<=prebuf[*oppo])) {
    if (strchr("!nzdefrswx",opbuf[*oppo])!=NULL) argnum=1;
    else argnum=2;
    switch (opbuf[*oppo]) {
    case 'n':
      if (numbufc[*numpo]==NULL) return FALSE;
      numbuf[*numpo]=(numbufc[*numpo][0]=='\0')?FALSE:TRUE;
      numbufc[*numpo]=NULL;
      break;
    case 'z':
      if (numbufc[*numpo]==NULL) return FALSE;
      numbuf[*numpo]=(numbufc[*numpo][0]=='\0')?TRUE:FALSE;
      numbufc[*numpo]=NULL;
      break;
    case 'd':
    case 'f':
    case 'e':
    case 'r':
    case 'w':
    case 'x':
    case 's':
      if (numbufc[*numpo]==NULL) return FALSE;
      if (stat(numbufc[*numpo],&buf)!=0) {
        numbuf[*numpo]=FALSE;
        numbufc[*numpo]=NULL;
        break;
      }
      switch (opbuf[*oppo]) {
      case 'd':
        numbuf[*numpo]=((buf.st_mode & S_IFMT)==S_IFDIR)?TRUE:FALSE;
        break;
      case 'f':
        numbuf[*numpo]=((buf.st_mode & S_IFMT)==S_IFREG)?TRUE:FALSE;
        break;
      case 'e':
        numbuf[*numpo]=TRUE;
        break;
      case 'r':
        numbuf[*numpo]=((buf.st_mode & S_IREAD)!=0)?TRUE:FALSE;
        break;
      case 'w':
        numbuf[*numpo]=((buf.st_mode & S_IWRITE)!=0)?TRUE:FALSE;
        break;
      case 'x':
        numbuf[*numpo]=((buf.st_mode & S_IEXEC)!=0)?TRUE:FALSE;
        break;
      case 's':
        numbuf[*numpo]=(buf.st_size>0)?TRUE:FALSE;
        break;
      }
      numbufc[*numpo]=NULL;
      break;
    case '!':
      numbuf[*numpo]=(numbuf[*numpo])?FALSE:TRUE;
      numbufc[*numpo]=NULL;
      break;
    case 'o':
      numbuf[*numpo-1]=numbuf[*numpo-1] || numbuf[*numpo];
      numbufc[*numpo]=NULL;
      break;
    case 'a':
      numbuf[*numpo-1]=numbuf[*numpo-1] && numbuf[*numpo];
      numbufc[*numpo]=NULL;
      break;
    case '?':
    case '*':
    case '>':
    case '}':
    case '<':
    case '{':
      if ((numbufc[*numpo-1]==NULL) || (numbufc[*numpo]==NULL)) return FALSE;
      d1=strtol(numbufc[*numpo-1],&endptr1,10);
      d2=strtol(numbufc[*numpo],&endptr2,10);
      if ((endptr1[0]!='\0') || (endptr2[0]!='\0')) return FALSE;
      switch (opbuf[*oppo]) {
      case '?':
        numbuf[*numpo-1]=(d1==d2)?TRUE:FALSE;
        break;
      case '*':
        numbuf[*numpo-1]=(d1!=d2)?TRUE:FALSE;
        break;
      case '>':
        numbuf[*numpo-1]=(d1>d2)?TRUE:FALSE;
        break;
      case '}':
        numbuf[*numpo-1]=(d1>=d2)?TRUE:FALSE;
        break;
      case '<':
        numbuf[*numpo-1]=(d1<d2)?TRUE:FALSE;
        break;
      case '{':
        numbuf[*numpo-1]=(d1<=d2)?TRUE:FALSE;
        break;
      }
      numbufc[*numpo-1]=NULL;
      break;
    case '=':
      if ((numbufc[*numpo-1]==NULL) || (numbufc[*numpo]==NULL)) return FALSE;
      numbuf[*numpo-1]
      =(strcmp2(numbufc[*numpo-1],numbufc[*numpo])==0)?TRUE:FALSE;
      numbufc[*numpo-1]=NULL;
      break;
    case '+':
      if ((numbufc[*numpo-1]==NULL) || (numbufc[*numpo]==NULL)) return FALSE;
      numbuf[*numpo-1]
      =(strcmp2(numbufc[*numpo-1],numbufc[*numpo])==0)?FALSE:TRUE;
      numbufc[*numpo-1]=NULL;
      break;
    }
    (*numpo)+=-argnum+1;
    (*oppo)--;
  }
  return TRUE;
}

int cmtest(struct nshell *nshell,int argc,char **argv)
{
  int prebuf[20];
  int numbuf[20];
  char *numbufc[20];
  char opbuf[20];
  int oppo,numpo,numeric;
  int i;

  if (argc<2) return 0;
  numpo=-1;
  oppo=-1;
  numeric=FALSE;
  if (strcmp2(argv[argc-1],"]")==0) argc--;
  i=1;
  while (i<argc) {
    if (!numeric) {
      if ((strcmp2(argv[i],"!")==0) && ((i+1)<argc)) {
        if (!testexpand(4,&oppo,&numpo,numbuf,numbufc,opbuf,prebuf)) {
          sherror4(argv[0],ERRTESTSYNTAX);
          return 1;
        }
        oppo++;
        if (oppo>=20) {
          sherror4(argv[0],ERRTESTNEST);
          return 1;
        }
        opbuf[oppo]='!';
        prebuf[oppo]=4;
        i++;
      } else if (((strcmp2(argv[i],"-d")==0) || (strcmp2(argv[i],"-e")==0)
      || (strcmp2(argv[i],"-f")==0) || (strcmp2(argv[i],"-r")==0)
      || (strcmp2(argv[i],"-s")==0) || (strcmp2(argv[i],"-w")==0)
      || (strcmp2(argv[i],"-x")==0) || (strcmp2(argv[i],"-z")==0)
      || (strcmp2(argv[i],"-n")==0))
      && ((i+1)<argc)
      && (strcmp2(argv[i+1],"=")!=0) && (strcmp2(argv[i+1],"!=")!=0)) {
        if (!testexpand(6,&oppo,&numpo,numbuf,numbufc,opbuf,prebuf)) {
          sherror4(argv[0],ERRTESTSYNTAX);
          return 1;
        }
        oppo++;
        if (oppo>=20) {
          sherror4(argv[0],ERRTESTNEST);
          return 1;
        }
        opbuf[oppo]=argv[i][1];
        prebuf[oppo]=6;
        i++;
      } else if ((strcmp2(argv[i],"(")==0) && ((i+1)<argc)) {
        oppo++;
        if (oppo>=20) {
          sherror4(argv[0],ERRTESTNEST);
          return 1;
        }
        opbuf[oppo]='(';
        prebuf[oppo]=0;
        i++;
      } else {
        numpo++;
        if (numpo>=20) {
          sherror4(argv[0],ERRTESTNEST);
          return 1;
        }
        numbuf[numpo]=strlen(argv[i]);
        numbufc[numpo]=argv[i];
        numeric=TRUE;
        i++;
      }
    } else {
      if (((strcmp2(argv[i],"-eq")==0) || (strcmp2(argv[i],"-ne")==0)
      || (strcmp2(argv[i],"-gt")==0)  || (strcmp2(argv[i],"-ge")==0)
      || (strcmp2(argv[i],"-lt")==0)  || (strcmp2(argv[i],"-le")==0)
      || (strcmp2(argv[i],"=")==0)  || (strcmp2(argv[i],"!=")==0))
      && ((i+1)<argc)) {
        if (!testexpand(5,&oppo,&numpo,numbuf,numbufc,opbuf,prebuf)) {
          sherror4(argv[0],ERRTESTSYNTAX);
          return 1;
        }
        oppo++;
        if (oppo>=20) {
          sherror4(argv[0],ERRTESTNEST);
          return 1;
        }
        if (strcmp2(argv[i],"-eq")==0) opbuf[oppo]='?';
        else if (strcmp2(argv[i],"-ne")==0) opbuf[oppo]='*';
        else if (strcmp2(argv[i],"-gt")==0) opbuf[oppo]='>';
        else if (strcmp2(argv[i],"-ge")==0) opbuf[oppo]='}';
        else if (strcmp2(argv[i],"-lt")==0) opbuf[oppo]='<';
        else if (strcmp2(argv[i],"-le")==0) opbuf[oppo]='{';
        else if (strcmp2(argv[i],"=")==0) opbuf[oppo]='=';
        else if (strcmp2(argv[i],"!=")==0) opbuf[oppo]='+';
        prebuf[oppo]=5;
        numeric=FALSE;
        i++;
      } else if (strcmp2(argv[i],")")==0) {
        if (!testexpand(1,&oppo,&numpo,numbuf,numbufc,opbuf,prebuf)) {
          sherror4(argv[0],ERRTESTSYNTAX);
          return 1;
        }
        if ((oppo!=-1) && (opbuf[oppo]=='(')) oppo--;
        numeric=TRUE;
        i++;
      } else if ((strcmp2(argv[i],"-a")==0) && ((i+1)<argc)) {
        if (!testexpand(3,&oppo,&numpo,numbuf,numbufc,opbuf,prebuf)) {
          sherror4(argv[0],ERRTESTSYNTAX);
          return 1;
        }
        oppo++;
        if (oppo>=20) {
          sherror4(argv[0],ERRTESTNEST);
          return 1;
        }
        opbuf[oppo]=argv[i][1];
        prebuf[oppo]=3;
        numeric=FALSE;
        i++;
      } else if ((strcmp2(argv[i],"-o")==0) && ((i+1)<argc)) {
        if (!testexpand(2,&oppo,&numpo,numbuf,numbufc,opbuf,prebuf)) {
          sherror4(argv[0],ERRTESTSYNTAX);
          return 1;
        }
        oppo++;
        if (oppo>=20) {
          sherror4(argv[0],ERRTESTNEST);
          return 1;
        }
        opbuf[oppo]=argv[i][1];
        prebuf[oppo]=2;
        numeric=FALSE;
        i++;
      } else if (strcmp2(argv[i],"]")==0) {
        i++;
      } else {
        sherror4(argv[0],ERRTESTSYNTAX);
        return 1;
      }
    }
  }
  if (!numeric || !testexpand(1,&oppo,&numpo,numbuf,numbufc,opbuf,prebuf)) {
    sherror4(argv[0],ERRTESTSYNTAX);
    return 1;
  }
  if ((oppo>-1) || (numpo!=0)) {
    sherror4(argv[0],ERRTESTSYNTAX);
    return 1;
  }
  if (numbuf[0]) return 0;
  else return 1;
}
