/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

#ifndef VIEW_FILES_H
#define VIEW_FILES_H

//KDE
#include <kdialog.h>

//Ui
#include "ui_viewfiles.h"

/**
 * @brief KDialog showing all raw file input.
 *
 * Shows the contents of the 2 files that KGRUBEditor edits.
 * These are (by default) /boot/grub/menu.lst and /boot/grub/device.map.
 */
class ViewFiles : public KDialog, private Ui::ViewFiles
{
Q_OBJECT
public:
	/**
	* Sets up the GUI, changes the title of the tabs and shows the contents of the files.
	*
	* @param menulst The menulst filename (usually this is /boot/grub/menu.lst)
	* @param devicemap The devicemap filename (usually this is /boot/grub/device.map)
	* @param parent QWidget parent. Self explanatory.
	*/
	ViewFiles( const QString &menulst, const QString &devicemap, QWidget *parent = 0 );
};

#endif
