/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

//Own
#include "passworddialog.h"

//KDE
#include <klocale.h>

PasswordDialog::PasswordDialog( QWidget *parent ) : KPasswordDialog( parent ), m_suProcess( "root" )
{
	setCaption( i18nc( "@window:title", "Authorization Required" ) );

	if( m_suProcess.useUsersOwnPassword() )
		setPrompt( i18nc( "@info", "<para>Administrator privileges are required.</para><para>In order to procede, please enter your password.</para>" ) );
        else
		setPrompt( i18nc( "@info", "<para>Administrator privileges are required.</para><para>In order to procede, please enter the system administrator's password.</para>" ) );

	setPixmap( KIcon( "dialog-password" ).pixmap( KIconLoader::SizeHuge, KIconLoader::SizeHuge ) );
}

bool PasswordDialog::checkPassword()
{
	switch ( m_suProcess.checkInstall( password().toLocal8Bit() ) )
	{
		case -1:
			if ( m_suProcess.useUsersOwnPassword() )
				showErrorMessage( i18nc( "@info", "Insufficient privileges." ), UsernameError );
			else
				showErrorMessage( i18nc( "@info", "Conversation with su failed." ), UsernameError );
		return false;
		case 0:
		return true;
		case KDESu::SuProcess::SuNotFound:
			showErrorMessage( i18nc( "@info", "<para>Could not launch '%1'.</para><para>Make sure your PATH is set correctly.</para>", m_suProcess.useUsersOwnPassword() ? "sudo" : "su" ), FatalError);
		return false;
		case KDESu::SuProcess::SuNotAllowed:
			showErrorMessage( i18nc( "@info", "Insufficient privileges." ), FatalError );
		return false;
		case KDESu::SuProcess::SuIncorrectPassword:
			showErrorMessage( i18nc( "@info", "Incorrect password, please try again." ), PasswordError);
		return false;
		default:
			showErrorMessage( i18nc( "@info", "Internal error: illegal return from SuProcess::checkInstall()" ), FatalError);
			done( Rejected );
		return false;
	}
}
