/////////////////////////////////////////////////////////////////////////////
// Name:        DVDPropDlg.cpp
// Purpose:     DVD properties dialog
// Author:      Alex Thuering
// Created:     7.03.2005
// RCS-ID:      $Id: DVDPropDlg.cpp,v 1.19 2009/03/29 19:36:38 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "DVDPropDlg.h"
#include "Config.h"

DVDPropDlg::DVDPropDlg(wxWindow *parent, DVD* dvd) :
	wxPropDlg(parent), m_dvd(dvd) {
	Create(true);
	SetSize(400, -1);
}

void DVDPropDlg::CreatePropPanel(wxSizer* sizer) {

	wxFlexGridSizer* grid = sizer ? new wxFlexGridSizer(2, 1, 16) : NULL;
	if (grid) {
		grid->AddGrowableCol(1);
		sizer->Add(grid, 0, wxEXPAND|wxALL, 6);
	}
	AddTextProp(grid, _("Disc label:"), grid ? m_dvd->GetLabel() : s_config.GetDefDiscLabel());

	wxArrayString labels = DVD::GetCapacityLabels();
	AddChoiceProp(grid, _("Disc capacity:"), labels[m_dvd->GetCapacity()], labels);

	// Video bitrate
	labels = DVD::GetVideoBitrateLabels();
	int b = m_dvd->GetVideoBitrate();
	int q = m_dvd->IsVideoBitrateAuto() ? 0 : (b%1000 == 0 && b>=2000 && b<=8000 ? 9-b/1000 : 8);
	wxSizer* vbSizer = AddChoiceCustomProp(grid, _("Video quality:"), labels[q], labels, 8, 100, false);
	if (vbSizer)
		vbSizer->AddSpacer(4);
	AddSpinProp(vbSizer, wxT(""), b == -1 ? 4500 : b, 500, 9000, 80, _("KBit/s"), false);
	if (vbSizer)
		SetLastControlCustom(GetLastControlIndex()-1, q == 8);

	// Video and audio format
	wxFlexGridSizer* fSizer = sizer ? new wxFlexGridSizer(3, 1, 16) : NULL;
	if (sizer) {
		fSizer->AddGrowableCol(0);
		fSizer->AddGrowableCol(1);
		fSizer->AddGrowableCol(2);
		sizer->Add(fSizer, 0, wxEXPAND|wxALL, 6);
	}
	// Video format
	wxSizer* grp = BeginGroup(fSizer, _("Video Format"));
	if (grp)
		grp->Add(4, 4);
	wxArrayString formats = DVD::GetVideoFormatLabels();
	AddRadioGroupProp(grp, formats, m_dvd->GetVideoFormat() - 2);
	if (grp)
		grp->Add(4, 4);
	// Aspect Ratio
	formats = DVD::GetAspectRatioLabels();
	grp = BeginGroup(fSizer, _("Aspect Ratio"));
	if (grp)
		grp->Add(4, 4);
	AddRadioGroupProp(grp, formats, m_dvd->GetAspectRatio() - 1);
	if (grp->GetMinSize().GetWidth() < 100)
		grp->SetMinSize(wxSize(100, -1));
	if (grp)
		grp->Add(4, 4);
	// Audio format
	grp = BeginGroup(fSizer, _("Audio Format"));
	if (grp)
		grp->Add(4, 4);
	formats = DVD::GetAudioFormatLabels();
	AddRadioGroupProp(grp, formats, m_dvd->GetAudioFormat() - 2);
	if (grp)
		grp->Add(4, 4);
	
	grid = sizer ? new wxFlexGridSizer(2, 1, 16) : NULL;
	if (grid) {
		grid->AddGrowableCol(1);
		sizer->Add(grid, 0, wxEXPAND|wxALL, 6);
	}
	AddTextProp(grid, _("First Play Commands:"), m_dvd->GetVmgm().GetFpc());

	AddCheckProp(sizer, _("Create jumppads"), sizer ? m_dvd->IsJumppadsEnabled() : true);
	AddCheckProp(sizer, _("Create empty menu/vmMenu if it doesn't exist"),
			sizer ? m_dvd->IsEmptyMenuEnabled() : true);
}

bool DVDPropDlg::SetValues() {
	int n = 0;
	if (GetString(n).length() == 0) {
		wxMessageBox(_("Please enter the volume name."), this->GetTitle(), wxOK|wxICON_ERROR, this);
		return false;
	}
	if (GetString(n).length() > 32) {
		wxMessageBox(_("Volume name can only be a maximum of 32 characters."), this->GetTitle(),
				wxOK|wxICON_ERROR, this);
		return false;
	}
	m_dvd->SetLabel(GetString(n++));
	m_dvd->SetCapacity((DiscCapacity) GetInt(n++));
	int q = GetInt(n++);
	m_dvd->SetVideoBitrateAuto(q == 0);
	int b = GetInt(n++);
	if (q > 0)
		m_dvd->SetVideoBitrate(q < 8 ? (9-q)*1000 : b);
	m_dvd->SetVideoFormat((VideoFormat) (GetInt(n++) + 2));
	m_dvd->SetAspectRatio((AspectRatio) (GetInt(n++) + 1));
	m_dvd->SetAudioFormat((AudioFormat) (GetInt(n++) + 2));
	for (int tsi=-1; tsi<(int)m_dvd->GetTitlesets().GetCount(); tsi++) {
		PgcArray& pgcs = m_dvd->GetPgcArray(tsi, true);
		for (int pgci=0; pgci<(int)pgcs.GetCount(); pgci++) {
			Menu* menu = m_dvd->GetMenu(tsi, pgci);
			if (menu != NULL)
				menu->SetVideoFormat(m_dvd->GetVideoFormat());
		}
	}
	m_dvd->GetVmgm().SetFpc(GetString(n++));
	m_dvd->EnableJumppads(GetBool(n++));
	m_dvd->EnableEmptyMenu(GetBool(n++));
	return true;
}
