/***************************************************************************
                          settings_widg.cpp  -  description
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#include <QLabel>
#include <QHeaderView>
#include <KMenu>
#include <KAction>
#include <KMessageBox>
#include <KLocale>   //i18n
#include <KDirSelectDialog>

#include <QFileDialog>
//#include <QTableWidget>	//*.h
//#include <QTableWidgetItem>	//*.h

#include <QPixmap>

#include <QStringList>
#include <KIcon>
//#include <QCursor>
#include <QMouseEvent>
#include <QPoint>

#include <KDebug>	//ooo

#include "settings_widg.h"
#include "utils.h" //where is defined the FlagsID array

//#define DEBUG_1

//Settings_widg::Settings_widg( QWidget *parent ) :
Settings_widg::Settings_widg( QWidget *parent, QMouseEvent *event ) :	//ooo
	QWidget( parent )
{
	//Par1 = parent;   //ooo
	Par_mouseEvent = event;	//ooo
	prevItem = 0;	//ooo
	tableItemColor = QColor(0, 0, 255, 64);	//ooo

	Data = new QList<Dictionary>;
	//Data->setAutoDelete(true);

	//Box = new QVBoxLayout(this);
	mainLayout = new QVBoxLayout(this);

	topBox = new QHBoxLayout(this);

	QLabel *Label1= new QLabel(i18n("English Dic Path:"),this);
	eBasePath = new QLineEdit(this);
	bOpen = new KPushButton(this);
	//bOpen->setPixmap(ld->loadIcon("fileopen",KIcon::Toolbar));
	bOpen->setIcon( KIcon( "document-open" ) );
	topBox->setSpacing(5);
	topBox->addWidget(Label1);
	topBox->addWidget(eBasePath);
	//topBox->addWidget(bOpen,0);
	topBox->addWidget(bOpen);

			/*-- The 4-th coloumn is disabled for now --*/
	//tableWidget = new QTableWidget(0, 6, this);
	tableWidget = new Table_widg(this);	//ooo
	tableWidget->setRowCount(0);		//ooo
	tableWidget->setColumnCount(7);		//ooo
	//tableWidget->setEditTriggers(QAbstractItemView::DoubleClicked
          //                      | QAbstractItemView::SelectedClicked);	//ooo
	tableWidget->setSelectionBehavior(QAbstractItemView::SelectRows);	//ooo
	QStringList labels;
	//labels << tr("File Name") << tr("Language") << tr("Flag");
	//labels << tr("File Name") << tr("Language") << tr("Flag") << tr("Enabled");
	labels << tr("File Name") << tr("Language") << tr("Flag") << tr("Definition") << tr("Right-to-Left") << tr("Disabled") << tr("\"Expression\"") ;
	tableWidget->setHorizontalHeaderLabels(labels);
	tableWidget->horizontalHeader()->resizeSection(2, 50);	//ooo
	//tableWidget->horizontalHeader()->resizeSection(3, 90);	//ooo
	//tableWidget->horizontalHeader()->resizeSection(5, 70);	//ooo
	tableWidget->horizontalHeader()->setResizeMode(0, QHeaderView::Stretch);
	//tableWidget->verticalHeader()->hide();
	//tableWidget->verticalHeader()->setVisible(false);
	//tableWidget->setShowGrid(true);
	//tableWidget->resizeColumnToContents(0);

	bottomBox = new QHBoxLayout(this);
	bAdd = new KPushButton(i18n("&Add"),this);
	bRemoveAll = new KPushButton(i18n("&Remove All"),this);
	bMoveUp = new KPushButton(KIcon("go-up"),i18n("Up"),this);			//ooo
	bMoveDown = new KPushButton(KIcon("go-down"),i18n("Down"),this);		//ooo
	bMoveToLine = new KPushButton(KIcon("go-jump"),i18n("Move to Line"),this);	//ooo
	cGoToLine = new KComboBox(this);						//ooo
	bHelp = new KPushButton(i18n("&Help"),this);

	bottomBox->setSpacing(5);
	bottomBox->addWidget(bAdd);
	//bottomBox->addWidget(bScan);
	bottomBox->addWidget(bRemoveAll);
	bottomBox->addStretch();		//ooo
	bottomBox->addWidget(bMoveUp);		//ooo
	bottomBox->addWidget(bMoveDown);	//ooo
	bottomBox->addStretch();		//ooo
	bottomBox->addWidget(bMoveToLine);	//ooo
	bottomBox->addWidget(cGoToLine);	//ooo
	bottomBox->addStretch();
	bottomBox->addWidget(bHelp);

	//mainLayout = new QVBoxLayout(this);
	mainLayout->addLayout(topBox);
	mainLayout->addSpacing(5);
	mainLayout->addWidget(tableWidget);
	//mainLayout->addWidget(tableWidget, 0, 0);
	mainLayout->addSpacing(5);
	mainLayout->addLayout(bottomBox);
	//setLayout(mainLayout);
/*
	//Box = new QVBoxLayout;

	Box->addLayout(topBox);
	Box->addSpacing(5);
	//Box->addWidget(Table);
	Box->addWidget(tableWidget);
	Box->addSpacing(5);
	Box->addLayout(bottomBox);
*/

	//setBaseSize(10000, 200);

	moveOnTopAct = new QAction(KIcon("go-top"/*"arrow-up-double"*/), tr("Move on &Top"), this);
	moveUpAct = new QAction(KIcon("go-up"/*"arrow-up"*/), tr("Move &Up"), this);
	moveDownAct = new QAction(KIcon("go-down"/*"arrow-down"*/), tr("Move &Down"), this);
	moveToLineAct = new QAction(KIcon("go-down"/*"arrow-down"*/), tr("Move to Line"), this);
	editAct = new QAction(KIcon("document-properties"), tr("&Edit"), this);
	removeDictionaryAct = new QAction(KIcon("edit-delete"), tr("&Remove dictionary"), this);

	connect(bAdd,SIGNAL(clicked()),this,SLOT(slot_Add()));
	connect(bRemoveAll,SIGNAL(clicked()),this,SLOT(slot_RemoveAll()));
	connect(bMoveUp,SIGNAL(clicked()),this,SLOT(slot_moveUp()));		//ooo
	connect(bMoveDown,SIGNAL(clicked()),this,SLOT(slot_moveDown()));	//ooo
	connect(bMoveToLine,SIGNAL(clicked()),this,SLOT(slot_moveToLine()));	//ooo
	connect(bHelp,SIGNAL(clicked()),this,SLOT(slot_Help()));
	connect(bOpen,SIGNAL(clicked()),this,SLOT(slot_Open()));
	//connect(Table,SIGNAL(clicked(int,int,int,const QPoint &)),
	//	this,SLOT(slot_tableClicked(int,int,int,const QPoint &)));
	//connect(tableWidget,SIGNAL(cellClicked(int, int, const QPoint &) ),
	//	this,SLOT(slot_tableClicked(int, int, const QPoint &)));

	connect(tableWidget,SIGNAL(cellClicked(int, int)),this,SLOT(slot_table_Clicked(int, int)));	//ooo
	connect(tableWidget,SIGNAL(cellDoubleClicked(int, int)),this,SLOT(slot_tableClicked(int, int)));	//ooo

	//connect(tableWidget,SIGNAL(cellClicked(int, int)),SLOT(slot_showMenu(int, int)));

	connect(editAct,SIGNAL(triggered()), SLOT(slot_editRow()));

	connect(removeDictionaryAct, SIGNAL(triggered()), SLOT(slot_removeRow()));

	//connect(removeDictionaryAct,SIGNAL(triggered()), SLOT(slot_removeRow(int, int)));

	connect(moveOnTopAct,SIGNAL(triggered()), SLOT(slot_moveOnTop()));

	connect(moveUpAct,SIGNAL(triggered()), SLOT(slot_moveUp()));
	connect(moveDownAct,SIGNAL(triggered()), SLOT(slot_moveDown()));

	KStandardDirs sd;
	QStringList dirsPath = sd.findDirs("data","qtrans/flags");   //rdirsPath = ( ) -> "Exit error
	//dirsPath << "/usr/share/apps/qtrans/flags/";
	//QStringList::Iterator it = dirsPath.begin();
	//QStringList::const_iterator it = dirsPath.begin();
	QStringList::const_iterator it = dirsPath.constBegin();
	if ( it != dirsPath.constEnd() )
		flagPath = (*it);   //with this error with "Exit" button in toolbar
	//QMessageBox::about(this, i18n("About Menu"), QString("%1").arg((*it)));

	bMoveUp->setEnabled(false);			//ooo
	bMoveDown->setEnabled(false);			//ooo
	bMoveToLine->setEnabled(false);			//ooo

	cGoToLine->addItem(i18n("None"), tr(""));	//ooo

	//QString stringGoToLine = "";

	//for (int i = 0; i <= Data->count(); i++) {	//ooo
	//for (int i = 0; i <= tableWidget->rowCount(); i++) {	//ooo
	//for (int i = 0; i <= 5; i++) {	//ooo
		//stringGoToLine = i;
		//cGoToLine->addItem(stringGoToLine);
		//cGoToLine->setItemText(i,i);
	//}

	//cGoToLine->setMaxCount(Data->count());

}


Settings_widg::~Settings_widg()
{
}


void Settings_widg::mousePressEvent(QMouseEvent *event)	//ooo
{
        if (event->y() <25) {
                //isDraged=true;

                xPos=event->globalX();
                yPos=event->globalY();
        }
}


void Settings_widg::slot_RemoveAll(bool ask)
{
	if (ask && KMessageBox::warningContinueCancel(this,
		i18n("<qt>Are you sure to <b>remove all</b> dictionaries?</qt>"),
		i18n("Warning")) == KMessageBox::Cancel)
		return;

	for (int i = 0; i <= Data->count(); i++) {
		tableWidget->removeRow(i);
	}

	tableWidget->setRowCount(0);
	if (ask)
		Data->clear();
	bRemoveAll->setEnabled(false);
}


void Settings_widg::slot_Help()
{
	KMessageBox::information(this,
		i18n("<qt>The default dictionary is the one on top of the list, "
		"the others can be chosen from the popup menu in the main window.</qt>"),
		i18n("Help"));
}


void Settings_widg::slot_Open()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Open - Dictionary"),
                               "", tr("English.dic | Babylon Dictionary (*.dic)\n"
				"* | All files (*.*)"));
	if (fileName != QString::null)
		eBasePath->setText(fileName);
}


void Settings_widg::slot_Add()
{
	CAddWidget *AddWidget = new CAddWidget(this);
	AddWidget->show();
}


void Settings_widg::slot_table_Clicked(int row, int column)
{
	selectedRow = row;
	selectedColumn = column;	//ooo
	//tableWidget->setCurrentCell(selectedRow,0,QItemSelectionModel::Rows);
	//tableWidget->visualItemRect(selectedRow,0);

	int rowCount = tableWidget->rowCount();

	if (selectedRow==0) {
		bMoveUp->setEnabled(false);
	} else {
		bMoveUp->setEnabled(true);
	}

	if (selectedRow==rowCount-1) {
		bMoveDown->setEnabled(false);
	} else {
		bMoveDown->setEnabled(true);
	}

	if (selectedRow >= 0) {					//ooo
		cGoToLine-> setCurrentIndex(selectedRow+1);
		bMoveToLine->setEnabled(true);
	}

	//if (selectedRow=cGoToLine->currentIndex()-1) {	//ooo
	//	bMoveToLine->setEnabled(false);
	//}

	//QMouseEvent* mouseEvent;
	//QPoint point = mouseEvent->pos();
	//QTreeWidgetItem* current = ui.treeWidget->itemAt(mouseEvent->pos());
	//QTableWidgetItem* current = tableWidget->itemAt(QPoint(400,50));
	//QTableWidgetItem* current = tableWidget->mapToGlobal(tableWidget->itemAt(row,column));
	currentItem = tableWidget->item(selectedRow,selectedColumn);
	//QTableWidgetItem* current = tableWidget->itemAt(100*column,25*row);
	//QTableWidgetItem* current = tableWidget->itemAt(QPoint(mouseEvent->pos()));
	//QTableWidgetItem* current = tableWidget->itemAt(QPoint(Par_mouseEvent->pos()));
	//QTableWidgetItem* current = tableWidget->itemAt(row,column);
	//current->setBackground(0, Qt::red);

	//KMessageBox::sorry(this,	//ooo
	//	i18n("<qt>You are <u>here</u> !</qt>"));

	if (currentItem && currentItem != prevItem) {
        	if (prevItem) {
			prevItem->setBackground(palette().base());	// reset previous
		}
		currentItem->setBackground(tableItemColor/*Qt::yellow*/);	// highlight current
		prevItem = currentItem;
	} /*else {
		current->setBackground(Qt::yellow);
		prev = current;
	}*/

/*	if (xPos==NULL) {
		KMessageBox::sorry(this,
		i18n("<qt>You are in the <u>NULL</u> pointer!</qt>"));
	} else {
		if (event->y() < 25) {
			KMessageBox::sorry(this,
			i18n("<qt>You are in the <u><25</u> range!</qt>"));
		} else {
			KMessageBox::sorry(this,
			i18n("<qt>You are in the <u>>25</u> range!</qt>"));
		}

	}
*/
}


void Settings_widg::slot_tableClicked(int row, int column)
{

	selectedRow = row;

	setupDictionaryMenu = new QMenu(this);
	setupDictionaryMenu->addAction(moveOnTopAct);
	setupDictionaryMenu->addAction(moveUpAct);
	setupDictionaryMenu->addAction(moveDownAct);
	setupDictionaryMenu->addSeparator();
	setupDictionaryMenu->addAction(editAct);
	setupDictionaryMenu->addAction(removeDictionaryAct);
	if (selectedRow == 0) {
		moveOnTopAct->setDisabled(true);
		moveUpAct->setDisabled(true);
		//moveOnTopAct->setVisible(false);
	} else {
		moveOnTopAct->setEnabled(true);
		moveUpAct->setEnabled(true);
		//moveOnTopAct->setVisible(true);
	}

	int rowCount = tableWidget->rowCount();

	if ( selectedRow == rowCount - 1 ) {
		moveDownAct->setDisabled(true);
	} else {
		moveDownAct->setEnabled(true);
	}

	//setupDictionaryMenu->exec(tableWidget->mapToGlobal(QPoint(100, 60)));
	setupDictionaryMenu->exec(tableWidget->mapToGlobal(QPoint(tableWidget->xPos, tableWidget->yPos)));	//ooo
	//QAction *result = setupDictionaryMenu->activeAction();

/*	if ( setupDictionaryMenu->menuAction() ) {
		QMessageBox::about(this, tr("About Diagram Qtrans"), tr("xxxxx"));
	}*/

}


void Settings_widg::slot_moveUp()
{
	if (selectedRow == tableWidget->rowCount()-1) {	//ooo
		bMoveDown->setEnabled(true);
	}

	Data->move(selectedRow, selectedRow-1);
	repaintTable();
        tableWidget->setCurrentCell(selectedRow,0);	//ooo
	selectedRow = selectedRow-1;	//ooo
	prevItem = tableWidget->item(selectedRow+1,selectedColumn);	//ooo
	currentItem = tableWidget->item(selectedRow,selectedColumn);	//ooo
	currentItem->setBackground(tableItemColor);	//ooo
	prevItem->setBackground(palette().base()); //ooo
	prevItem = currentItem;	//ooo

	if (selectedRow == 0) {	//ooo
		bMoveUp->setEnabled(false);
	}

	if (selectedRow >= 0) {					//ooo
		cGoToLine-> setCurrentIndex(selectedRow+1);
	}

	//repaintTable();
}


void Settings_widg::slot_moveDown()
{
	if (selectedRow == 0) {						//ooo
		bMoveUp->setEnabled(true);
	}

/*	prevItem = 0;

	//tableWidget->insertRow(selectedRow+1);	//ooo
	tableWidget->insertRow(selectedRow+2);	//ooo

	currentItem = tableWidget->item(selectedRow+2,0);	//ooo

	//for (int i=0; i<=tableWidget->columnCount()-1; i++) {	//ooo
	//	tableWidget->setItem(selectedRow+2,i,tableWidget->item(selectedRow,i));
	//}

	//for (int i=0; i<=tableWidget->columnCount()-1; i++) {	//ooo
	//	tableWidget->setItem(selectedRow+1,i,tableWidget->item(selectedRow+3,i));
	//}


	//tableWidget->removeRow(selectedRow);	//ooo
	tableWidget->removeRow(selectedRow);	//ooo
*/

	Data->move(selectedRow, selectedRow+1);
	repaintTable();
	if (selectedRow >= tableWidget->rowCount()-2) {			//ooo
        	tableWidget->setCurrentCell(selectedRow+1,0);
	} else {
        	tableWidget->setCurrentCell(selectedRow+2,0);
	}
	selectedRow = selectedRow+1;					//ooo
	prevItem = tableWidget->item(selectedRow-1,selectedColumn);	//ooo
	currentItem = tableWidget->item(selectedRow,selectedColumn);	//ooo
	currentItem->setBackground(tableItemColor);			//ooo
	prevItem->setBackground(palette().base()); 			//ooo
	prevItem = currentItem;						//ooo

	if (selectedRow == tableWidget->rowCount()-1) {			//ooo
		bMoveDown->setEnabled(false);
	}

	if (selectedRow >= 0) {						//ooo
		cGoToLine-> setCurrentIndex(selectedRow+1);
	}

	//repaintTable();
}


void Settings_widg::slot_moveToLine()
{
/*	if (selectedRow == tableWidget->rowCount()-1) {	//ooo
		bMoveDown->setEnabled(true);
	}

	if (selectedRow == cGoToLine->currentIndex()-1) {	//ooo
		bMoveToLine->setEnabled(false);
	}
*/
	//Data->move(selectedRow, selectedRow-1);

#ifdef DEBUG_1
	qDebug() << "selectedRow = " << selectedRow;
	qDebug() << "cGoToLine->currentIndex() = " << cGoToLine->currentIndex();
#endif


	if (cGoToLine->currentIndex() != 0 && selectedRow != cGoToLine->currentIndex()-1) {
		Data->move(selectedRow,cGoToLine->currentIndex()-1);
		repaintTable();
        	tableWidget->setCurrentCell(cGoToLine->currentIndex()-1,0);	//ooo
		prevItem = tableWidget->item(selectedRow,selectedColumn);	//ooo
		selectedRow = cGoToLine->currentIndex()-1;			//ooo
		currentItem = tableWidget->item(selectedRow,selectedColumn);	//ooo
		currentItem->setBackground(tableItemColor);			//ooo
		prevItem->setBackground(palette().base()); 			//ooo
		prevItem = currentItem;						//ooo
	}

/*	Data->move(selectedRow, selectedRow-1);
	repaintTable();
        tableWidget->setCurrentCell(selectedRow,0);			//ooo
	selectedRow = selectedRow-1;	//ooo
	prevItem = tableWidget->item(selectedRow+1,selectedColumn);	//ooo
	currentItem = tableWidget->item(selectedRow,selectedColumn);	//ooo
	currentItem->setBackground(tableItemColor);			//ooo
	prevItem->setBackground(palette().base()); 			//ooo
	prevItem = currentItem;						//ooo
*/
	if (selectedRow == 0) {							//ooo
		bMoveUp->setEnabled(false);
		bMoveDown->setEnabled(true);
	} else if (selectedRow == tableWidget->rowCount()-1) {			//ooo
		bMoveUp->setEnabled(true);
		bMoveDown->setEnabled(false);
	} else {
		bMoveUp->setEnabled(true);
		bMoveDown->setEnabled(true);
	}

	//repaintTable();
}


void Settings_widg::slot_moveOnTop()
{
	Data->move(selectedRow, 0);
	repaintTable();

	if (selectedRow == tableWidget->rowCount()-1) {		//ooo
		bMoveDown->setEnabled(true);
	}

	bMoveUp->setEnabled(false);				//ooo
	selectedRow = 0;					//ooo
	cGoToLine-> setCurrentIndex(selectedRow+1);		//ooo
	currentItem = tableWidget->item(0,selectedColumn);	//ooo
	currentItem->setBackground(tableItemColor);		//ooo
	prevItem = currentItem;					//ooo
}


void Settings_widg::slot_editRow(/*int row*/)
{
	Dictionary Item = Data->at(selectedRow);
	CAddWidget *AddWidget = new CAddWidget(this,selectedRow,Item.fileName,
		//Item.Language, Item.flagID);
		//Item.Language, Item.flagID, Item.Codec);	//ooo
		//Item.Language, Item.flagID, Item.codecID);	//ooo
		//Item.Language, Item.flagID, Item.codecID, Item.directionID);	//ooo
		//Item.Language, Item.flagID, Item.codecID, Item.directionID, Item.disableID);	//ooo
		//Item.Language, Item.flagID, Item.codecID, Item.directionID, Item.disableID, Item.encodingID);	//ooo
		Item.Language, Item.flagID, Item.encodingDefinitionID, Item.directionID, Item.disableID, Item.encodingExpressionID);	//ooo
	AddWidget->show();
}


void Settings_widg::repaintTable()
{
	slot_RemoveAll(false);

	QList <Dictionary>::const_iterator itr;
	
	uint row = 0;

	for (itr = Data->constBegin(); itr != Data->constEnd(); ++itr) {
		QTableWidgetItem *fileNameItem = new QTableWidgetItem((*itr).fileName);
        	fileNameItem->setFlags(Qt::ItemIsEnabled);

		QTableWidgetItem *languageItem = new QTableWidgetItem((*itr).Language);
        	languageItem->setFlags(Qt::ItemIsEnabled);

		QTableWidgetItem *flagItem = new QTableWidgetItem(QIcon(QPixmap(flagPath+Flag[(*itr).flagID])), tr(""));
        	flagItem->setFlags(Qt::ItemIsEnabled);

		QTableWidgetItem *codecItem = new QTableWidgetItem(Codec[(*itr).encodingDefinitionID]);				//ooo
        	codecItem->setFlags(Qt::ItemIsEnabled);
		codecItem->setTextAlignment(Qt::AlignCenter);

		QTableWidgetItem *directionItem = new QTableWidgetItem(right_to_left_Direction[(*itr).directionID]);	//ooo
        	directionItem->setFlags(Qt::ItemIsEnabled);
		directionItem->setTextAlignment(Qt::AlignCenter);

		QTableWidgetItem *disableItem = new QTableWidgetItem(disable_enable[(*itr).disableID]);			//ooo
        	disableItem->setFlags(Qt::ItemIsEnabled);
		disableItem->setTextAlignment(Qt::AlignCenter);

		//QTableWidgetItem *encodingItem = new QTableWidgetItem(encoding[(*itr).encodingID]);			//ooo
		QTableWidgetItem *encodingItem = new QTableWidgetItem(Codec[(*itr).encodingExpressionID]);			//ooo
        	encodingItem->setFlags(Qt::ItemIsEnabled);
		encodingItem->setTextAlignment(Qt::AlignCenter);

		tableWidget->insertRow(row);
		tableWidget->setItem(row, 0, fileNameItem);
		tableWidget->setItem(row, 1, languageItem);
		tableWidget->setItem(row, 2, flagItem);
		tableWidget->setItem(row, 3, codecItem);	//ooo
		tableWidget->setItem(row, 4, directionItem);	//ooo
		tableWidget->setItem(row, 5, disableItem);	//ooo
		tableWidget->setItem(row, 6, encodingItem);	//ooo
		row++;
	}
	if (Data->count() > 0)
		bRemoveAll->setEnabled(true);

}

//void Settings_widg::addDictionary(QString fileName, QString language, int flagID)
//void Settings_widg::addDictionary(QString fileName, QString language, int flagID, QString codec)	//ooo
//void Settings_widg::addDictionary(QString fileName, QString language, int flagID, int codecID)	//ooo
//void Settings_widg::addDictionary(QString fileName, QString language, int flagID, int codecID, int directionID)	//ooo
//void Settings_widg::addDictionary(QString fileName, QString language, int flagID, int codecID, int directionID, int disableID)	//ooo
//void Settings_widg::addDictionary(QString fileName, QString language, int flagID, int codecID, int directionID, int disableID, int encodingID)	//ooo
void Settings_widg::addDictionary(QString fileName, QString language, int flagID, int encodingDefinitionID, int directionID, int disableID, int encodingExpressionID)	//ooo
{
	QTableWidgetItem *fileNameItem = new QTableWidgetItem(fileName);
	fileNameItem->setFlags(Qt::ItemIsEnabled | Qt::ItemIsEditable);

	QTableWidgetItem *languageItem = new QTableWidgetItem(language);
	languageItem->setFlags(Qt::ItemIsEnabled | Qt::ItemIsEditable);

	QTableWidgetItem *flagItem = new QTableWidgetItem(QIcon(QPixmap(flagPath+Flag[flagID])), tr(""));
	//QTableWidgetItem *flagItem = new QTableWidgetItem(QIcon(QPixmap(flagPath+Flag[flagID])), tr("Cubes"));
	//QTableWidgetItem *flagItem = new QTableWidgetItem(tr("Cubes"));
	//QTableWidgetItem *flagItem = new QTableWidgetItem();
	//flagItem->setIcon(QIcon(QPixmap(flagPath+Flag[flagID])));
	//flagItem->setTextAlignment(Qt::AlignCenter);
	flagItem->setFlags(Qt::ItemIsEnabled | Qt::ItemIsEditable);

	//QTableWidgetItem *flagItem = new QTableWidgetItem(QIcon(QPixmap("/usr/share/apps/qtrans/flags/flag-be.png")), tr("Cubes"));
	QTableWidgetItem *flagPathItem = new QTableWidgetItem(flagPath+Flag[flagID]+Language[flagID]);

	//QTableWidgetItem *codecItem = new QTableWidgetItem(codec);	//ooo
	QTableWidgetItem *codecItem = new QTableWidgetItem(Codec[encodingDefinitionID]);	//ooo
	codecItem->setFlags(Qt::ItemIsEnabled | Qt::ItemIsEditable);
	codecItem->setTextAlignment(Qt::AlignCenter);

	QTableWidgetItem *directionItem = new QTableWidgetItem(right_to_left_Direction[directionID]);	//ooo
	directionItem->setFlags(Qt::ItemIsEnabled | Qt::ItemIsEditable);
	directionItem->setTextAlignment(Qt::AlignCenter);

	QTableWidgetItem *disableItem = new QTableWidgetItem(disable_enable[disableID]);	//ooo
	disableItem->setFlags(Qt::ItemIsEnabled | Qt::ItemIsEditable);
	disableItem->setTextAlignment(Qt::AlignCenter);

	//QTableWidgetItem *encodingItem = new QTableWidgetItem(encoding[encodingID]);	//ooo
	QTableWidgetItem *encodingItem = new QTableWidgetItem(Codec[encodingExpressionID]);	//ooo
	encodingItem->setFlags(Qt::ItemIsEnabled | Qt::ItemIsEditable);
	encodingItem->setTextAlignment(Qt::AlignCenter);

	int row = tableWidget->rowCount();
	tableWidget->insertRow(row);
	//tableWidget->setItem(row, 0, new QTableWidgetItem(fileName));
	tableWidget->setItem(row, 0, fileNameItem);
	//tableWidget->setItem(row, 0, flagPathItem);
	tableWidget->setItem(row, 1, languageItem);
	tableWidget->setItem(row, 2, flagItem);
	tableWidget->setItem(row, 3, codecItem);
	tableWidget->setItem(row, 4, directionItem);
	tableWidget->setItem(row, 5, disableItem);
	tableWidget->setItem(row, 6, encodingItem);
	
	//Dictionary *Item = new Dictionary(fileName,language,flagID);
	//Dictionary *Item = new Dictionary(fileName,language,flagID,codec);	//ooo
	//Dictionary *Item = new Dictionary(fileName,language,flagID,codecID);	//ooo
	//Dictionary *Item = new Dictionary(fileName,language,flagID,codecID,directionID);	//ooo
	//Dictionary *Item = new Dictionary(fileName,language,flagID,codecID,directionID,disableID);	//ooo
	//Dictionary *Item = new Dictionary(fileName,language,flagID,codecID,directionID,disableID,encodingID);	//ooo
	Dictionary *Item = new Dictionary(fileName,language,flagID,encodingDefinitionID,directionID,disableID,encodingExpressionID);	//ooo
	Data->append(*Item);
	if (!bRemoveAll->isEnabled())
		bRemoveAll->setEnabled(true);

}


void Settings_widg::slot_removeRow(bool ask)
{
	if (ask && KMessageBox::warningContinueCancel(this,
		i18n("<qt>Are you sure to <b>remove </b> dictionary?</qt>"),
		i18n("Warning")) == KMessageBox::Cancel)
		return;

	int rowCount = tableWidget->rowCount();	//ooo

	prevItem = 0;	//ooo

	Data->removeAt(selectedRow);
	tableWidget->removeRow(selectedRow);

	if (selectedRow == 0 && rowCount > 1) {	//ooo
		currentItem = tableWidget->item(0,selectedColumn);
		currentItem->setBackground(tableItemColor);
		prevItem = currentItem;	//ooo
	} else if (rowCount > 1) {
		currentItem = tableWidget->item(selectedRow-1,selectedColumn);
		currentItem->setBackground(tableItemColor);
		prevItem = currentItem;	//ooo
		selectedRow -= 1;
	}

	//repaintTable();
}


/*-- Class CAddWidget --*/
/*-- Display a widget for inserting Dictionary data --*/

//CAddWidget::CAddWidget(Settings_widg *parent) :
CAddWidget::CAddWidget(Settings_widg *parent, int _row,
		//QString _fileName, QString _Language, int _flagID) :
		//QString _fileName, QString _Language, int _flagID, QString _Codec) :	//ooo
		//QString _fileName, QString _Language, int _flagID, int _codecID) :	//ooo
		//QString _fileName, QString _Language, int _flagID, int _codecID, int _directionID) :	//ooo
		//QString _fileName, QString _Language, int _flagID, int _codecID, int _directionID, int _disableID) :	//ooo
		//QString _fileName, QString _Language, int _flagID, int _codecID, int _directionID, int _disableID, int _encodingID) :	//ooo
		QString _fileName, QString _Language, int _flagID, int _encodingDefinitionID, int _directionID, int _disableID, int _encodingExpressionID) :	//ooo
          QWidget(parent, Qt::Dialog)
{

/*	KMessageBox::information(this,
		i18n("<qt>This is a test.</qt>"),
		i18n("Add dictionary"));
*/

	Parent = parent;

	setWindowModality(Qt::WindowModal);
	setWindowTitle(i18n("Add dictionary"));

	setMinimumSize(300, 150);
	//resize(440, 300);
	resize(670, 370);
	//Box = new QVBoxLayout(this);
	mainLayout = new QVBoxLayout(this);

	Box1 = new QHBoxLayout(this);
	QLabel *Label1 = new QLabel(i18n("File name :"),this);
	eFileName = new QLineEdit(this);
	bOpen = new KPushButton(this);
	//KIconLoader *ld = KGlobal::iconLoader();
	//bOpen->setPixmap(ld->loadIcon("fileopen.png",KIcon::Toolbar));
	bOpen->setIcon( KIcon( "document-open" ) );
	Box1->setSpacing(5);
	Box1->addWidget(Label1);
	Box1->addWidget(eFileName);
	Box1->addWidget(bOpen);

	Box2 = new QHBoxLayout(this);
	QLabel *Label2 = new QLabel(i18n("Language name :"),this);
	eLanguageName = new QLineEdit(this);
	Box2->setSpacing(5);
	Box2->addWidget(Label2);
	Box2->addWidget(eLanguageName);

	Box3 = new QHBoxLayout(this);
	QLabel *Label3 = new QLabel(i18n("Flag :"),this);
	cFlag = new KComboBox(this);
	Box3->setSpacing(5);
	Box3->addWidget(Label3);
	Box3->setSpacing(100);
	Box3->addWidget(cFlag);
	Box3->addStretch();

	Box8 = new QHBoxLayout(this);
	QLabel *Label8 = new QLabel(i18n("Disable :"),this);
	cDisable = new KComboBox(this);
	Box8->setSpacing(5);
	Box8->addWidget(Label8);
	Box8->setSpacing(75);
	Box8->addWidget(cDisable);
	Box8->addStretch();

	Box7 = new QHBoxLayout(this);
	QLabel *Label7 = new QLabel(i18n("Encoding Expression (File Encoding)* : "),this);
	cEncoding = new KComboBox(this);
	Box7->setSpacing(5);
	Box7->addWidget(Label7);
	Box7->setSpacing(100);
	Box7->addWidget(cEncoding);
	Box7->addStretch();

	//Box7 = new QHBoxLayout(this);	//ooo
	//QLabel *Label7 = new QLabel(i18n("Only for *dic.txt files :"),this);
	//Box7->addWidget(Label7);

	Box5 = new QHBoxLayout(this);	//ooo
	QLabel *Label5 = new QLabel(i18n("Encoding Definition (Text Encoding)* : "),this);
	//QLabel *Label5a = new QLabel(i18n("(only *dic.txt files)"),this);
	cCodec = new KComboBox(this);
/*	Box5->setSpacing(5);
	Box5->addWidget(Label5);
	Box5->addWidget(cCodec);
	Box5->addWidget(Label5a);
	Box5->addStretch();
*/
	Box6 = new QHBoxLayout(this);	//ooo
	//QLabel *Label6 = new QLabel(i18n("right to left writing :"),this);
	QLabel *Label6 = new QLabel(i18n("Right-to-Left language : "),this);
	//QLabel *Label6a = new QLabel(i18n("(only *dic.txt files)"),this);
	cDirection = new KComboBox(this);
	//ChangeDirection = new QCheckBox( "AutoPop"/*, Box6*/ );
	//ChangeDirection->setText(i18n("right to left"));
/*	Box6->setSpacing(5);
	Box6->addWidget(Label6);
	//Box6->addWidget(ChangeDirection);
	Box6->addWidget(cDirection);
	Box6->addWidget(Label6a);
	Box6->addStretch();
*/
	Box4 = new QHBoxLayout(this);
	bOk = new KPushButton(i18n("&OK"),this);
	bOk->setDefault(true);
	bCancel = new KPushButton(i18n("&Cancel"),this);
	Box4->setSpacing(5);
	Box4->addStretch();
	Box4->addWidget(bOk);
	Box4->addWidget(bCancel);

/*
	Box->setMargin(5);
	Box->setSpacing(5);
	Box->addLayout(Box1);
	Box->addLayout(Box2);
	Box->addLayout(Box3);
	Box->addLayout(Box4);
	setLayout(Box);
*/

	optionsGroupBox = new QGroupBox(tr("Options for bgl or (dic.txt -> File Encoding : None or iso-8859-1)* files"), this);
	optionsGroupBoxLayout = new QGridLayout(this);
	optionsGroupBoxLayout->addWidget(Label5, 0, 0);
	optionsGroupBoxLayout->addWidget(cCodec, 0, 1);
	optionsGroupBoxLayout->addWidget(Label6, 1, 0);
	optionsGroupBoxLayout->addWidget(cDirection, 1, 1);
	optionsGroupBoxLayout->addWidget(Label7, 2, 0);
	optionsGroupBoxLayout->addWidget(cEncoding, 2, 1);
	optionsGroupBox->setLayout(optionsGroupBoxLayout);

	//mainLayout->setMargin(5);
	//mainLayout->setSpacing(5);

	mainLayout->addLayout(Box1);
	mainLayout->addLayout(Box2);
	mainLayout->addLayout(Box3);
	mainLayout->addLayout(Box8);

	//mainLayout->addLayout(Box7);	//ooo
	//mainLayout->addLayout(Box5);	//ooo
	//mainLayout->addLayout(Box6);	//ooo
	mainLayout->addWidget(optionsGroupBox);	//ooo
	mainLayout->addLayout(Box4);
	setLayout(mainLayout);

	connect(bCancel,SIGNAL(clicked()),this,SLOT(slot_Close()));
	connect(bOpen,SIGNAL(clicked()),this,SLOT(slot_OpenFile()));
	connect(bOk,SIGNAL(clicked()),this,SLOT(slot_Ok()));

	//cFlag->insertItem(i18n("None"),0);
	cFlag->addItem(i18n("None"), tr(""));
	cCodec->addItem(i18n("None"), tr(""));		//ooo
	cDirection->addItem(i18n("No"), tr(""));	//ooo
	cDisable->addItem(i18n("No"), tr(""));		//ooo
	//cEncoding->addItem(i18n("No"), tr(""));		//ooo
	cEncoding->addItem(i18n("None"), tr(""));		//ooo

	//cFlag->addItem(QIcon(Parent->flagPath+Flag[1]),tr("Bad"));
/*	cFlag->addItem(KIcon("/usr/share/apps/qtrans/flags/flag-be.png"), tr("Belgium"));
	cFlag->addItem(KIcon("/usr/share/apps/qtrans/flags/flag-bg.png"), tr("Bulgaria"));
	cFlag->addItem(KIcon("/usr/share/apps/qtrans/flags/flag-bg.png"), tr("Brazil"));
	cFlag->addItem(KIcon("/usr/share/apps/qtrans/flags/flag-de.png"), tr("Germany"));
	cFlag->addItem(KIcon("/usr/share/apps/qtrans/flags/flag-he.png"), tr("Hebrew"));
*/

	//cFlag->addItem(QIcon(QPixmap(Parent->flagPath+Flag[2])), tr("This is a Flag"));
	//cFlag->addItem(QIcon(QPixmap(Parent->flagPath+Flag[3])), tr("This is a Flag"));


	for (int j = 1; Flag[j] != 0L; j++) {
		//cFlag->addItem(QIcon(QPixmap(Parent->flagPath+Flag[j])), tr("Text") );
		cFlag->addItem(QIcon(QPixmap(Parent->flagPath+Flag[j])), Language[j] );
	}

	for (int j = 1; Codec[j] != 0L; j++) {	//ooo
		cCodec->addItem(codecLanguage[j] + "  (" + Codec[j] +")");
	}

	for (int j = 1; right_to_left_Direction[j] != 0L; j++) {	//ooo
		//cDirection->addItem("Yes");
		cDirection->addItem(right_to_left_Direction[j]);
	}

	for (int j = 1; disable_enable[j] != 0L; j++) {	//ooo
		cDisable->addItem(disable_enable[j]);
	}

	//for (int j = 1; encoding[j] != 0L; j++) {	//ooo
	//	cEncoding->addItem(encoding[j]);
	//}

	for (int j = 1; Codec[j] != 0L; j++) {	//ooo
		cEncoding->addItem(codecLanguage[j] + "  (" + Codec[j] +")");
	}


	editMode = false;

	if ( _row != -1 && _fileName != QString::null
		//&& _Language != QString::null && _flagID >= -1) {
		//&& _Language != QString::null && _flagID >= -1 && _codecID >= -1) {
		//&& _Language != QString::null && _flagID >= -1 && _codecID >= -1 && _directionID >= -1) {
		//&& _Language != QString::null && _flagID >= -1 && _codecID >= -1 && _directionID >= -1 && _disableID >= -1) {
		//&& _Language != QString::null && _flagID >= -1 && _codecID >= -1 && _directionID >= -1 && _disableID >= -1 && _encodingID >= -1) {
		&& _Language != QString::null && _flagID >= -1 && _encodingDefinitionID >= -1 && _directionID >= -1 && _disableID >= -1 && _encodingExpressionID >= -1) {
		eFileName->setText(_fileName);
		eLanguageName->setText(_Language);
		//cFlag->setCurrentItem(_flagID);
		cFlag->setCurrentIndex(_flagID);
		//cCodec->setCurrentIndex(_codecID);		//ooo
		cCodec->setCurrentIndex(_encodingDefinitionID);		//ooo
		cDirection->setCurrentIndex(_directionID);	//ooo
		cDisable->setCurrentIndex(_disableID);		//ooo
		//cEncoding->setCurrentIndex(_encodingID);	//ooo
		cEncoding->setCurrentIndex(_encodingExpressionID);	//ooo
		editRow = _row;
		editMode = true;
	}

}


CAddWidget::~CAddWidget()
{
}


void CAddWidget::slot_Close()
{
	close();
}


void CAddWidget::slot_Ok()
{
	if (eFileName->text()=="") {
		KMessageBox::sorry(this,
		i18n("<qt>You have to <u>insert</u> a dictionary filename!</qt>"));
		return;
	}
	if (editMode) {
		//Dictionary *Item = new Dictionary(eFileName->text(), eLanguageName->text(), cFlag->currentIndex());
		//Dictionary *Item = new Dictionary(eFileName->text(), eLanguageName->text(), cFlag->currentIndex(), cCodec->currentText());	//ooo
		//Dictionary *Item = new Dictionary(eFileName->text(), eLanguageName->text(), cFlag->currentIndex(), Codec[cCodec->currentIndex()]);	//ooo
		//Dictionary *Item = new Dictionary(eFileName->text(), eLanguageName->text(), cFlag->currentIndex(), cCodec->currentIndex());	//ooo
		//Dictionary *Item = new Dictionary(eFileName->text(), eLanguageName->text(), cFlag->currentIndex(), cCodec->currentIndex(), cDirection->currentIndex());	//ooo
		//Dictionary *Item = new Dictionary(eFileName->text(), eLanguageName->text(), cFlag->currentIndex(), cCodec->currentIndex(), cDirection->currentIndex(), cDisable->currentIndex());	//ooo
		Dictionary *Item = new Dictionary(eFileName->text(), eLanguageName->text(), cFlag->currentIndex(), cCodec->currentIndex(), cDirection->currentIndex(), cDisable->currentIndex(), cEncoding->currentIndex());	//ooo
		Parent->Data->replace(editRow, *Item);
		Parent->tableWidget->item(editRow, 0)->setText(eFileName->text());
		Parent->tableWidget->item(editRow, 1)->setText(eLanguageName->text());
		Parent->tableWidget->item(editRow, 2)->setIcon(QIcon(QPixmap(Parent->flagPath+Flag[cFlag->currentIndex()])));
		//Parent->tableWidget->item(editRow, 3)->setText(cCodec->currentText());				//ooo
		Parent->tableWidget->item(editRow, 3)->setText(Codec[cCodec->currentIndex()]);				//ooo
		Parent->tableWidget->item(editRow, 4)->setText(right_to_left_Direction[cDirection->currentIndex()]);	//ooo
		Parent->tableWidget->item(editRow, 5)->setText(disable_enable[cDisable->currentIndex()]);		//ooo
		//Parent->tableWidget->item(editRow, 6)->setText(encoding[cEncoding->currentIndex()]);			//ooo
		Parent->tableWidget->item(editRow, 6)->setText(Codec[cEncoding->currentIndex()]);			//ooo
		close();
		return;

	}
	//Parent->addDictionary(eFileName->text(),eLanguageName->text(), cFlag->currentIndex());
	//Parent->addDictionary(eFileName->text(),eLanguageName->text(), cFlag->currentIndex(), cCodec->currentText());	//ooo
	//Parent->addDictionary(eFileName->text(),eLanguageName->text(), cFlag->currentIndex(), Codec[cCodec->currentIndex()]);	//ooo
	//Parent->addDictionary(eFileName->text(),eLanguageName->text(), cFlag->currentIndex(), cCodec->currentIndex());	//ooo
	//Parent->addDictionary(eFileName->text(),eLanguageName->text(), cFlag->currentIndex(), cCodec->currentIndex(), cDirection->currentIndex());	//ooo
	//Parent->addDictionary(eFileName->text(),eLanguageName->text(), cFlag->currentIndex(), cCodec->currentIndex(), cDirection->currentIndex(), cDisable->currentIndex());	//ooo
	Parent->addDictionary(eFileName->text(),eLanguageName->text(), cFlag->currentIndex(), cCodec->currentIndex(), cDirection->currentIndex(), cDisable->currentIndex(), cEncoding->currentIndex());	//ooo
	close();

}


void CAddWidget::slot_OpenFile()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Open - Dictionary"),
                               "", tr("Engto*.dic | Babylon Dictionaries (*.dic)\n"
				"*.bgl | Babylon Dictionaries (*.bgl)\n"
				"*.dic.txt | Plain Text Dictionaries (*.dic.txt)\n"
				"*.ifo | StarDict Dictionaries (*.ifo)\n"
				"* | All files (*.*)"));
	if (fileName != QString::null)
		eFileName->setText(fileName);
}


Table_widg::Table_widg(QWidget *parent) :	//ooo
	QTableWidget( parent )
{
}


Table_widg::~Table_widg()
{
}


void Table_widg::mousePressEvent(QMouseEvent *event)
{
	if (itemAt(event->pos()))
		QTableWidget::mousePressEvent(event);
	//else
	//	clearSelection();

	//KMessageBox::sorry(this, i18n("mousePressEvent!"));
        //if (event->y() <25) {
                //isDraged=true;

                xPos=event->x();
                yPos=event->y();
                xGlobalPos=event->globalX();
                yGlobalPos=event->globalY();
        //}

	//KMessageBox::sorry(this, i18n(positionString.toLatin1()));
	//QMessageBox::about(this, i18n("About Menu"), QString("xPos = %1, yPos = %2, xGlobalPos = %3, yGlobalPos = %4").arg(xPos).arg(yPos).arg(xGlobalPos).arg(yGlobalPos));

}

#include "settings_widg.moc"
