/***************************************************************************
                          stardict.cpp  -  description

                             -------------------
    begin                : 27. November 2009
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#include <QMessageBox>
#include <KLocale>
#include <QDebug>		//ooo
#include <QByteArray>
#include <QIODevice>		//ooo
#include <QStack>		//ooo
#include <QTextDocument>	//ooo
#include <QTextCursor>		//ooo

#include <zlib.h>

#include <iostream>		//ooo
#include <stdio.h>		//ooo
#include <stdlib.h>		//ooo
#include <assert.h>		//ooo

#include "stardict.h"

#define CHUNK 0xffffL

#define GZ_XLEN         10

#define DICT_UNKNOWN    0
#define DICT_TEXT       1
#define DICT_GZIP       2
#define DICT_DZIP       3

//#define DEBUG_1
//#define DEBUG_1a
//#define DEBUG_1b
//#define DEBUG_1c
//#define DEBUG_2
//#define DEBUG_2a
//#define DEBUG_3

StarDict::StarDict(const QString &filename, bool wholeStarDict, bool wholeWordsOnly, bool wordStartsWith)
{

	#ifdef DEBUG_1
		//std::cout.setf(std::ios_base::hex,std::ios_base::basefield);
		std::cout << "StarDict::StarDict( )" << "\n";
	#endif
	
	b_wholeStarDict = wholeStarDict;
	b_wholeWordsOnly = wholeWordsOnly;
	b_wordStartsWith = wordStartsWith;
	p_filename = filename.toAscii().data();

	ifoFile = new QFile(filename);

	if (!ifoFile->open(QIODevice::ReadOnly)) {
		//return text = "error *.ifo";
	}

	QString ifoline;

	while( !ifoFile->atEnd() ) {
		//ifoFile->readLine( ifoline, 1024 );
		ifoline = ifoFile->readLine();

		//if( ifoline.find( "=" ) == -1 ) continue;
		//ifoline.remove( "\n" );
		if( ifoline.section( "=", 0, 0 ) == "version" ) m_version = ifoline.section( "=", 1 );
		if( ifoline.section( "=", 0, 0 ) == "bookname" ) m_bookname = ifoline.section( "=", 1 );
		if( ifoline.section( "=", 0, 0 ) == "sametypesequence" ) m_sametypesequence = ifoline.section( "=", 1 );
		if( ifoline.section( "=", 0, 0 ) == "idxfilesize" ) m_idxfilesize = ifoline.section( "=", 1 ).toULong();
		if( ifoline.section( "=", 0, 0 ) == "wordcount" ) m_wordcount = ifoline.section( "=", 1 ).toUInt();
		if( ifoline.section( "=", 0, 0 ) == "author" ) m_author = ifoline.section( "=", 1 );
		if( ifoline.section( "=", 0, 0 ) == "email" ) m_email = ifoline.section( "=", 1 );
		if( ifoline.section( "=", 0, 0 ) == "website" ) m_website = ifoline.section( "=", 1 );
		if( ifoline.section( "=", 0, 0 ) == "description" ) m_description = ifoline.section( "=", 1 );
		if( ifoline.section( "=", 0, 0 ) == "date" ) m_date = ifoline.section( "=", 1 );
	}

	ifoFile->close();

	#ifdef DEBUG_1
		std::cout << "StarDict::StarDict( ) (A)" << "\n";
	#endif

	QString file_holder_str = filename;

	file_holder_str.replace( ".ifo", ".idx" );

	if( !QFile::exists( file_holder_str ) ) {
		//m_isOk = false;
		return;
	}

	idxFile = new QFile( file_holder_str );

	file_holder_str.replace( ".idx", ".dict" );

	if( QFile::exists( file_holder_str ) ) {
		dictFile = new QFile( file_holder_str );
		isCompressed = false;
	} else {
		if( !QFile::exists( file_holder_str + ".dz" ) ) {
			//m_isOk = false;
			return;
		}

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (B)" << "\n";
		#endif
	
		// The definition file is compressed (.dict.dz)
		// Read the header
		dictFile = new QFile( file_holder_str + ".dz" );
		isCompressed = true;

		if (!dictFile->open(QIODevice::ReadOnly )) {
			//return text = "error *.dict.dz";

			#ifdef DEBUG_1
				std::cout << "error *.dict.dz" << "\n";
			#endif

		}
		
		this->headerLength = GZ_XLEN - 1;	//ooo

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (C)" << "\n";
		#endif

		//ID1 = 31 (0x1f, \037)
		dictFile->getChar(&c);

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (C: if)" << " ID1 = " << c << "\n";
		#endif

		if ( c != 0x1f ) {		//ooo
			//m_isOk = false;
			return;
		}
		
		//ID2 = 139 (0x8b, \213)
		dictFile->getChar(&c);
		
		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (D) ID2 = " << c << "\n";
		#endif
		
		if ( (unsigned char)c != 0x8b ) {
		 	
			return;
			
		}

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (E)" << "\n";
		#endif

		// COMPRESSION
		dictFile->getChar(&c);
		CM = /*(unsigned char)*/c;

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (E: if)" << " CM = " << c << "(" << c - '0' << ")" <<"\n";
		#endif

		if ( c == 0x08 ) {
			 
			#ifdef DEBUG_1
				std::cout << "StarDict::StarDict( ) (E: if->if): c == '0x08'" << "\n";
			#endif
			
		}

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (F)" << "\n";
			//std::cout << "StarDict::StarDict( ) (D)" << " c = " << c << "\n";
		#endif

		// FLAGS		// 0x0c
		dictFile->getChar(&c);
		FLAGS = (unsigned char)c;
		
		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (F: if)" << " FLAGS = " << c << "(" << c - '0' << ")" << int(c) << "\n";
		#endif

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (G)" << "\n";
		 #endif

		FTEXT    = FLAGS & 1;		// bit 0
		FHCRC    = FLAGS & 2;		// bit 1
		FEXTRA   = FLAGS & 4;		// bit 2	ooo
		FNAME    = FLAGS & 8;		// bit 3
		FCOMMENT = FLAGS & 16;		// bit 4
		
		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (H): FTEXT = " << FTEXT << " FHCRC = " << FHCRC <<
			" FEXTRA = " << FEXTRA << " FNAME = " << FNAME << " FCOMMENT = " << FCOMMENT << "\n";
		 #endif

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (1)" << "\n";
		#endif

		dictFile->getChar(&c);
		MTIME  = (unsigned char)c << 0;
		dictFile->getChar(&c);
		MTIME |= (unsigned char)c << 8;
		dictFile->getChar(&c);
		MTIME |= (unsigned char)c << 16;
		dictFile->getChar(&c);
		MTIME |= (unsigned char)c << 24;
		
		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (2)" << "\n";
		#endif

		// Compression type
		// specific compression method		//ooo
		dictFile->getChar(&c);
		
		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (2_1): c = " << c << "\n";
		#endif
		
		if ( c == 0x02 ) {
		
			#ifdef DEBUG_1
				std::cout << "StarDict::StarDict( ) (2_2): c = 0x02" << "\n";
			#endif
		
			//return;
		}
		
		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (3)" << " COMPRESSION = " << c << "\n";
		#endif
		
		// Operating System
		dictFile->getChar(&c);

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (4) Operating System = " << c << "\n";
		#endif

		if ( FEXTRA ) {			//ooo
			
			dictFile->getChar(&c);
			XLEN = (unsigned char)c << 0;
			dictFile->getChar(&c);
			XLEN |= (unsigned char)c << 8;
			
			this->headerLength += XLEN + 2;		//ooo

			#ifdef DEBUG_1
				std::cout << "StarDict::StarDict( ) (4_1) headerLength += XLEN + 2 = " << headerLength << "\n";
			#endif

			readExtraField();
		}

		#ifdef DEBUG_1
			std::cout << "\nStarDict::StarDict( ) (5)" << "\n";
		#endif

		if( FNAME ) {
			readFileName();
			
			this->origFilename = buffer;					//ooo
			this->headerLength += this->origFilename.length() + 1;		//ooo

			#ifdef DEBUG_1
				std::cout << "StarDict::StarDict( ) (5_1) headerLength += this->origFilename.length() + 1 = " << headerLength << "\n";
			#endif

			
		}

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (6)" << "\n";
		#endif

		if( FCOMMENT ) {
			readFileName();
			
			comment = buffer;			//ooo
			headerLength += comment.length()+1;	//ooo

			#ifdef DEBUG_1
				std::cout << "StarDict::StarDict( ) (6_1) headerLength += comment.length()+1 = " << headerLength << "\n";
			#endif

			
		}

		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (7)" << "\n";
		#endif

		if( FHCRC ) {
			
			dictFile->getChar(&c);
			*crc16[0] = (unsigned char)c;
			dictFile->getChar(&c);
			*crc16[1] = (unsigned char)c;
			
			this->headerLength += 2;	//ooo

			#ifdef DEBUG_1
				std::cout << "StarDict::StarDict( ) (7_1) headerLength += 2 = " << headerLength << "\n";
			#endif

		}

		offset = dictFile->pos();
		//offsetAdditional = offset;	//ooo
		
		#ifdef DEBUG_1
			std::cout << "StarDict::StarDict( ) (End): offset = " << offset << "\n";
			std::cout << "StarDict::StarDict( ) (End): headerLength = " << headerLength << "\n";
		#endif
		
		offsetAdditional = this->headerLength + 1;	//ooo
		
		for ( int i = 0; i < this->CHCNT; i++) {

			offsetsWithHeader.append(offsetAdditional);	//ooo
			offsetAdditional += offsets[i];			//ooo
		}
		
		dictFile->close();
	}
}


StarDict::~StarDict()
{

	delete ifoFile;
	delete idxFile;
	delete dictFile;

}


void StarDict::readExtraField()
{
	//kdDebug() << "readExtraField()" << endl;
	offsets.clear();

	dictFile->getChar(&c);
	SI1 = /*(unsigned char)*/c;

	#ifdef DEBUG_1
		std::cout << "StarDict::readExtraField() (a): SI1 = " << c << "\n";
	#endif

	dictFile->getChar(&c);
	SI2 = /*(unsigned char)*/c;
		
	#ifdef DEBUG_1
		std::cout << "StarDict::readExtraField() (b): SI2 = " << c << "\n";
	#endif

	// length of the subfield data
	// length of the subfield data, excluding the 4 initial bytes		//ooo

	if ( SI1 == 'R' || SI2 == 'A' ) {
	  
		dictFile->getChar(&c);
		LEN = (unsigned char)c << 0;
		dictFile->getChar(&c);
		LEN |= (unsigned char)c << 8;
	}

	//int size = (int)LEN - 6;
	int size = (int)LEN + 4;	//ooo
	
	#ifdef DEBUG_1
		std::cout << "StarDict::readExtraField() (c): LEN = " << LEN << " size = " << size << "\n";
	#endif
	
	// Version

	dictFile->getChar(&c);
	VER = (unsigned char)c << 0;
	dictFile->getChar(&c);
	VER |= (unsigned char)c << 8;
	
	#ifdef DEBUG_1
		std::cout << "StarDict::readExtraField() (d): VER = " << VER << "\n";
	#endif

	// length of a "chunk" of data

	dictFile->getChar(&c);
	CHLEN = (unsigned char)c << 0;
	dictFile->getChar(&c);
	CHLEN |= (unsigned char)c << 8;
	
	#ifdef DEBUG_1
		std::cout << "StarDict::readExtraField() (e): CHLEN = " << CHLEN << "\n";
	#endif

	// how many chunks are preset

	dictFile->getChar(&c);
	CHCNT = (unsigned char)c << 0;
	dictFile->getChar(&c);
	CHCNT |= (unsigned char)c << 8;
	
	#ifdef DEBUG_1
		std::cout << "StarDict::readExtraField() (f): CHCNT = " << CHCNT << "\n";
	#endif

	unsigned long data;
	//uint data;	//ooo

	for(int a = 0; a < CHCNT; a++) {		//ooo

		// how long is each chunk after compression

		dictFile->getChar(&c);
		data  = (unsigned char)c << 0;
		dictFile->getChar(&c);
		data |= (unsigned char)c << 8;
		
		#ifdef DEBUG_1a
			//std::cout << " data[a=" << a << "]="  << data;
			std::cout << " offsets[a=" << a << "]="  << data;
		 #endif
		
		offsets.append( data );
	}
	
	this->type = DICT_DZIP;		//ooo
	
}


void StarDict::readFileName()
{
  
	#ifdef DEBUG_1
		std::cout << "StarDict::readFileName() (1)" << "\n";
	#endif
 
	QString filename_str;
	//char byte;
	//char *byte;	//ooo
	
	//byte = dictFile->getChar(c);

	/*if ( dictFile->getChar(&c) ) {
		//byte = c;
		*byte = c;
	}*/
	
	byte = buffer;		//ooo

	//while( byte != '\0' ) {
	while( dictFile->getChar(&c) && c != EOF ) {		//ooo
		//filename_str += byte;
		*byte++ = c;			//ooo
		//byte = dictFile->getChar(c);

		/*if ( dictFile->getChar(&c) ) {
			byte = c;
		}*/

	}
	
	*byte = '\0';	//ooo

	//m_filename = filename_str;
	m_filename = buffer;	//ooo
	
	#ifdef DEBUG_1
		std::cout << "m_filename = " << m_filename.toAscii().data() << "\n";
	#endif
	
}


QString StarDict::search( const QString &word )
{

	#ifdef DEBUG_1
		std::cout << "word = " << word.toAscii().data() << "\n";
	#endif

	struct entry entry;
	//struct entries entries;			//ooo

	QByteArray line;
	line.resize(256);
	line.clear();				//ooo
	QString headword;
	headword.clear();			//ooo
	headwords.clear();			//ooo
	positions.clear();			//ooo
	sizes.clear();				//ooo
	bool found = false;
	//bool goThroughWholeDic = true;	//ooo
	uint p = 0;				//ooo
	bool foundWholeWord = false;		//ooo
	

	if (!idxFile->open(QIODevice::ReadOnly )) {

		#ifdef DEBUG_1
			std::cout << "error *.idx " << "\n";
		#endif

	}

	QString text;		//ooo
	text.clear();		//ooo

	// Find the headword in index file
	uint a;

	//idxFile->seek(4);

	#ifdef DEBUG_1
		std::cout << "while (!idxFile->atEnd())" << "\n";
	#endif

	while( !idxFile->atEnd() ) {

		a = 0;
		bool finished = false;	//ooo

		#ifdef DEBUG_2
			std::cout << ".";
			//std::cout << "line[" << a << " - 1] = " << line[a-1].data() << "\n";
		#endif

		do {

			#ifdef DEBUG_2
				std::cout << "do " /*<< "\n"*/;
			#endif

			idxFile->getChar(&c);
			line[a] = (unsigned char)c;

			#ifdef DEBUG_2
				std::cout << "line[" << a << "]= " << line[a] << " ";
			#endif

			a++;

		} while ( line[a-1] != '\0' );

		#ifdef DEBUG_2
			std::cout << "while (!idxFile->atEnd()) (B)" << "\n";
			//std::cout << "line[" << a << " - 1] = " << line[a-1].data() << "\n";
		#endif

		headword = QString::fromUtf8( line.data() );

		#ifdef DEBUG_2a
			std::cout << "headword = " << line.data() /*<< "\n"*/;
		#endif

		for( a = 0; a < 8; a++ ) {

			idxFile->getChar(&c);
			line[a] = (unsigned char)c;

		}
		
		#ifdef DEBUG_2a
			std::cout << "***" << "\n";
		#endif
		
		/*QString word2;
		word2 = "<p i=01>" + word;
		
		int pos = 0;
		int p = 0;
		bool wordFound = false;
		
		QRegExp rx( "<(p|p\\si=\\d*)>('?-?\\w*-?'?\\w*|\\W*)" );
		
		if ( (pos = rx.indexIn(headword, pos)) != -1 ) {	//ooo
		
			#ifdef DEBUG_2a
				qDebug() << "rx.cap(0) = " << rx.cap(0);
			#endif
			
			if ( QString::compare( rx.cap(2), word, Qt::CaseInsensitive) == 0 ) {
		  
				wordFound = true;
				
			}
		}*/

		int indexOfWord = headword.indexOf(word, 1, Qt::CaseInsensitive);

		//if( QString::compare( headword, word, Qt::CaseInsensitive) != 0 ) continue;
		//if( QString::compare( headword, word, Qt::CaseInsensitive) != 0 && QString::compare( headword, word2, Qt::CaseInsensitive) != 0 ) continue;	//ooo
		//if( QString::compare( headword, word, Qt::CaseInsensitive) != 0 && !wordFound ) continue;	//ooo
		//if( QString::compare( headword, word, Qt::CaseInsensitive) != 0 && !headword.contains( word, Qt::CaseInsensitive) ) continue;	//ooo
		//if( QString::compare( headword, word, Qt::CaseInsensitive) != 0 && headword.at(headword.indexOf(word)-1) != '>' ) continue;	//ooo
		//if( headword.contains( word, Qt::CaseInsensitive) ) continue;			//ooo
		//if ( QString::compare(headword, word, Qt::CaseInsensitive) != 0 && (indexOfWord < 0 || (indexOfWord > 0 && headword.at(indexOfWord-1) != '>') )
			//&& ( b_wholeStarDict && !headword.contains( word, Qt::CaseInsensitive)) ) continue;	//ooo
			
		if (b_wholeWordsOnly && headword.contains(word, Qt::CaseInsensitive)) {

			QTextDocument document(headword, 0);			//ooo
			QTextCursor highlightCursor(&document);			//ooo
			//QTextCursor cursor(&document);			//ooo

			while (!highlightCursor.isNull() && !highlightCursor.atEnd()) {
        			highlightCursor = document.find(word, highlightCursor, QTextDocument::FindWholeWords);

        			if (!highlightCursor.isNull()) {
					foundWholeWord = true;
					break;
				}
			}
		}
			
		if (!b_wholeStarDict) {
		  
			#ifdef DEBUG_1b
				std::cout << "if (!b_wholeStarDict) { " << "\n"; 
			#endif
			
			if (QString::compare(headword, word, Qt::CaseInsensitive) != 0 
			&& (indexOfWord < 0 || (indexOfWord > 0 && headword.at(indexOfWord-1) != '>')) ) continue;
			
		} else {
		  
			#ifdef DEBUG_1b
				std::cout << "if (!b_wholeStarDict) { (else) " << "\n"; 
			#endif  
		  
		  	if (b_wholeWordsOnly) {
				if (!foundWholeWord) continue;
					foundWholeWord = false;
			} else if (b_wordStartsWith) {
				//if (!headword.startsWith( word, Qt::CaseInsensitive) && !headword.contains( " "+word, Qt::CaseInsensitive)
				  //&& !headword.contains( ">"+word, Qt::CaseInsensitive) && !headword.contains( "-"+word, Qt::CaseInsensitive)) continue;
				if (!headword.contains(word, Qt::CaseInsensitive)) continue;
				//if (!headword.startsWith(word, Qt::CaseInsensitive)) continue;
				int index = headword.indexOf(word, 0, Qt::CaseInsensitive);
				if (index > 0) {
					QChar ch = headword.at(index-1);
					
					#ifdef DEBUG_1c
						std::cout << "index = " << index << "\n"; 
					#endif  
					
					//if (ch != ' ' && ch != '<' && ch != '-') continue;
					if (ch != QChar(0x20) && ch != QChar(0x3E) && ch != QChar(0x2D)) continue;
				}
			} else {
				if (!headword.contains( word, Qt::CaseInsensitive)) continue;
			}
		}

		/*if ( QString::compare(headword, word, Qt::CaseInsensitive) != 0 ) {		//ooo
			if ( indexOfWord <= 0 ) {
				continue;
			} else if ( headword.at(indexOfWord - 1) != '>' ) {
				continue;
			}
		}*/

		found = true;

		// Catch the position of definition in definition file
		entry.position = (unsigned char)line[3] + 256 * (unsigned char)line[2] + 256 * 256 * (unsigned char)line[1] + 256 * 256 * 256 *(unsigned char)line[0];

		// Catch the size of definition in definition file
		entry.size = (unsigned char)line[7] + 256 * (unsigned char)line[6] + 256 * 256 * (unsigned char)line[5] + 256 * 256 * 256 *(unsigned char)line[4];

		#ifdef DEBUG_2a
			std::cout << "\nentry.position = " << entry.position /*<< "\n"*/;
			std::cout << " entry.size = " << entry.size << "\n";
		#endif

		// Word found. Break the loop.
		//break;
		
		if (!b_wholeStarDict) {	//ooo
			break;
		} else {
			headwords.append(headword);
			positions.append(entry.position);
			sizes.append(entry.size);
			continue;
			//entries.position.insert(position);
			//entries.size(size);
			//entries.position[p] = position;
			//entries.size[p] = size;
			//p++;
		}

	}

	idxFile->close();

	//if( !found ) return text = "*** nothing ***";	//ooo
	if( !found ) return text = "";	//ooo

	// Check if the definition file is compressed
	if( isCompressed ) {
	  
		char pt[CHUNK];		//ooo
		//ulong a = 0;
		//uint a = 0;		//ooo
		uint a;			//ooo
		QByteArray result;	//ooo
		result.clear();		//ooo

		if (b_wholeStarDict) {
		  
			dictFile->open( QIODevice::ReadOnly );
			
			for (int i = 0; i < headwords.size(); i++) {
		  
				a = 0;
				uint chunk = positions.at(i) / CHLEN ;
				uint pos = positions.at(i) % CHLEN;
				uint lastChunk = (positions.at(i) + sizes.at(i)) / CHLEN;		//ooo
				uint lastPos = (positions.at(i) + sizes.at(i)) % CHLEN;			//ooo
			
				#ifdef DEBUG_1b
					std::cout << "headwords.at(i=" << i << ") = " << headwords.at(i).toAscii().data() << "\n"; 
					std::cout << "chunk " << "(entry.position = " << entry.position << " / " << "CHLEN = " << CHLEN << ") = " << chunk << "\n";
					std::cout << "pos " << "(entry.position = " << entry.position << " % " << "CHLEN = " << CHLEN << ") = " << pos << "\n";
					std::cout << "lastChunk = " << lastChunk << "\n";
					std::cout << "lastPos = " << lastPos << "\n";
				#endif
			
				//QByteArray result;
				//result.clear();		//ooo
				result.append("<p><l>"+headwords.at(i).toAscii()+"</l></p>");
				//result.append("\n");

				//dictFile->open( QIODevice::ReadOnly );
			
				for (uint i = chunk; i <= lastChunk; i++) {	//ooo
		  
					dictFile->seek( offsetsWithHeader[i] );
					unsigned int chunkLen = offsets[i];

					unsigned char data[chunkLen];		//ooo

					for(unsigned long a = 0; a < offsets[i]; a++) {
						dictFile->getChar(&c);
						data[a] = (unsigned char)c;
					}
			
					if( i == chunk && i == lastChunk) {
			  
						memcpy(pt, Inflate(data, offsets[i]) + pos, lastPos - pos);
						pt[lastPos-pos] = '\0';						//ooo
			  
					} else {
			
						if( i == chunk ) {
							memcpy(pt, Inflate(data, offsets[i]) + pos, CHLEN - pos);
							pt[CHLEN - pos] = '\0';						//ooo
						} else if( i == lastChunk) {
							memcpy(pt, Inflate(data, offsets[i]), lastPos);
							pt[lastPos] = '\0';						//ooo
						} else {
							memcpy(pt, Inflate(data, offsets[i]), CHLEN);
							pt[CHLEN] = '\0';						//ooo
						}
					}
					result.append(pt);
				}
				result.append("<hr width=\"5\" size=\"1\" align=\"center\">");
			}
			
		} else {

		// Calculate how many chunks we have to skip
		uint chunk = entry.position / CHLEN ;
		// Calculate the position of definition in chunk
		uint pos = entry.position % CHLEN;
		// Calculate the last chunk
		uint lastChunk = (entry.position + entry.size) / CHLEN;		//ooo
		// Calculate the last position of definition in chunk
		uint lastPos = (entry.position + entry.size) % CHLEN;		//ooo
		
		#ifdef DEBUG_1
			std::cout << "chunk " << "(entry.position = " << entry.position << " / " << "CHLEN = " << CHLEN << ") = " << chunk << "\n";
			std::cout << "pos " << "(entry.position = " << entry.position << " % " << "CHLEN = " << CHLEN << ") = " << pos << "\n";
			std::cout << "lastChunk = " << lastChunk << "\n";
			std::cout << "lastPos = " << lastPos << "\n";
		#endif

		// Stores the decompressed data
		//QByteArray result;
		//result.clear();		//ooo

		// Definition file
		dictFile->open( QIODevice::ReadOnly );
		
		#ifdef DEBUG_1
			std::cout << "offsetsWithHeader[chunk = " << chunk << "] = " << offsetsWithHeader[chunk] << "\n";
			std::cout << "offsetsWithHeader[chunk + 1= " << chunk+1 << "] = " << offsetsWithHeader[chunk+1] << "\n";
			std::cout << "offsets[chunk = " << chunk << "] = " << offsets[chunk] << "\n";
		#endif

		// Decompress the data
		for(uint i = chunk; i <= lastChunk; i++) {	//ooo
		  
			#ifdef DEBUG_1
				std::cout << "\n**** i = " << i << "****" << "\n";
			#endif
		 
			// Jump to chunk we are looking for
			dictFile->seek( offsetsWithHeader[i] );
			unsigned int chunkLen = offsets[i];

			#ifdef DEBUG_1
				std::cout << "offsets[chunk=" << chunk << "]=" << offsets[chunk] << "\n";
				std::cout << "chunkLen = " << chunkLen << "\n";
			#endif

			unsigned char data[chunkLen];		//ooo

			// Get the compressed data
			for(unsigned long a = 0; a < offsets[i]; a++) {
				dictFile->getChar(&c);
				data[a] = (unsigned char)c;
			}
			
			#ifdef DEBUG_1
				std::cout << "*** *** pt = " << pt << "\n";
				//std::cout << "\n*** *** data = " << data << "\n\n";
			#endif
			
			if( i == chunk && i == lastChunk) {
			  
				#ifdef DEBUG_1
					std::cout << "***> if( i == chunk && i == lastChunk)" << "\n";
				#endif
			 
				memcpy(pt, Inflate(data, offsets[i]) + pos, lastPos - pos);
				pt[lastPos-pos] = '\0';						//ooo
			  
			} else {
			  
				#ifdef DEBUG_1
					std::cout << "****> if( i == chunk && i == lastChunk): (else)" << "\n";
				#endif
			
				if( i == chunk ) {
			
					memcpy(pt, Inflate(data, offsets[i]) + pos, CHLEN - pos);
					pt[CHLEN - pos] = '\0';						//ooo
				
				} else if( i == lastChunk) {
			
					memcpy(pt, Inflate(data, offsets[i]), lastPos);
					pt[lastPos] = '\0';						//ooo
			 
				} else {
			 
					memcpy(pt, Inflate(data, offsets[i]), CHLEN);
					pt[CHLEN] = '\0';						//ooo
			 
				}
			}
			
			#ifdef DEBUG_1
				std::cout << "\n*** *** *** pt = " << pt << "\n";
			#endif
			
			//result.append( Inflate( data4, offsets[i] ));
			//result.append( parseData(pt).toAscii().data() );			//ooo
			result.append(pt);

		}
		}
		dictFile->close();
		
		// Returns only the definition
		return QString::fromUtf8(result);	//ooo

	} else {

		#ifdef DEBUG_1
			std::cout << "isCompressed = false (1)" << "\n";
			//std::cout << "pos = " << pos << "\n";
		#endif

		// The file is not compressed
		if (!dictFile->open(QIODevice::ReadOnly)) {

			#ifdef DEBUG_1
				std::cout << "error *.idx " << "\n";
			#endif

		}

		// Jump to position of definition
		dictFile->seek(entry.position);

		#ifdef DEBUG_1
			std::cout << "isCompressed = false (2)" << "\n";
			//std::cout << "pos = " << pos << "\n";
		#endif

		// Get the definition
		QByteArray result;
		result.clear();		//ooo
		result.resize( entry.size + 1 );

		#ifdef DEBUG_1
			std::cout << "isCompressed = false (3)" << "\n";
			std::cout << "entry.size = " << entry.size << "\n";
		#endif

		for( uint a = 0; a < entry.size; a++ ) {

			dictFile->getChar(&c);
			result[a] = c;

		}

		result.insert(entry.size, QByteArray("\0"));	//ooo

		dictFile->close();

		// Return the result

		#ifdef DEBUG_3
			std::cout << "result.data() = " << result.data() << "\n";
			//std::cout << "pos = " << pos << "\n";
		#endif

		return QString::fromUtf8( result.data() );
	}
}


char* StarDict::Inflate( unsigned char *data, unsigned long size )		//ooo
{
	
	#ifdef DEBUG_1
		std::cout << "\nInflate()" << "\n";
		std::cout << "CHUNK = " << CHUNK << "\n";
		std::cout << "size = " << size << "\n";
		//std::cout << "data.size() = " << data.size() << "\n";
	#endif

	
	int ret;
	unsigned have;			//ooo
	//int have;			//ooo
	z_stream strm;
	char in[CHUNK];			//ooo
	char out[CHUNK];

	// Inicialization of zlib
	/* allocate inflate state */	//ooo
	strm.zalloc = Z_NULL;
	strm.zfree = Z_NULL;
	strm.opaque = Z_NULL;
	strm.avail_in = 0;
	strm.next_in = Z_NULL;
	//ret = inflateInit2( &strm, -MAX_WBITS );
	ret = inflateInit2( &strm, -15 );		//ooo
	//ret = inflateInit2( &strm, 8 );		//ooo
	//ret = inflateInit(&strm);			//ooo
	if (ret != Z_OK)
		return "/////";
	
	/* decompress until deflate stream ends or end of file */
	//do {								//ooo
		//strm.avail_in = fread(in, 1, CHUNK, source);		//ooo
		
		// Compressed data
		strm.avail_in = size;			//ooo
		strm.next_in = (Bytef*)data;		//ooo

		#ifdef DEBUG_1
			//std::cout << "data.size() = " << data.size() << "\n";
			//std::cout << "str2.size() = " << str2.size() << "\n";
			//std::cout << "size = " << size << "\n";
			//std::cout << "data2.data() = " << data2.data() << "\n";
		 #endif
	
		/* run inflate() on input until output buffer not full */
		do {
			strm.avail_out = CHUNK;
			strm.next_out = (Bytef*)out;
			//ret = inflate(&strm, Z_SYNC_FLUSH);
			//ret = inflate(&strm, Z_NO_FLUSH);	//ooo
			ret = inflate(&strm, Z_PARTIAL_FLUSH);	//ooo
			//assert(ret != Z_STREAM_ERROR);  /* state not clobbered */	//ooo

			#ifdef DEBUG_1
				std::cout << "\nret = " << ret << "\n";
			#endif

			if ( ret != Z_OK ) {

				#ifdef DEBUG_1
					std::cout << "ret != Z_OK\n";
				#endif

			}

			#ifdef DEBUG_1
				std::cout << "\nZ_NEED_DICT (1) = " << Z_NEED_DICT << "\n";
				std::cout << "Z_STREAM_ERROR (2) = " << Z_STREAM_ERROR << "\n";
				std::cout << "Z_DATA_ERROR (3) = " << Z_DATA_ERROR << "\n";
				std::cout << "Z_MEM_ERROR (4) = " << Z_MEM_ERROR << "\n\n";
			#endif
		
			switch (ret) {
				case Z_NEED_DICT:
					ret = Z_DATA_ERROR;     /* and fall through */
					
					#ifdef DEBUG_1
						std::cout << "-->	Z_NEED_DICT (1)" << "\n";
					#endif

				case Z_STREAM_ERROR:
				  
					#ifdef DEBUG_1
						std::cout << "-->	Z_STREAM_ERROR (2)" << "\n";
					#endif

					break;
					
				case Z_DATA_ERROR:
				  
					#ifdef DEBUG_1
						std::cout << "-->	Z_DATA_ERROR (3)" << "\n";
					#endif

					break;
				  
				case Z_MEM_ERROR:
					(void)inflateEnd(&strm);
					
					#ifdef DEBUG_1
						std::cout << "-->	Z_MEM_ERROR (4)" << "\n";
					#endif

					break;
			}
			
			have = CHUNK - strm.avail_out;		//ooo
			
			#ifdef DEBUG_1
				std::cout << "have = " << have << "(CHUNK = " << CHUNK << " - " << "strm.avail_out = " << strm.avail_out << ")" << "\n";
			#endif
			
			/*if (fwrite(out, 1, have, dest) != have || ferror(dest)) {	//ooo
				(void)inflateEnd(&strm);
				return Z_ERRNO;
			}*/
			
			#ifdef DEBUG_1
				//std::cout << "pt = " << pt << "\n";
				//std::cout << "out = " << out << "\n";
			#endif

		} while (strm.avail_out == 0);
		
	/* done when inflate() says it's done */
	//} while (ret != Z_STREAM_END);
	
	/* clean up and return */
	//ret = inflateEnd(&strm);
	(void)inflateEnd(&strm);	//ooo
	//return result;
	
	//std::cout << "StarDict::parseData = " << parseData(out).toAscii().data() << "\n";	//ooo
	
	#ifdef DEBUG_1
		std::cout << "out = " << out << "\n";
		std::cout << "\nStarDict::Inflate() (End) *****************************" << "\n\n";
	#endif

	return &out[0];			//ooo
}


QString StarDict::parseData(const char *data)
{

}



QString StarDict::printMessage()
{
	//QMessageBox::about(this, tr("About Diagram Scene"), tr("printMessage(: 1"));
	//QMessageBox::about(i18n("About Menu"), QString("%1").arg("printMessage(: 1"));

	return "StarDict <---> !!!";
}

/*bool StarDict::open()
{
	//unsigned char buf[6];
	//int i;

	f = fopen( m_filename.c_str(), "r" );

	if( f == NULL ) {
		return false;
	}

	return true;
}*/

//void StarDict::Info_Ifo(FILE & f)
void StarDict::Info_Ifo(QFile & file)
{
	/*QString line = "";
	bool ok;

	QTextStream in(&file);

	line = in.readLine();

	//if ( f.gets() != "StarDict's dict ifo file" ) {

	//}

	if ( line != "StarDict's dict ifo file" ) {

	}

	while (!line.isNull()) {

		if ( line.startsWith("wordcount=") ) {
			wordcount = line.section('=', 1, 1).toInt(&ok, 0);
			//wordcount = line.section('=', 1, 1);
		} else if ( line.startsWith("idxfilesize=") ) {
			idxfilesize = line.section('=', 1, 1).toInt(&ok, 0);
			//idxfilesize = line.section('=', 1, 1);
		}

		line = in.readLine();
	}*/
}


void StarDict::Info_Idx(QFile & file)
{
	QString line = "";

	QTextStream in(&file);
	//QDataStream in(&file);

	//line = in.readLine();

	while (!in.atEnd()) {

		line = in.readLine();
		printf( "%s\n", line.toAscii().data() );

	}

	/*QString str;
	qint32 a;
	in >> str;
	printf( "%s\n", str.toAscii().data() );
	qDebug() << str;*/

}

#include "stardict.moc"
