/***************************************************************************
                          babylon.h  -  description
                             -------------------
	This library is based on the work of Frederic Jolliton on Libbab
	this is a porting to QT library
	
    begin                : December 2007
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#ifndef BABYLON_H
#define BABYLON_H

#include <QList>
#include <QString>
#include <QTime>		//ooo

#include <fstream>
//#include "fstream.h"
#include "settings_widg.h"	//ooo	because of "Dictionary"


typedef unsigned int	Q_UINT32;   //ooo
typedef unsigned char	Q_UINT8;   //ooo
typedef unsigned short	Q_UINT16;   //ooo

using namespace std;

/**
  *@author Matteo Merli
  */

class Item {
public:
	QString word;
	QString attribute;
	QString definition;
	
};


class Babylon {
public: 
	Babylon();
	~Babylon();

	QTime t;		//ooo
	ifstream file_eng;	//ooo
	ifstream file_spec;	//ooo

	//bool translate(QString ,QList<Item> &);
	bool translate(QString ,QList<Item> &, QString);   //ooo
	bool open(QString engDic, QString specDic);
	//QString translateAndFormat(QString);
	//QString translateAndFormat(QString, QString);   //ooo
	//QString translateAndFormat(QString, QString, int);   //ooo
	//QString translateAndFormat(QString, QString, int, int);   //ooo
	//QString translateAndFormat(QString, Dictionary, int&);   //ooo
	//QString translateAndFormat(QString, Dictionary, int&, bool, bool, bool);   //ooo
	//QString translateAndFormat(QString, Dictionary, int&, bool, bool, bool, QString);   //ooo
	//QString translateAndFormat(QString, Dictionary, int&, bool, bool, bool, bool, QString);   //ooo
	QString translateAndFormat(QString, Dictionary, int&, bool, bool, bool, bool, bool, QString);   //ooo
private:
	/*typedef unsigned char u8;
	typedef unsigned short u16;
	typedef unsigned long u32;*/
	
	QList<Item> item_list;
	
	/*
	QFile *file_eng;
	QFile *file_spec;
	QDataStream *stream_eng;
	QDataStream *stream_spec;
	*/
	//ifstream file_eng;
	//ifstream file_spec;
	
	long word_index(QString word);
	QString bab_to_char_jap_2(int lsb, int msb);	//ooo
	QString bab_to_char_chinese(int lsb, int msb);	//ooo
	QString bab_to_char_jap_hiragana(int c);	//ooo
	QString bab_to_char_jap_katakana(int c);	//ooo
	QChar bab_to_char_heb(int c);			//ooo
	char bab_to_char(int c);
	QString read_word_jap(uint length);		//ooo
	QString read_word_chinese(uint length);		//ooo
	QString read_word_heb(uint length);		//ooo
	QString read_word(uint length);
	Item make_definition_jap(Q_UINT32);		//ooo
	Item make_definition_chinese(Q_UINT32);		//ooo
	Item make_definition_heb(Q_UINT32);		//ooo
	Item make_definition(Q_UINT32);
	/*
	bool translate_priv(const string& word, container_type &);
	*/
};

#endif
