/** BEGIN COPYRIGHT BLOCK
 * Copyright (C) 2001 Sun Microsystems, Inc.  Used by permission.
 * Copyright (C) 2005 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * END COPYRIGHT BLOCK **/
/*
 * dllglue.c: Glue routines for the admlib.so shared object. These are 
 * necessary because on many system no garbage collection is performed for
 * shared objects.
 * 
 * Rob McCool
 */


#ifdef XP_UNIX

#include "base/systems.h"

#define FUNC(name) void name (void) {}

FUNC(DS_Alloc)
FUNC(DS_Free)
FUNC(DS_Zfree)
FUNC(MD5_HashBuf)
#ifdef THREAD_NSPR_KERNEL
FUNC(PR_GetSelectFD)
#endif
FUNC(RC4_MakeKey)
FUNC(SEC_CertTimesValid)
FUNC(SEC_CheckPassword)
FUNC(SEC_CloseKeyDB)
FUNC(SEC_DestroyPrivateKey)
FUNC(SEC_FileForRNG)
FUNC(SEC_FindCertByNickname)
FUNC(SEC_FindKeyByName)
FUNC(SEC_GetPassword)
FUNC(SEC_Init)
FUNC(SEC_NameToAscii)
FUNC(SEC_OpenCertDB)
FUNC(SEC_OpenKeyDB)
FUNC(SEC_UTCTimeToAscii)
FUNC(SSL_Accept)
FUNC(SSL_AcceptHook)
FUNC(SSL_Bind)
FUNC(SSL_Close)
FUNC(SSL_ConfigSecureServer)
FUNC(SSL_ConfigServerSessionIDCache)
FUNC(SSL_Enable)
FUNC(SSL_EnableCipher)
FUNC(SSL_GetPeerName)
FUNC(SSL_GetSockOpt)
FUNC(SSL_Import)
FUNC(SSL_IsDomestic)
FUNC(SSL_Listen)
FUNC(SSL_Read)
FUNC(SSL_SecurityCapabilities)
FUNC(SSL_SecurityStatus)
FUNC(SSL_SetSockOpt)
FUNC(SSL_Socket)
FUNC(SSL_Write)

#endif
