# BEGIN COPYRIGHT BLOCK
# Copyright (C) 2001 Sun Microsystems, Inc.  Used by permission.
# Copyright (C) 2005 Red Hat, Inc.
# All rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#

# END COPYRIGHT BLOCK
ifneq ($(ARCH), WINNT)

OLD_BUILD_ROOT := $(BUILD_ROOT)
BUILD_ROOT := $(shell cd $(OLD_BUILD_ROOT); pwd)
SRCDIR=$(BUILD_ROOT)/admserv/cgi-src40

ifeq ($(ARCH), OSF1)
EXTRA_LIBS += -Wl,-rpath,../../lib:../..:../../../../lib
endif

ifeq ($(ARCH), Linux)
EXTRA_LIBS += -Wl,-rpath,../../lib:../..:../../../../lib
endif

ifeq ($(ARCH), IRIX)
EXTRA_LIBS += -lgen -rpath ../../lib:../..:../../../../lib
endif


ifeq ($(ARCH), SOLARIS)
EXTRA_LIBS += -lgen -R../../lib:../..:../../../../lib
endif

ifeq ($(ARCH), SONY)
EXTRA_LIBS += -rpath ../../lib:../..:../../../../lib
endif

ifeq ($(ARCH), NECSVR4)
EXTRA_LIBS +=  -L../../lib -L../..
endif

ifeq ($(ARCH), HPUX)
EXTRA_LIBS += -Wl,+b,../../lib:../..:../../../../lib
endif

ifeq ($(ARCH), AIX)
#LDAPLINK=-L../.. -L../../../../lib $(addprefix -l, $(LDAP_LIBNAMES))
EXTRA_LIBS+= -blibpath:../../lib:.:../../:../../../../lib:$(DEF_LIBPATH) -brtl
endif

ifdef USE_LD_RUN_PATH
EXTRA_LIBS += -L.
export LD_RUN_PATH=../../lib:../..:../../../../lib
endif

ifeq ($(ARCH), SUNOS4)
EXTRA_LIBS +=  -L../../lib -L../..
endif

EXTRA_LIBS += $(MATHLIB)

ifndef LDAPLINK
LDAPLINK = -L$(LDAPSDK_LIBPATH) $(addprefix -l,  $(addsuffix $(DLL_PRESUF), $(LDAP_LIBNAMES)))
endif

GLUEOBJS=$(OBJDIR)/admin-lib/dllglue.o

ifeq ($(ARCH), AIX)
DEPLINK+=-bE:$(OBJDIR)/admin-lib/dllglue.exp
endif

ifeq ($(ARCH), AIX)
$(GLUEOBJS): dllglue.c
	$(CC) -c $(CFLAGS) $(MCC_INCLUDE) dllglue.c \
              -o $(OBJDIR)/admin-lib/dllglue.o
	nm -B -g $(OBJDIR)/admin-lib/dllglue.o \
		| awk '/ [T,D,B] / {print $$3}' \
		| sed -e 's/^\.//' \
		| sort -u > $(OBJDIR)/admin-lib/dllglue.exp
	echo func_standard >> $(OBJDIR)/admin-lib/dllglue.exp

else
#
# Puzzled! If this is not seperated, secglue.o will be removed after
# compiling the cgi programs!
#
$(GLUEOBJS): dllglue.c
	$(CC) -c $(CFLAGS) $(MCC_INCLUDE) dllglue.c \
              -o $(OBJDIR)/admin-lib/dllglue.o
endif

$(OBJDIR)/admin-lib:
	mkdir -p $(OBJDIR)/admin-lib

#
# 10/01/96 achan
# The dependency rules for ADMLIB is really defined in ../src/unixso.mk
# So go there and check!
#
# 5/12/97 achan
# Remove the check for whether ns-admin.so should be rebuilt since it will
# sometimes remake it for no reason.
#
$(ADMLIB): FORCEIT

FORCEIT:

endif
