#!/bin/bash
pkgver=0.7.2
rm -rf debian/{etc,usr}
mkdir -p debian/etc/xdg/menus/applications-merged
mkdir -p debian/etc/xdg/menus/kde-applications-merged
mkdir -p debian/etc/xdg/menus/kde4-applications-merged
mkdir -p debian/usr/share/doc/kmenu-gnome-$pkgver
mkdir -p debian/usr/share/icons/hicolor/36x36
cp --preserve=timestamps xdg/kmenu-gnome.menu \
debian/etc/xdg/menus/applications-merged
cp --preserve=timestamps xdg/kmenu-gnome.menu \
debian/etc/xdg/menus/kde-applications-merged
cp --preserve=timestamps xdg/kmenu-gnome.menu \
debian/etc/xdg/menus/kde4-applications-merged
cp --preserve=timestamps ChangeLog COPYING GPL LGPL README \
debian/usr/share/doc/kmenu-gnome-$pkgver
cp -r --preserve=timestamps desktop-directories icons kmenu-gnome \
debian/usr/share
# Missing icons:
( cd debian/usr/share/icons/crystalsvg/16x16/devices
ln -s gnome-dev-harddisk.png drive-harddisk.png )
( cd debian/usr/share/icons/crystalsvg/22x22/devices
ln -s gnome-dev-harddisk.png drive-harddisk.png )
( cd debian/usr/share/icons/crystalsvg/32x32/devices
ln -s gnome-dev-harddisk.png drive-harddisk.png )
# Make package:
find ./debian -type d | xargs chmod 755
dpkg-deb --build debian
mv debian.deb kmenu-gnome_$pkgver-1_all.deb
rm -rf debian/{etc,usr}
