/*
 * Cache module
 * See cache.h about the details.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdlib.h>
#if defined(HAVE_STRING_H)
#include <string.h>
#elif defined(HAVE_STRINGS_H)
#include <strings.h>
#endif
#include "cache.h"
#include "mem.h"
#include "glib-1.2.8/glib.h"

/* Data structure */
struct _XyCache {
	GHashTable *htable;
};


/* Private function prototypes */
static void free_key_value(char *key, char *value, void *user_data);

XyCache*
cache_new(int ini_size)
{
	XyCache *cache;

	cache = (XyCache*)xmalloc(sizeof(XyCache));
	cache->htable = g_hash_table_new(NULL, NULL);
	return cache;
}

void
cache_destroy(XyCache *cache)
{
	g_hash_table_foreach(cache->htable, free_key_value, NULL);
	g_hash_table_destroy(cache->htable);
	xfree(cache);
}

/**
 * cache_insert:
 * Return 1 if success. Or, return 0.
 **/
int
cache_insert(XyCache *cache, const char *key, int key_lenb, const char *value, int value_lenb)
{
	char *key_dup;
	char *value_dup;

	if (key_lenb == 0)
		key_dup = strdup(key);
	else {
		key_dup = (char*)xmalloc(key_lenb + 1);
		memcpy(key_dup, key, key_lenb);
		key_dup[key_lenb] = '\0';
	}
	if (value_lenb == 0)
		value_dup = strdup(value);
	else {
		value_dup = (char*)xmalloc(value_lenb + 1);
		memcpy(value_dup, value, value_lenb);
		value_dup[value_lenb] = '\0';
	}
	
	g_hash_table_insert(cache->htable, key_dup, value_dup);

	return 1;
}

int
cache_remove(XyCache *cache, const char *key, int key_lenb)
{
	g_hash_table_remove(cache->htable, key);

	return 1;
}

/**
 * cache_lookup:
 * If nothing is hit, return NULL.
 **/
const char*
cache_lookup(XyCache *cache, const char *key, int key_lenb)
{
	return g_hash_table_lookup(cache->htable, key);
}


static void
free_key_value(char *key, char *value, void *user_data)
{
	xfree(key);
	xfree(value);
}
