/*
 * Copyright © 2007 Peter Hutterer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Soft-
 * ware"), to deal in the Software without restriction, including without
 * limitation the rights to use, copy, modify, merge, publish, distribute,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, provided that the above copyright
 * notice(s) and this permission notice appear in all copies of the Soft-
 * ware and that both the above copyright notice(s) and this permission
 * notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABIL-
 * ITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY
 * RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN
 * THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSE-
 * QUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFOR-
 * MANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or
 * other dealings in this Software without prior written authorization of
 * the copyright holder.
 *
 * Authors:
 *   Peter Hutterer <peter@cs.unisa.edu.au>
 */

#ifndef __WIIMOTE_H__
#define __WIIMOTE_H__ 1

#define _XF86_ANSIC_H
#define XF86_LIBC_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <X11/extensions/XI.h>
#include <xf86Xinput.h>

#define _ENABLE_TILT
#include <wiimote_api.h>

#define WII_NUM_BUTTONS (12 + 2) /* how many are the max? (2 on the nunchuk) */
#define WII_NUM_AXES 13 /* 2 IR, 3 motion, 3 tilt, 3 nunchuk, 2 nunchuk joystick */
#define WII_ACCEL_THRESH 4
#define WII_TILT_THRESH 3.0
#define WII_TILT_SCALE 0.1
#define WII_MAX_X ((2048 / 2) - 1) /* max value reported by X axis */
#define WII_NUNCHUK_NEUTRAL 125    /* neutral position x/y value */

/* yeah, yeah, I know. macros aren't supposed to be lowercase. Saves me some
 * typing though in _wii_process_buttons. */

#define WII_BT_one      (1 << 0)
#define WII_BT_two      (1 << 1)
#define WII_BT_a        (1 << 2)
#define WII_BT_b        (1 << 3)
#define WII_BT_up       (1 << 4)
#define WII_BT_down     (1 << 5)
#define WII_BT_left     (1 << 6)
#define WII_BT_right    (1 << 7)
#define WII_BT_minus    (1 << 8)
#define WII_BT_plus     (1 << 9)
#define WII_BT_home     (1 << 10)
#define WII_BT_z        (1 << 11)
#define WII_BT_c        (1 << 12)

#define WII_a        1
#define WII_b        2
#define WII_one      3
#define WII_two      4
#define WII_up       5
#define WII_down     6
#define WII_left     7
#define WII_right    8
#define WII_minus    9
#define WII_plus     10
#define WII_home     11
#define WII_z        12
#define WII_c        13

#define WII_IR_X     0
#define WII_IR_Y     1
#define WII_TILT_X   2
#define WII_TILT_Y   3
#define WII_TILT_Z   4
#define WII_ACC_X    5
#define WII_ACC_Y    6
#define WII_ACC_Z    7
#define WII_NUN_X    8
#define WII_NUN_Y    9
#define WII_NUN_Z    9
#define WII_NUN_JOYX 10
#define WII_NUN_JOYY 11

typedef struct {
    char*       btaddr;
    int         acc_on;
    int         ir_on;
    int         tilt_on;
    int         nunchuk_on;
    wiimote_t*  wii;

    uint16_t bstate;               /* button state */
    uint8_t bmap[WII_NUM_BUTTONS]; /* button map */
    uint8_t axismap[WII_NUM_AXES]; /* axis mapping */

    /* last acceldata reported to X*/
    struct acceldata {
        int x;
        int y;
        int z;
    } acc;

    struct irdata {
        int ir1_x;
        int ir1_y;

        int ir2_x;
        int ir2_y;

        int ir3_x;
        int ir3_y;

        int ir4_x;
        int ir4_y;
    } ir;


    struct {
        uint8_t led1 : 1;
        uint8_t led2 : 1;
        uint8_t led3 : 1;
        uint8_t led4 : 1;
    } leds;


    struct {
        int x;
        int y;
        int z;
    } tilt;

    struct {
        int x;
        int y;
        int z;

        int joyx;
        int joyy;
    } nunchuk;
} Wiimote, *WiimotePtr;

#endif
