.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH WIIMOTE __drivermansuffix__ __vendorversion__
.SH NAME
wiimote \- X driver for the Nintendo Wiimote
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" devname \*q
.B  "  Driver \*qwiimote\*q"
.BI "  Option \*qDevice\*q              \*q" devpath \*q
.BI "  Option \*qIR\*q                  \*q" True \*q
.BI "  Option \*qTilt\*q                \*q" True \*q
.BI "  Option \*qNunchuk\*q             \*q" True \*q
.BI "  Option \*qAccelerometer\*q       \*q" True \*q
.BI "  Option \*qLED[1-4]\*q            \*q" False \*q
.BI "  Option \*qButtonMapping\*q       \*q" string \*q
.BI "  Option \*qAxisMapping\*q         \*q" string \*q
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B wiimote
is an __xservername__ input driver for the Nintendo Wiimote
.PP
The 
.B wiimote
driver can do pointer emulation.  It can be used as the core pointer.  For
default order of buttons see
.B Option \*qButtonMapping\*q
below.
.fi

.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.

.PP
.SH OPTIONS
.PP
The following driver 
.B Options
control what devices are accepted:

.TP 7
.BI "Option \*qDevice\*q \*q" string \*q
Specifies the bluetooth-address to connect to. The address must be in a form
of "00:AB:11:CD:22:EF".  The device must be set to discovery mode (press 1+2
simultaneously or the red button inside the battery compartment).
.fi
If the device cannot be reached, the driver will fail and the device will not
be available.

.TP 7
.BI "Option \*qName\*q \*q" string \*q
Specifies the device name for the device you wish to use.
.fi
It probably helps if you assign some meaningful name to the device, so an X
client has some way of knowing what the device actually is. Think "Wiimote 1"
or the like.

.TP 7
.BI "Option \*qIR\*q \*q" bool \*q
Enable IR on the device (default enabled). If IR is enabled, it screws with
everything (see
.B AxisMapping
and
.B BUGS
).


.TP 7
.BI "Option \*qTilt\*q \*q" bool \*q
Enable tilt sensors on the device (default enabled).

.TP 7
.BI "Option \*qNunchuk\*q \*q" bool \*q
Enable Nunchuk (default disabled). The nunchuck reports three accelerometer
axis plus two joystick axis reporting. All values are to be used as relative
device.

.TP 7
.BI "Option \*qAccelerometer\*q \*q" bool \*q
Enable the 3 accelerometer-axes on the device (default disabled).

.TP 7
.BI "Option \*qLED[1-4]\*q \*q" bool \*q
Activate/deactivate the specified LED. All LEDs are deactivated by default.
Note that each LED must be enabled separately (e.g. LED4 will enable the
rightmost LED).

.TP 7
.BI "Option \*qButtonMapping\*q \*q" "1 3 4 5" \*q
Change button mapping. The supplied string specifies the button number for
each button in the following order: A, B, one, two, up, down, left, right,
minus, plus, home, z, c. Values must be space-separated.
Example: "7 8" makes A and B report as buttons 7 and 8.
.fi
Button numbering starts at 1.

.TP 7
.BI "Option \*qAxisMapping\*q \*q" "5 1 3 4" \*q
Change axis mapping. The supplied string specifies the axis number for
each axis in the following order: tilt(x), tilt(y), tilt(z),
accel(x), accel(y), accel(z), nunchuk(x), nunchuck(y), nunchuck(z),
nunchuck_joystick(x), nunchuck_joystick(y).
Example: "5 6" makes tilt(x) and tilt(y) report as axis 5 and 6.
.fi
Axis numbering starts at 1. IR always reports as axes 0 and 1 (see
.B BUGS
below). If IR is enabled and an AxisMapping is specified, the mapping will
only apply from axes 3 onwards (thus if tilt(y) is mapped to axis 1, it will
actually report as axis 3).

.PP
.SH NOTES
The wiimote reports the IR axis in its own special way. It divides the screen
into 9 segments, split up into quadratic boxes of 256 units length with a
same-sized box as spacer in between. This driver skips the spaces and reports
coordinates in one continuous coordinate system. That means although the
wiimote tells you 512, the actual coordinate reported by the driver is 256.
The resolution reported by the wiimote is 1024x768.
.fi

.PP
.SH BUGS
The X Input Extension does not cater for devices that can report both relative
and absolute axes. In the case of the wiimote this is bad, as tilt, the
nunchuk joystick and accelerometers do not make sense as absolute devices. IR
on the other hand doesn't make sense as relative devices.

The solution by this driver is the following: if IR is enabled, the IR axes
are always the first two axes (controlling the system cursor). Each time they
change, an event is sent to clients containing only the two IR axes as x/y
coordinates.

If any other devices are enabled and change state, a second event is sent that
contains all other axes. The IR axes (x/y) take on the last known state. So
for you that means if you get an event with (num_valuators == 2) say hello to
the IR values. Otherwise interpret the axes as desired. Sometimes gnawing
through your wrist may be the appropriate solution.

This forced IR mapping to x/y screws with the axis mapping specified in the
configuration. Read the above section on
.B AxisMapping
for further details.

.PP
.SH AUTHORS
Peter Hutterer <peter@cs.unisa.edu.au>
.fi
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__).
