/*
 * Copyright © 2007 Peter Hutterer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Soft-
 * ware"), to deal in the Software without restriction, including without
 * limitation the rights to use, copy, modify, merge, publish, distribute,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, provided that the above copyright
 * notice(s) and this permission notice appear in all copies of the Soft-
 * ware and that both the above copyright notice(s) and this permission
 * notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABIL-
 * ITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY
 * RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN
 * THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSE-
 * QUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFOR-
 * MANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or
 * other dealings in this Software without prior written authorization of
 * the copyright holder.
 *
 * Authors:
 *   Peter Hutterer <peter@cs.unisa.edu.au>
 */

#ifndef __DIAMONDTOUCH_H__
#define __DIAMONDTOUCH_H__ 1

#define _XF86_ANSIC_H
#define XF86_LIBC_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <X11/extensions/XI.h>
#include <xf86Xinput.h>

/* Magic definition from kernel driver */
#define DT_IOC_MAGIC   0xdd
#define DT_IOCGPARAMS _IOC(_IOC_READ, DT_IOC_MAGIC, 1, 0x40)

#define DFLT_DEVICE     "/dev/DiamondTouch"
#define DFLT_ROW_THRESH 60
#define DFLT_COL_THRESH 60
#define DFLT_SEARCHFUNC "SignalPeak"
#define DFLT_MOVE_THRESH 50
#define DFLT_DELIVER_BLOB   TRUE
#define DFLT_NOISELIMIT 5

#ifdef BLOB_SUPPORT
#define BLOBID_MASK ~(BlobStop | BlobContinue)
/**
 * used for blob detection
 */
typedef struct _blob {
    CARD32      iteration;
    CARD32      blobid;
    int         device;
    int         subdevice;
    int         x1;
    int         y1;
    int         x2;
    int         y2;
    int         hsx;
    int         hsy;
    uint32_t    datalen;
    char        *data;
    BOOL        dirty;
    int         marked;

    struct _blob *next;
} BlobRec, *BlobPtr;
#endif

typedef struct range {
    int         min;
    int         max;
} Range;

struct _DtDevice;

typedef struct _DtUser {
    int                 uid;
    unsigned char*      rows;
    unsigned char*      cols;
    unsigned char*      shield;
    BOOL                is_down;
    int                 last_x;
    int                 last_y;
    BOOL                deliver_blobs;

    /* configurable options */
    int                 row_thresh;     /* row threshold        */
    int                 col_thresh;     /* column threshold     */
    int                 move_thresh;    /* move threshold for continuation */
    int                 noiselimit;     /* deadzone in pixels */
    /* Search function for hotspot */
    int                 (*search_proc)(struct _DtDevice*, int, int*, int*);
#ifdef BLOB_SUPPORT
    BlobPtr             known_blobs;
#endif
} DtUserRec, *DtUserPtr;

/**
 * This struct is re-used for all devices with the same device name.
 * If more than one device is configured, each of those devices has its own
 * InputInfoPtr and DeviceIntRec, but pInfo->private will point to the same
 * DtDeviceRec.
 */
typedef struct _DtDevice {
    char*       device;
    int         packet_size;    /* nusers  * (rows + cols) + 4  */
    unsigned char* buffer;      /* read buffer                  */
    DtUserPtr   users;          /* (nusers * DtUserRec)         */
    int         fd;

    /* Attached devices */
    int         refcnt;         /* no of devices attached       */
    InputInfoPtr *attached;

    /* data as retrieved from EEPROM */
    int         pic_version;    /* PIC version number           */
    int         nusers;         /* number of supported users    */
    int         ncols;          /* number of columns            */
    int         nrows;          /* number of rows               */
    int         col_w;          /* column width                 */
    int         row_w;          /* row width                    */
    BOOL        rows_first;     /* rows before cols in packet?  */
    BOOL        left2right;     /* column orientation           */
    BOOL        top2bottom;     /* row orientation              */
    BOOL        shield_drv_on;  /* Shield drive on?             */
    int         tbu;            /* time between updates         */

    /* device options */
    int         buttons;
    int         axes;

    struct _DtDevice* next;
} DtDeviceRec, *DtDevicePtr;
#endif /* __DIAMONDTOUCH_H__ */

