//////////////////////////////////////////////////////////////////////////////
// Name:        TrigoKbd.cpp
// Purpose:     
// Author:      Alex Thuering
// Created:     2005/09/08
// RCS-ID:      $Id: TrigoKbd.cpp,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#include "TrigoKbd.h"

#include "calculette.h"
#include "ElementTransform.h"

BEGIN_EVENT_TABLE(TrigoKbd, SVGUIWindow)
  EVT_BUTTON (XRCID("boutoncos"), TrigoKbd::OnBoutonCosClick)
  EVT_BUTTON (XRCID("boutonsin"), TrigoKbd::OnBoutonSinClick)
  EVT_BUTTON (XRCID("boutontan"), TrigoKbd::OnBoutonTanClick)
  EVT_BUTTON (XRCID("boutonplus"), TrigoKbd::OnBoutonPlusClick)
  EVT_BUTTON (XRCID("boutonmoins"), TrigoKbd::OnBoutonMoinsClick)
END_EVENT_TABLE()

const double pi = 3.1415926;

TrigoKbd::TrigoKbd(wxWindow* parent):
 SVGUIWindow(parent)
{
	m_angle = 0;
	m_initialised = false;
	LoadFiles(wxT("TrigoKbd.svg"), wxT("TrigoKbd.def"));
	RefreshTrigoValues();
	SetFitToFrame(true);
	RefreshScale();
	Update();
}

void TrigoKbd::RefreshTrigoValues()
{
	if (!m_initialised)
		Initialize();
	SVGUITextCtrl* costext = (SVGUITextCtrl*)GetElementById(wxT("costext"));
	if (costext)
		costext->SetValue(wxString::Format(wxT("%.2f"), cos(m_angle*pi/180.0)));
	SVGUITextCtrl* sintext = (SVGUITextCtrl*)GetElementById(wxT("sintext"));
	if (sintext)
		sintext->SetValue(wxString::Format(wxT("%.2f"), sin(m_angle*pi/180.0)));
	SVGUITextCtrl* tantext = (SVGUITextCtrl*)GetElementById(wxT("tantext"));
	if (tantext)
		tantext->SetValue(wxString::Format(wxT("%.2f"), tan(m_angle*pi/180.0)));
	SVGUITextCtrl* angletext = (SVGUITextCtrl*)GetElementById(wxT("angletext"));
	if (angletext)
		angletext->SetValue(wxString::Format(wxT("%.2f"), m_angle));
	wxSVGElement* cercle_trigo = (wxSVGElement*)GetSVG()->GetElementById(wxT("cercle_trigo"));
	if (cercle_trigo)
	{
		wxSVGRect cercle_bbox = wxSVGLocatable::GetElementResultBBox(cercle_trigo, wxSVG_COORDINATES_VIEWPORT);
		ResetElementMatrix(cercle_trigo);
		RotateElement(cercle_trigo, m_angle);
		RefreshRect(cercle_bbox);
	}
}

void TrigoKbd::Initialize()
{
	m_initialised = true;
	wxSVGElement* cercle_trigo = (wxSVGElement*)GetSVG()->GetElementById(wxT("cercle_trigo"));
	if (cercle_trigo)
		InitElementMatrix(cercle_trigo);
}

void TrigoKbd::OnBoutonCosClick(wxCommandEvent& event)
{
	SVGUITextCtrl* costext = (SVGUITextCtrl*)GetElementById(wxT("costext"));
	if (costext)
	{
		wxString value = costext->GetValue();
		((Calculette*)wxWindow::GetParent())->SetNombreValue(value);
	}
}

void TrigoKbd::OnBoutonSinClick(wxCommandEvent& event)
{
	SVGUITextCtrl* sintext = (SVGUITextCtrl*)GetElementById(wxT("sintext"));
	if (sintext)
	{
		wxString value = sintext->GetValue();
		((Calculette*)wxWindow::GetParent())->SetNombreValue(value);
	}
}

void TrigoKbd::OnBoutonTanClick(wxCommandEvent& event)
{
	SVGUITextCtrl* tantext = (SVGUITextCtrl*)GetElementById(wxT("tantext"));
	if (tantext)
	{
		wxString value = tantext->GetValue();
		((Calculette*)wxWindow::GetParent())->SetNombreValue(value);
	}
}

void TrigoKbd::OnBoutonPlusClick(wxCommandEvent& event)
{
	m_angle += 10;
	RefreshTrigoValues();
}

void TrigoKbd::OnBoutonMoinsClick(wxCommandEvent& event)
{
	m_angle -= 10;
	RefreshTrigoValues();
}
