//////////////////////////////////////////////////////////////////////////////
// Name:        SVGUINoteBook.cpp
// Purpose:     
// Author:      Laurent Bessard
// Created:     2005/09/08
// RCS-ID:      $Id: SVGUINoteBook.cpp,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Laurent Bessard
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#include "SVGUINoteBook.h"
#include "SVGUIWindow.h"

SVGUINoteBook::SVGUINoteBook(wxSVGDocument* doc, wxEvtHandler* window): SVGUIControl(doc, window)
{
	m_current_page = 0;
	m_GroupElement = NULL;
	m_Page0Element = NULL;
	m_Page1Element = NULL;
	m_ContentElement = NULL;
	m_Page0Content = NULL;
	m_Page1Content = NULL;
	SetName(wxT("NoteBook"));
}

bool SVGUINoteBook::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("group_id"))
  	m_GroupElement = (wxSVGElement*)m_doc->GetElementById(attrValue);
  if (attrName == wxT("background_id"))
  	m_BackgroundElement = (wxSVGElement*)m_doc->GetElementById(attrValue);
  else if (attrName == wxT("page0_id"))
  	m_Page0Element = (wxSVGElement*)m_doc->GetElementById(attrValue);
  else if (attrName == wxT("page1_id"))
  	m_Page1Element = (wxSVGElement*)m_doc->GetElementById(attrValue);
  else if (attrName == wxT("content_id"))
  {
    m_ContentElement = (wxSVGElement*)m_doc->GetElementById(attrValue);
  	SetDisplay(m_ContentElement, wxCSS_VALUE_NONE);
  }
  else if (attrName == wxT("page0_content"))
  	m_Page0Content = ((SVGUIWindow*)m_window)->CreateWindow(attrValue);
  else if (attrName == wxT("page1_content"))
  	m_Page1Content = ((SVGUIWindow*)m_window)->CreateWindow(attrValue);
  else
    return false;
  return true;
}

bool SVGUINoteBook::HitTest(wxPoint pt)
{
	wxSVGRect rect(pt.x, pt.y, 1, 1);
	bool res=false;
	if (m_BackgroundElement)
		res |= m_doc->GetRootElement()->CheckIntersection(*m_BackgroundElement, rect);
	if (m_Page0Element)
		res |= m_doc->GetRootElement()->CheckIntersection(*m_Page0Element, rect);
	if (m_Page1Element)
		res |= m_doc->GetRootElement()->CheckIntersection(*m_Page1Element, rect);
	return res;
}

#define UpdateBBox_macro(element)\
		if (element)\
		{\
		  if (res.IsEmpty())\
			res = wxSVGLocatable::GetElementResultBBox(element, wxSVG_COORDINATES_VIEWPORT);\
	  	  else\
	  	  	res = SumBBox(res, wxSVGLocatable::GetElementResultBBox(element, wxSVG_COORDINATES_VIEWPORT));\
		}

wxSVGRect SVGUINoteBook::GetBBox()
{
	wxSVGRect res;
	UpdateBBox_macro(m_BackgroundElement)
	UpdateBBox_macro(m_Page0Element)
	UpdateBBox_macro(m_Page1Element)
	return res;
}

void SVGUINoteBook::Update_Elements()
{
	if (m_current_page == 0)
	{
		m_GroupElement->SetChildren((wxXmlElement*)m_Page1Element);
		m_Page1Element->SetNext((wxXmlElement*)m_BackgroundElement);
		m_BackgroundElement->SetNext((wxXmlElement*)m_Page0Element);
		m_Page0Element->SetNext(NULL);
		if (m_Page1Content)
			m_Page1Content->Hide();
		if (m_Page0Content)
			m_Page0Content->Show();
	}
	else if (m_current_page == 1)
	{
		m_GroupElement->SetChildren((wxXmlElement*)m_Page0Element);
		m_Page0Element->SetNext((wxXmlElement*)m_BackgroundElement);
		m_BackgroundElement->SetNext((wxXmlElement*)m_Page1Element);
		m_Page1Element->SetNext(NULL);
		if (m_Page0Content)
			m_Page0Content->Hide();
		if (m_Page1Content)
			m_Page1Content->Show();
	}
}

void SVGUINoteBook::RefreshContentSize(double scale)
{
	wxSVGRect rect = wxSVGLocatable::GetElementResultBBox(m_ContentElement, wxSVG_COORDINATES_VIEWPORT);
	wxPoint point((int)(rect.GetX()*scale),(int)(rect.GetY()*scale));
	wxSize size((int)(rect.GetWidth()*scale),(int)(rect.GetHeight()*scale));
	if (m_Page0Content)
	{
		m_Page0Content->Move(point);
		m_Page0Content->SetClientSize(size);
	}
	if (m_Page1Content)
	{
		m_Page1Content->Move(point);
		m_Page1Content->SetClientSize(size);
	}
}

void SVGUINoteBook::OnLeftDown(wxMouseEvent &event)
{
	wxSVGRect rect(event.GetX(), event.GetY(), 1, 1);
	if (m_Page0Element && m_doc->GetRootElement()->CheckIntersection(*m_Page0Element, rect) && m_current_page != 0)
	{
		m_current_page = 0;
		Update_Elements();
		Refresh();
		wxCommandEvent evt(wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED, wxXmlResource::GetXRCID(GetId()));
		m_window->ProcessEvent(evt);
	}
	else if (m_Page1Element && m_doc->GetRootElement()->CheckIntersection(*m_Page1Element, rect) && m_current_page != 1)
	{
		m_current_page = 1;
		Update_Elements();
		Refresh();
		wxCommandEvent evt(wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED, wxXmlResource::GetXRCID(GetId()));
		m_window->ProcessEvent(evt);
	}
	event.Skip();
}

void SVGUINoteBook::OnLeftUp(wxMouseEvent& event)
{
	event.Skip();
}

void SVGUINoteBook::OnMotion(wxMouseEvent& event)
{
	event.Skip();
}
