//////////////////////////////////////////////////////////////////////////////
// Name:        SVGUIContainer.cpp
// Purpose:     
// Author:      Laurent Bessard
// Created:     2005/08/05
// RCS-ID:      $Id: SVGUIContainer.cpp,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Laurent Bessard
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#include "SVGUIContainer.h"

SVGUIContainer::SVGUIContainer(wxSVGDocument* doc):
	SVGUIElement(doc)
{
	m_FocusedElement = NULL;
	SetName(wxT("Container"));
}

bool SVGUIContainer::HitTest(wxPoint pt)
{
	bool res = false;
    SVGUIElement* elem = NULL;
    SVGUIElement* n = (SVGUIElement*) GetChildren();
    while (n)
    {
    	if (n->HitTest(pt))
           elem = n;
        n = (SVGUIElement*)n->GetNext();
    }
    if (m_FocusedElement != elem && m_FocusedElement)
    {
    	if (m_FocusedElement->GetName() == wxT("TextCtrl"))
    		((SVGUITextCtrl*)m_FocusedElement)->SetSelected(false);
    }
    m_FocusedElement = elem;
    if (m_FocusedElement)
    {
		if (m_FocusedElement->GetName() == wxT("TextCtrl"))
    		((SVGUITextCtrl*)m_FocusedElement)->SetSelected(true);
    	res = true;
    }
    else if (m_BackgroundElement)
	{
		wxSVGRect rect(pt.x, pt.y, 1, 1);
		res = m_doc->GetRootElement()->CheckIntersection(*m_BackgroundElement, rect);
	}
	return res;
}

wxSVGRect SVGUIContainer::GetBBox()
{
	wxSVGRect res(0, 0, 0, 0);
	if (m_BackgroundElement)
		res = wxSVGLocatable::GetElementResultBBox(m_BackgroundElement, wxSVG_COORDINATES_VIEWPORT);
	return res;
}

void SVGUIContainer::Update_Elements()
{
	SVGUIElement* n = (SVGUIElement*) GetChildren();
    while (n)
    {
    	n->Update_Elements();
        n = (SVGUIElement*)n->GetNext();
    }
}

wxString SVGUIContainer::GetFocusedElement()
{
	if (m_FocusedElement)
		if (m_FocusedElement->GetName() == wxT("Container"))
			return ((SVGUIContainer*)m_FocusedElement)->GetFocusedElement();
		else
			return m_FocusedElement->GetId();
	else
		return GetId();
}

void SVGUIContainer::SendMouseEvent(wxMouseEvent& event)
{
	if (m_FocusedElement)
		m_FocusedElement->SendMouseEvent(event);
}

void SVGUIContainer::SendKeyEvent(wxKeyEvent& event)
{
	if (m_FocusedElement)
		m_FocusedElement->SendKeyEvent(event);
}
