//////////////////////////////////////////////////////////////////////////////
// Name:        SVGViewSpec.h
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by generate.py
//////////////////////////////////////////////////////////////////////////////

#ifndef WX_SVG_VIEW_SPEC_H
#define WX_SVG_VIEW_SPEC_H

class wxSVGElement;

#include "SVGZoomAndPan.h"
#include "SVGFitToViewBox.h"
#include "SVGTransformList.h"
#include "String.h"
#include "Element.h"

class wxSVGViewSpec:
  public wxSVGZoomAndPan,
  public wxSVGFitToViewBox
{
  protected:
    wxSVGTransformList m_transform;
    wxSVGElement* m_viewTarget;
    wxString m_viewBoxString;
    wxString m_preserveAspectRatioString;
    wxString m_transformString;
    wxString m_viewTargetString;

  public:
    inline const wxSVGTransformList& GetTransform() const { return m_transform; }
    inline void SetTransform(const wxSVGTransformList& n) { m_transform = n; }

    inline wxSVGElement* GetViewTarget() const { return m_viewTarget; }
    inline void SetViewTarget(wxSVGElement* n) { m_viewTarget = n; }

    inline const wxString& GetViewBoxString() const { return m_viewBoxString; }
    inline void SetViewBoxString(const wxString& n) { m_viewBoxString = n; }

    inline const wxString& GetPreserveAspectRatioString() const { return m_preserveAspectRatioString; }
    inline void SetPreserveAspectRatioString(const wxString& n) { m_preserveAspectRatioString = n; }

    inline const wxString& GetTransformString() const { return m_transformString; }
    inline void SetTransformString(const wxString& n) { m_transformString = n; }

    inline const wxString& GetViewTargetString() const { return m_viewTargetString; }
    inline void SetViewTargetString(const wxString& n) { m_viewTargetString = n; }

  public:
    wxSVGViewSpec(): m_viewTarget(NULL) {}
    virtual ~wxSVGViewSpec() {}
    bool HasAttribute(const wxString& name);
    wxString GetAttribute(const wxString& name);
    bool SetAttribute(const wxString& name, const wxString& value);
    wxXmlAttrHash GetAttributes() const;
};

#endif // WX_SVG_VIEW_SPEC_H
