/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocument;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.i18n.I18n;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Config;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.Misc;

public class SectionConverter
extends ConverterHelper {
    private boolean bNeedMulticol = false;
    private ExportNameCollection fileNames = new ExportNameCollection(true);

    public SectionConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bNeedMulticol) {
            pack.append("\\usepackage{multicol}").nl();
        }
    }

    public void handleSection(Element node, LaTeXDocumentPortion ldp, Context oc) {
        this.palette.getFieldCv().addTarget(node, "|region", ldp);
        String sFileName = null;
        Element source = Misc.getChildByTagName(node, "text:section-source");
        if (this.config.splitLinkedSections() && source != null) {
            sFileName = this.fileNames.getExportName(Misc.removeExtension(source.getAttribute("xlink:href")));
        } else if (this.config.splitToplevelSections() && this.isToplevel(node)) {
            sFileName = this.fileNames.getExportName(node.getAttribute("text:name"));
        }
        LaTeXDocumentPortion sectionLdp = ldp;
        if (sFileName != null) {
            LaTeXDocument newDoc = new LaTeXDocument(sFileName, this.config.getWrapLinesAfter());
            newDoc.setEncoding(I18n.writeJavaEncoding(this.config.getInputencoding()));
            this.palette.addDocument(newDoc);
            sectionLdp = newDoc.getContents();
        }
        String sStyleName = node.getAttribute("text:style-name");
        BeforeAfter ba = new BeforeAfter();
        Context ic = (Context)oc.clone();
        this.applySectionStyle(sStyleName, ba, ic);
        ldp.append(ba.getBefore());
        if (sFileName != null) {
            ldp.append("\\input{").append(sFileName).append("}").nl();
        }
        this.palette.getBlockCv().traverseBlockText(node, sectionLdp, ic);
        if (sectionLdp != ldp) {
            sectionLdp.append("\\endinput").nl();
        }
        ldp.append(ba.getAfter());
    }

    private void applySectionStyle(String sStyleName, BeforeAfter ba, Context context) {
        StyleWithProperties style = this.ofr.getSectionStyle(sStyleName);
        if (context.isInMulticols() || style == null || style.getColCount() < 2) {
            return;
        }
        int nCols = style.getColCount();
        this.bNeedMulticol = true;
        context.setInMulticols(true);
        ba.add("\\begin{multicols}{" + (nCols > 10 ? 10 : nCols) + "}\n", "\\end{multicols}\n");
    }

    private boolean isToplevel(Node node) {
        Node parent = node.getParentNode();
        if ("text:section".equals(parent.getNodeName())) {
            return false;
        }
        if ("office:body".equals(parent.getNodeName())) {
            return true;
        }
        return this.isToplevel(parent);
    }
}

