[comment {-*- tcl -*- doctools manpage}]
[manpage_begin nns n 1.1]
[copyright {2007 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Name service facility}]
[titledesc {Name service facility, Commandline Client Application}]
[description]
[para]

The application described by this document, [syscmd nns], is a simple
command line client for the nano name service facility provided by the
Tcllib packages [package nameserv], [package nameserv::common], and
[package nameserv::server]. Beyond that the application's sources also
serve as an example of how to use the client package. All abilities of
a client are covered, from configuration to registration of names to
searching.

[para]

[syscmd nns] is based upon the package [package nameserv]

[subsection {USE CASES}]

[syscmd nns] was written with the following two main use cases in
mind.

[para]
[list_begin enumerated]
[enum]
Registration of a name/data pair in the name service.

[enum]
Searching the name service for entries matching a glob pattern.

[list_end]

[para]

Beyond the above we also want to be able to identify the client, and
get information about the name service.

[subsection {COMMAND LINE}]

[list_begin definitions]

[call [cmd nns] [method bind] \
	[opt "[option -host] [arg host]"] \
	[opt "[option -port] [arg port]"] \
	[arg name] [arg data]]

This form registers the [arg name]/[arg data] pair in the specified
name service. In this form the command will [emph not] exit to keep
the registration alive. The user has to kill it explicitly, eithre by
sending a a signal, or through the job-control facilities of the shell
in use.

[para]
The options to specify the name service will be explained later, in
section [sectref OPTIONS].


[call [cmd nns] [method search] \
	[opt "[option -host] [arg host]"] \
	[opt "[option -port] [arg port]"] \
	[opt [option -continuous]] \
	[opt [arg pattern]]]

This form searches the specified name service for entries matching the
glob-[arg pattern] and prints them to stdout, with each entry on its
own line. If no pattern is specified it defaults to [const *],
matching everything.

[para]
The options to specify the name service will be explained later, in
section [sectref OPTIONS].

[para]

If the option [option -continuous] is specified the client will not exit
after performing the search, but start to continuously monitor the service
for changes to the set of matching entries, appropriately updating the
display as changes arrive.


[call [cmd nns] [method ident] \
	[opt "[option -host] [arg host]"] \
	[opt "[option -port] [arg port]"]]

This form asks the specified name service for the version and features
of the name service protocol it supports and prints the results to
stdout.

[para]
The options to specify the name service will be explained later, in
section [sectref OPTIONS].


[call [cmd nns] [method who]]

This form prints name, version, and protocol version of the
application to stdout.

[list_end]

[subsection OPTIONS]

This section describes all the options available to the user of the
application

[para]
[list_begin options]
[opt_def -host name|ipaddress]

If this option is not specified it defaults to [const localhost]. It
specifies the name or ip-address of the host the name service to talk
to is running on.

[opt_def -port number]

If this option is not specified it defaults to [const 38573]. It
specifies the TCP port the name service to talk to is listening on for
requests.

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the application it describes, will undoubtedly
contain bugs and other problems.

Please report such in the category [emph nameserv] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
application and/or documentation.


[see_also nameserv::common(n)]
[see_also nameserv(n)]
[keywords {name service} client application]
[manpage_end]
