#!/usr/bin/env ruby

$KCODE= 'e'

require '../src/suikyo'

class TestSuikyo
  def initialize ()
    @suikyo = SuikyoComposer.new()
    @suikyo.set_table("romaji", "../../conv-table/")
    @suikyo.set_reverse_table("romaji_reverse", "../../conv-table/")
  end

  def edit (string)
    if string.index("^") == 0 then
      string[1..-1].split(//).each { | command |
        case ( command )
        when "b" then
          @suikyo.cursor_left()
        when "a" then
          @suikyo.cursor_left_edge()
        when "f" then
          @suikyo.cursor_right()
        when "e" then
          @suikyo.cursor_right_edge()
        when "h" then
          @suikyo.edit_backspace()
        when "d" then
          @suikyo.edit_delete()
        when "1" then
          @suikyo.set_mode_default()
        when "6" then  # F6
          @suikyo.set_mode_hiragana()
        when "7" then  # F7
          @suikyo.set_mode_katakana()
        when "8" then  # F8
          @suikyo.set_mode_half_katakana()
        when "9" then  # F9
          @suikyo.set_mode_wide_ascii()
        when "0" then  # F10
          @suikyo.set_mode_raw()
        when "-" then
          @suikyo.edit_erase()
        when "!" then
          p @suikyo.edit_get_expansion()
        when "=" then
          p @suikyo.edit_get_preediting_string()
        when "?" then
          p @suikyo.edit_get_query_string()
        end
      }
    else
      @suikyo.edit_insert(string)
    end
    @suikyo.edit_display()
  end

  def main ()
    loop {
      print "> "
      line = $stdin.gets
      line.chomp!
      edit(line)
    }
  end
end

test = TestSuikyo.new()
test.main()


