/* # skkinput (Simple Kana-Kanji Input)
 * HistMgr.h --- header for history manager
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(HistMgr_h)
#define HistMgr_h
#include "kanji.h"

#define HISTORY_POSITION_MASK	(1<<0)
#define HISTORY_SIZE_MASK	(1<<1)
#define HISTORY_BUFFER_MASK	(1<<2)

typedef struct _historyListNode {
  unsigned short	mask ;
  /* Ѵ饤ȤΥɥɣġ줬ˤʤ롣*/
  Window	client ;
  /* Ϥ*/
  struct myChar	history[ TEXTBUFSIZE ] ;
  /* ʸ򵭲롣*/
  struct myChar	histcurbak[ TEXTBUFSIZE ] ;
  /* ХåեƬȺǸ塣*/
  int		history_start, history_end ;
  struct _historyListNode	*next ;

  /* ѴФ*/
  Boolean	egg_nl, chat_adapter, j_mode, j_zenkaku, j_katakana_mode ;
  /* ξѴ⡼ɤˤ뤫ɤ*/
  Boolean	overthespot_like_input ;
} HistoryListNode ;

/*
 * Prototype 
 */
HistoryListNode *history_setup( Widget gw, Window client_window ) ;
void history_close( Display *disp, caddr_t caller ) ;
void history_destroy( Window client_window ) ;
#endif
