#############################################################################
# File          : AbstractCheck.py
# Package       : rpmlint
# Author        : Frederic Lepied
# Created on    : Tue Sep 28 00:22:38 1999
# Version       : $Id: AbstractCheck.py 1328 2007-03-15 22:41:30Z scop $
# Purpose       : Abstract class to hold all the derived classes.
#############################################################################

class AbstractCheck:
    check_names_seen = []
    checks = []

    def __init__(self, name):
        if name not in AbstractCheck.check_names_seen:
            AbstractCheck.checks.append(self)
            AbstractCheck.check_names_seen.append(name)
        self.name = name

    def check(self, pkg):
        raise NotImplementedError('check must be implemented in subclass')


import re

class AbstractFilesCheck(AbstractCheck):
    def __init__(self, name, file_regexp):
        self.__files_re = re.compile(file_regexp)
        AbstractCheck.__init__(self, name)
    def check(self, pkg):
        if pkg.isSource():
            return
        files = []
        for f in pkg.files().keys():
            if self.__files_re.match(f):
                files.append(f)
        for i in files:
            self.check_file(pkg, i)

 
    def check_file(self, pkg, file):
        """ Virtual method called for each file that match the regexp passed to the constructor """
        raise NotImplementedError('check must be implemented in subclass')
        
# AbstractCheck.py ends here

# Local variables:
# indent-tabs-mode: nil
# py-indent-offset: 4
# End:
# ex: ts=4 sw=4 et
