# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"
require "nkf"

require "rast"
require "rast/filter"

module Rast
  module Filter
    load_mime_filter("pdf.rb")

    class ApplicationPDFTest < Test::Unit::TestCase
      def test_invoke
        invoke_test_simple_en
        invoke_test_simple_ja
        invoke_test_error
      end

      def invoke_test_simple_en
        filter = SpoofFilter.new("UTF-8")
        brigade = Brigade.new

        filename = File.join(MakeVariable::TOP_SRCDIR, "tests", "data",
                             "filter", "en", "pdfwriter.pdf")
        File.open(filename) do |f|
          brigade.insert_tail(FileBucket.new(f))
          brigade.insert_tail(EOSBucket.new)
          filter_module = ApplicationPDF.new
          filter_module.invoke(filter, brigade, "application/pdf")
        end

        brigades = []
        filter.passed.each do |passed|
          buckets = []
          passed.brigade.each do |bucket|
            buckets.push(bucket)
          end
          brigades.push(buckets)
        end

        assert_equal("text/plain", filter.passed[0].mime_type)
        buf = brigades[0][0].read
        assert_match(/PDF test/m, buf)
        assert_match(/This is PDF file./, buf)
        assert_match(/This page is Page 1./, buf)
        assert_equal(1, brigades[0].length)
        assert_match(/This page is Page 2./, brigades[1][0].read)
        assert_equal(1, brigades[1].length)
        assert_equal(true, brigades[2][0].eos?)
        assert_equal(1, brigades[2].length)
        assert_equal(3, brigades.length)
        assert_equal("PDF test", filter.properties["title"])
        assert_equal("PDF test", filter.properties["subject"])
        assert_equal("author", filter.properties["author"])
        assert_equal("PDF test", filter.properties["subject"])
        assert_equal("PDF test", filter.properties["title"])
        assert_equal(3, filter.properties.length)
        assert_equal(3, filter.passed.length)
      end

      def invoke_test_simple_ja
        filter = SpoofFilter.new("UTF-8")
        brigade = Brigade.new

        filename = File.join(MakeVariable::TOP_SRCDIR, "tests", "data",
                             "filter", "ja", "ooo-writer.pdf")
        File.open(filename) do |f|
          brigade.insert_tail(FileBucket.new(f))
          brigade.insert_tail(EOSBucket.new)
          filter_module = ApplicationPDF.new
          filter_module.invoke(filter, brigade, "application/pdf")
        end

        brigades = []
        filter.passed.each do |passed|
          buckets = []
          passed.brigade.each do |bucket|
            buckets.push(bucket)
          end
          brigades.push(buckets)
        end

        assert_equal("text/plain", filter.passed[0].mime_type)
        buf = brigades[0][0].read
        assert_match(/PDFテスト/m, buf)
        assert_match(/これは PDFファイルです。/, buf)
        assert_match(/PDF 本文 1 ページ目/, buf)
        assert_equal(1, brigades[0].length)
        assert_match(/PDF 本文 2 ページ目/, brigades[1][0].read)
        assert_equal(1, brigades[1].length)
        assert_equal(true, brigades[2][0].eos?)
        assert_equal(1, brigades[2].length)
        assert_equal(3, brigades.length)
        assert_equal("PDF テスト", filter.properties["title"])
        assert_equal(1, filter.properties.length)
        assert_equal(3, filter.passed.length)
      end

      def invoke_test_error
        filter = SpoofFilter.new("UTF-8")
        brigade = Brigade.new
        brigade.insert_tail(TransientBucket.new("invalid type file"))
        brigade.insert_tail(EOSBucket.new)
        filter_module = ApplicationPDF.new
        assert_raise(RastError) do
          filter_module.invoke(filter, brigade,
                               "application/pdf")
        end
      end
    end
  end
end
