# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"

require "rast_test"

module Rast
  class BrigadeTest < Test::Unit::TestCase
    def test_s_new
      brigade = Brigade.new
      brigade.each do |bucket|
        flunk("brigade has bucket: #{bucket.inspect}")
      end

      brigade = Brigade.new(TransientBucket.new("abcdef"), EOSBucket.new)
      ary = []
      brigade.each do |bucket|
        ary.push(bucket.read)
      end
      assert_equal("abcdef", ary[0])
      assert_equal("", ary[1])
      assert_equal(2, ary.length)

      assert_raise(TypeError) do
        Brigade.new("invalid argument")
      end
    end
  end
end
