/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#include "rast/util.h"

rast_error_t *
rast_apr_hash_to_rast_value_array(const rast_property_t *properties,
                                  int num_properties, apr_hash_t *values,
                                  rast_value_t **result, apr_pool_t *pool)
{
    rast_value_t *property_values;
    int i;

    property_values = (rast_value_t *)
        apr_palloc(pool, sizeof(rast_value_t) * num_properties);
    for (i = 0; i < num_properties; i++) {
        rast_value_t *value;
        const rast_property_t *property;

        property = &properties[i];
        value = apr_hash_get(values,
                             property->name, strlen(property->name));
        if (value == NULL) {
            /* todo: must register null value */
            switch (property->type) {
            case RAST_TYPE_STRING:
                rast_value_set_string(&property_values[i], "");
                break;
            case RAST_TYPE_DATE:
                rast_value_set_date(&property_values[i], "");
                break;
            case RAST_TYPE_DATETIME:
                rast_value_set_datetime(&property_values[i], "");
                break;
            case RAST_TYPE_UINT:
                rast_value_set_uint(&property_values[i], 0);
                break;
            default:
                return rast_error(RAST_ERROR_NOT_IMPLEMENTED,
                                  "null property value is not supported");
            }
        }
        else {
            property_values[i] = *value;
        }
    }

    *result = property_values;
    return RAST_OK;
}
