# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require File.join(File.dirname(__FILE__), "msoffice-property")

class ApplicationMSWord
  SUPPORTED_VERSION = 1
  MIME_TYPE = "application/msword"

  include ReadBucketsToFile
  include MSOfficeProperty

  private

  def process_file(filter, mime_type, path)
    db_encoding = filter.db_encoding
    s = ""
    IO.popen("wvHtml --charset=#{db_encoding} #{path} -") do |io|
      s = io.read
    end

    if !$?.success? && s.empty?
      raise Rast::RastError.new("failed to convert file")
    end

    bucket = Rast::TransientBucket.new(s)
    next_brigade = Rast::Brigade.new
    next_brigade.insert_tail(bucket)
    next_brigade.insert_tail(Rast::EOSBucket.new)
    filter.pass(next_brigade, "text/html; charset=#{db_encoding}")

    extract_property(filter, mime_type, path)
  end
end
