# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

class CombineLineendJapanese
  SUPPORTED_VERSION = 1
  NAME = "combine-lineend-japanese"

  def invoke(filter, brigade, mime_type)
    next_brigade = nil
    brigade.each do |bucket|
      if bucket.eos?
        if next_brigade.nil?
          next_brigade = Rast::Brigade.new
        end
        next_brigade.insert_tail(Rast::EOSBucket.new)
        break
      end

      buf = bucket.read
      s = buf.gsub(/([\x80-\xFF])\n([\x80-\xFF])/nm, "\\1\\2")

      bucket = Rast::TransientBucket.new(s)
      if next_brigade.nil?
        next_brigade = Rast::Brigade.new
      end
      next_brigade.insert_tail(bucket)
    end

    if next_brigade
      filter.pass(next_brigade, mime_type)
    end
  end
end
